/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LineItem
extends AtlasItem {
    private static final long serialVersionUID = -2053566750957119655L;
    private static final Logger logger = LoggerFactory.getLogger(LineItem.class);

    protected LineItem(Atlas atlas) {
        super(atlas);
    }

    @Override
    public JsonObject asGeoJsonGeometry() {
        return this.asPolyLine().asGeoJsonGeometry();
    }

    public abstract PolyLine asPolyLine();

    @Override
    public Rectangle bounds() {
        return this.asPolyLine().bounds();
    }

    @Override
    public Iterable<Location> getRawGeometry() {
        return this.asPolyLine();
    }

    @Override
    public boolean intersects(GeometricSurface surface) {
        return surface.overlaps(this.asPolyLine());
    }

    public boolean isClosed() {
        PolyLine polyLine = this.asPolyLine();
        return polyLine.first().equals(polyLine.last());
    }

    public boolean isZeroLength() {
        return this.length().equals(Distance.ZERO);
    }

    public Distance length() {
        return this.asPolyLine().length();
    }

    public int numberOfShapePoints() {
        return this.asPolyLine().size();
    }

    public Optional<Heading> overallHeading() {
        PolyLine polyLine = this.asPolyLine();
        if (polyLine.first().equals(polyLine.last())) {
            if (logger.isWarnEnabled()) {
                logger.warn("Cannot compute ({},{})'s overall heading when the polyline has same start and end locations : {}", new Object[]{this.getType(), this.getIdentifier(), polyLine.first().toWkt()});
            }
            return Optional.empty();
        }
        return this.asPolyLine().overallHeading();
    }

    @Override
    public GeoJsonBuilder.LocationIterableProperties toGeoJsonBuildingBlock() {
        Map<String, String> tags = this.getTags();
        tags.put("identifier", String.valueOf(this.getIdentifier()));
        tags.put("osmIdentifier", String.valueOf(this.getOsmIdentifier()));
        tags.put("itemType", String.valueOf((Object)this.getType()));
        Optional<String> shardName = this.getAtlas().metaData().getShardName();
        shardName.ifPresent(shard -> tags.put("shard", (String)shard));
        if (this instanceof Edge) {
            tags.put("startNode", String.valueOf(((Edge)this).start().getIdentifier()));
            tags.put("endNode", String.valueOf(((Edge)this).end().getIdentifier()));
        }
        StringList parentRelations = new StringList();
        this.relations().forEach(relation -> {
            RelationMember member = relation.members().get(this.getIdentifier(), this.getType());
            parentRelations.add(member.getRelationIdentifier() + "-" + member.getRole());
        });
        if (!parentRelations.isEmpty()) {
            tags.put("parentRelations", parentRelations.join(", "));
        }
        return new GeoJsonBuilder.LocationIterableProperties(this.getRawGeometry(), tags);
    }

    @Override
    public byte[] toWkb() {
        return this.asPolyLine().toWkb();
    }

    @Override
    public String toWkt() {
        return this.asPolyLine().toWkt();
    }

    @Override
    public boolean within(GeometricSurface surface) {
        return this.asPolyLine().within(surface);
    }
}

