/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.MaxSpeedTag;

public class DirectionalizedEdge
extends Edge {
    private static final long serialVersionUID = -1165815834787481668L;
    private final Edge source;

    protected DirectionalizedEdge(Edge source) {
        super(source.getAtlas());
        this.source = source;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.source.asPolyLine();
    }

    @Override
    public Edge directionalized() {
        return this;
    }

    @Override
    public Node end() {
        return this.source.end();
    }

    @Override
    public long getIdentifier() {
        return this.source.getIdentifier();
    }

    @Override
    public Map<String, String> getTags() {
        if (MaxSpeedTag.hasExtendedMaxSpeed(this.source)) {
            HashMap<String, String> tags = new HashMap<String, String>();
            this.source.getTags().forEach((? super K key, ? super V value) -> {
                if ("maxspeed:forward".equals(key)) {
                    if (this.source.isMasterEdge()) {
                        tags.put("maxspeed", (String)value);
                    }
                } else if ("maxspeed:backward".equals(key)) {
                    if (!this.source.isMasterEdge()) {
                        tags.put("maxspeed", (String)value);
                    }
                } else {
                    tags.put((String)key, (String)value);
                }
            });
            return tags;
        }
        return this.source.getTags();
    }

    @Override
    public Set<Relation> relations() {
        return this.source.relations();
    }

    @Override
    public Optional<Edge> reversed() {
        Optional<Edge> reversed = super.reversed();
        if (reversed.isPresent()) {
            return Optional.of(reversed.get().directionalized());
        }
        return reversed;
    }

    @Override
    public Node start() {
        return this.source.start();
    }
}

