/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.geojson;

import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasLoadingCommand;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasGeoJsonConverter
extends AtlasLoadingCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasGeoJsonConverter.class);
    private static final Command.Switch<File> GEOJSON = new Command.Switch("geojson", "The file where to save as GeoJson", File::new, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new AtlasGeoJsonConverter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Atlas atlas = this.loadAtlas(command);
        File output = (File)command.get(GEOJSON);
        atlas.saveAsGeoJson(output);
        logger.info("Saved to {}", (Object)output);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(GEOJSON);
    }
}

