/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicRelation;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class DynamicLine
extends Line {
    private static final long serialVersionUID = -7689258557279641445L;
    private final long identifier;

    protected DynamicLine(DynamicAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.subLine().asPolyLine();
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.subLine().getTags();
    }

    @Override
    public Set<Relation> relations() {
        return this.subLine().relations().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toSet());
    }

    private DynamicAtlas dynamicAtlas() {
        return (DynamicAtlas)this.getAtlas();
    }

    private Line subLine() {
        Line result = this.dynamicAtlas().subLine(this.identifier);
        if (result != null) {
            return result;
        }
        throw new CoreException("DynamicAtlas {} moved too fast! {} {} is missing now.", this.dynamicAtlas().getName(), this.getClass().getSimpleName(), this.identifier);
    }
}

