/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.BareAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicArea;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlasExpander;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicEdge;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicLine;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicNode;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicPoint;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicRelation;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class DynamicAtlas
extends BareAtlas {
    private static final long serialVersionUID = -2858997785405677961L;
    private Atlas current;
    private final DynamicAtlasExpander expander;

    public DynamicAtlas(DynamicAtlasPolicy dynamicAtlasExpansionPolicy) {
        this.setName("DynamicAtlas(" + dynamicAtlasExpansionPolicy.getInitialShards().stream().map(Shard::getName).collect(Collectors.toSet()) + ")");
        this.expander = new DynamicAtlasExpander(this, dynamicAtlasExpansionPolicy);
    }

    @Override
    public Area area(long identifier) {
        Iterator<DynamicArea> result = this.expander.expand(() -> Iterables.from(this.subArea(identifier)), this.expander::areaCovered, this::newArea).iterator();
        return result.hasNext() ? (Area)result.next() : null;
    }

    @Override
    public Iterable<Area> areas() {
        return this.expander.expand(() -> this.current.areas(), this.expander::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasCovering(Location location) {
        return this.expander.expand(() -> this.current.areasCovering(location), this.expander::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasCovering(Location location, Predicate<Area> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.areasCovering(location), this.expander::areaCovered, this::newArea), matcher);
    }

    @Override
    public Iterable<Area> areasIntersecting(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.areasIntersecting(surface), this.expander::areaCovered, this::newArea);
    }

    @Override
    public Iterable<Area> areasIntersecting(GeometricSurface surface, Predicate<Area> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.areasIntersecting(surface), this.expander::areaCovered, this::newArea), matcher);
    }

    @Override
    public Iterable<Area> areasWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.areasWithin(surface), this.expander::areaCovered, this::newArea);
    }

    @Override
    public Rectangle bounds() {
        return this.current.bounds();
    }

    @Override
    public Edge edge(long identifier) {
        Iterator<DynamicEdge> result = this.expander.expand(() -> Iterables.from(this.subEdge(identifier)), this.expander::lineItemCovered, this::newEdge).iterator();
        return result.hasNext() ? (Edge)result.next() : null;
    }

    @Override
    public Iterable<Edge> edges() {
        return this.expander.expand(() -> this.current.edges(), this.expander::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location) {
        return this.expander.expand(() -> this.current.edgesContaining(location), this.expander::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location, Predicate<Edge> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.edgesContaining(location), this.expander::lineItemCovered, this::newEdge), matcher);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.edgesIntersecting(surface), this.expander::lineItemCovered, this::newEdge);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(GeometricSurface surface, Predicate<Edge> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.edgesIntersecting(surface), this.expander::lineItemCovered, this::newEdge), matcher);
    }

    @Override
    public Iterable<Edge> edgesWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.edgesWithin(surface), this.expander::lineItemCovered, this::newEdge);
    }

    public Set<Atlas> getAtlasesLoaded() {
        return this.expander.getLoadedShards().values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public int getNumberOfShardsLoaded() {
        return this.getShardsLoaded().size();
    }

    public DynamicAtlasPolicy getPolicy() {
        return this.expander.getPolicy();
    }

    public Set<Shard> getShardsExplored() {
        return this.expander.getLoadedShards().keySet();
    }

    public Set<Shard> getShardsLoaded() {
        return this.expander.getLoadedShards().entrySet().stream().filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int getTimesMultiAtlasWasBuiltUnderneath() {
        return this.expander.getTimesMultiAtlasWasBuiltUnderneath();
    }

    @Override
    public Line line(long identifier) {
        Iterator<DynamicLine> result = this.expander.expand(() -> Iterables.from(this.subLine(identifier)), this.expander::lineItemCovered, this::newLine).iterator();
        return result.hasNext() ? (Line)result.next() : null;
    }

    @Override
    public Iterable<Line> lines() {
        return this.expander.expand(() -> this.current.lines(), this.expander::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesContaining(Location location) {
        return this.expander.expand(() -> this.current.linesContaining(location), this.expander::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesContaining(Location location, Predicate<Line> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.linesContaining(location), this.expander::lineItemCovered, this::newLine), matcher);
    }

    @Override
    public Iterable<Line> linesIntersecting(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.linesIntersecting(surface), this.expander::lineItemCovered, this::newLine);
    }

    @Override
    public Iterable<Line> linesIntersecting(GeometricSurface surface, Predicate<Line> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.linesIntersecting(surface), this.expander::lineItemCovered, this::newLine), matcher);
    }

    @Override
    public Iterable<Line> linesWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.linesWithin(surface), this.expander::lineItemCovered, this::newLine);
    }

    @Override
    public AtlasMetaData metaData() {
        return this.current.metaData();
    }

    @Override
    public Node node(long identifier) {
        Iterator<DynamicNode> result = this.expander.expand(() -> Iterables.from(this.subNode(identifier)), this.expander::locationItemCovered, this::newNode).iterator();
        return result.hasNext() ? (Node)result.next() : null;
    }

    @Override
    public Iterable<Node> nodes() {
        return this.expander.expand(() -> this.current.nodes(), this.expander::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesAt(Location location) {
        return this.expander.expand(() -> this.current.nodesAt(location), this.expander::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.nodesWithin(surface), this.expander::locationItemCovered, this::newNode);
    }

    @Override
    public Iterable<Node> nodesWithin(GeometricSurface surface, Predicate<Node> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.nodesWithin(surface), this.expander::locationItemCovered, this::newNode), matcher);
    }

    @Override
    public long numberOfAreas() {
        return this.current.numberOfAreas();
    }

    @Override
    public long numberOfEdges() {
        return this.current.numberOfEdges();
    }

    @Override
    public long numberOfLines() {
        return this.current.numberOfLines();
    }

    @Override
    public long numberOfNodes() {
        return this.current.numberOfNodes();
    }

    @Override
    public long numberOfPoints() {
        return this.current.numberOfPoints();
    }

    @Override
    public long numberOfRelations() {
        return this.current.numberOfRelations();
    }

    @Override
    public Point point(long identifier) {
        Iterator<DynamicPoint> result = this.expander.expand(() -> Iterables.from(this.subPoint(identifier)), this.expander::locationItemCovered, this::newPoint).iterator();
        return result.hasNext() ? (Point)result.next() : null;
    }

    @Override
    public Iterable<Point> points() {
        return this.expander.expand(() -> this.current.points(), this.expander::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsAt(Location location) {
        return this.expander.expand(() -> this.current.pointsAt(location), this.expander::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.pointsWithin(surface), this.expander::locationItemCovered, this::newPoint);
    }

    @Override
    public Iterable<Point> pointsWithin(GeometricSurface surface, Predicate<Point> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.pointsWithin(surface), this.expander::locationItemCovered, this::newPoint), matcher);
    }

    public void preemptiveLoad() {
        this.expander.preemptiveLoad();
    }

    @Override
    public Relation relation(long identifier) {
        Iterator<DynamicRelation> result = this.expander.expand(() -> Iterables.from(this.subRelation(identifier)), this.expander::relationCovered, this::newRelation).iterator();
        return result.hasNext() ? (Relation)result.next() : null;
    }

    @Override
    public Iterable<Relation> relations() {
        return this.expander.expand(() -> this.current.relations(), this.expander::relationCovered, this::newRelation);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.relationsWithEntitiesIntersecting(surface), this.expander::relationCovered, this::newRelation);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface surface, Predicate<Relation> matcher) {
        return Iterables.filter(this.expander.expand(() -> this.current.relationsWithEntitiesIntersecting(surface), this.expander::relationCovered, this::newRelation), matcher);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesWithin(GeometricSurface surface) {
        return this.expander.expand(() -> this.current.relationsWithEntitiesWithin(surface), this.expander::relationCovered, this::newRelation);
    }

    @Override
    public void save(WritableResource writableResource) {
        throw new CoreException("DynamicAtlas cannot be saved");
    }

    protected Area subArea(long identifier) {
        return this.current.area(identifier);
    }

    protected Edge subEdge(long identifier) {
        return this.current.edge(identifier);
    }

    protected Line subLine(long identifier) {
        return this.current.line(identifier);
    }

    protected Node subNode(long identifier) {
        return this.current.node(identifier);
    }

    protected Point subPoint(long identifier) {
        return this.current.point(identifier);
    }

    protected Relation subRelation(long identifier) {
        return this.current.relation(identifier);
    }

    synchronized void swapCurrentAtlas(Atlas current) {
        this.current = current;
    }

    private DynamicArea newArea(Area area) {
        return new DynamicArea(this, area.getIdentifier());
    }

    private DynamicEdge newEdge(Edge edge) {
        return new DynamicEdge(this, edge.getIdentifier());
    }

    private DynamicLine newLine(Line line) {
        return new DynamicLine(this, line.getIdentifier());
    }

    private DynamicNode newNode(Node node) {
        return new DynamicNode(this, node.getIdentifier());
    }

    private DynamicPoint newPoint(Point point) {
        return new DynamicPoint(this, point.getIdentifier());
    }

    private DynamicRelation newRelation(Relation relation) {
        return new DynamicRelation(this, relation.getIdentifier());
    }
}

