/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.delta;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.delta.AtlasDelta;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDeltaGenerator
extends Command {
    private static final int DEFAULT_THREADS = 8;
    private static final int COMMAND_LINE_USAGE_ERROR_EXIT = 64;
    private static final Command.Switch<Path> BEFORE_SWITCH = new Command.Switch("before", "The before atlas directory or file from which to delta.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> AFTER_SWITCH = new Command.Switch("after", "The after atlas directory or file that the before atlas deltas to.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_DIRECTORY_SWITCH = new Command.Switch("outputDirectory", "The path of the output directory.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Integer> THREADS_SWITCH = new Command.Switch("threads", "The number of threads to work on processing atlas shards.", Integer::valueOf, Command.Optionality.OPTIONAL, String.valueOf(8));
    private static final AtlasResourceLoader ATLAS_RESOURCE_LOADER = new AtlasResourceLoader();
    private final Logger logger;
    private int threads = 8;

    public static void main(String[] args) {
        new AtlasDeltaGenerator(LoggerFactory.getLogger(AtlasDeltaGenerator.class)).run(args);
    }

    private static List<File> fetchAtlasFilesInDirectory(Path directory) {
        return new File(directory.toFile()).listFilesRecursively().stream().filter(AtlasResourceLoader.HAS_ATLAS_EXTENSION).collect(Collectors.toList());
    }

    public AtlasDeltaGenerator(Logger logger) {
        this.logger = logger;
    }

    @Override
    protected int onRun(CommandMap command) {
        Path before = (Path)command.get("before");
        Path after = (Path)command.get("after");
        Path outputDirectory = (Path)command.get("outputDirectory");
        this.threads = (Integer)command.get("threads");
        this.run(before, after, outputDirectory);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BEFORE_SWITCH, AFTER_SWITCH, OUTPUT_DIRECTORY_SWITCH, THREADS_SWITCH);
    }

    private void compare(Atlas beforeAtlas, Atlas afterAtlas, Path outputDirectory) {
        String name = FilenameUtils.removeExtension(beforeAtlas.getName());
        AtlasDelta delta = new AtlasDelta(beforeAtlas, afterAtlas).generate();
        String text = delta.toDiffViewFriendlyString();
        File textFile = new File(outputDirectory.resolve(name + FileSuffix.TEXT.toString()).toFile());
        textFile.writeAndClose(text);
        this.logger.info("Saved text file {}", (Object)textFile);
        String geoJson = delta.toGeoJson();
        File geoJsonFile = new File(outputDirectory.resolve(name + FileSuffix.GEO_JSON.toString()).toFile());
        geoJsonFile.writeAndClose(geoJson);
        this.logger.info("Saved GeoJSON file {}", (Object)geoJsonFile);
        String relationsGeoJson = delta.toRelationsGeoJson();
        String relationsGeoJsonFileName = name + "_relations" + FileSuffix.GEO_JSON.toString();
        File relationsGeoJsonFile = new File(outputDirectory.resolve(relationsGeoJsonFileName).toFile());
        relationsGeoJsonFile.writeAndClose(relationsGeoJson);
        this.logger.info("Saved Relations GeoJSON file {}", (Object)relationsGeoJsonFile);
    }

    private void compareShardByShard(Path before, Path after, Path outputDirectory) {
        List<File> afterShardFiles = AtlasDeltaGenerator.fetchAtlasFilesInDirectory(after);
        afterShardFiles.parallelStream().forEach(afterShardFile -> {
            Path beforeShardPath = before.resolve(afterShardFile.getName());
            Atlas beforeAtlas = this.load(beforeShardPath);
            Atlas afterAtlas = ATLAS_RESOURCE_LOADER.load((Resource)afterShardFile);
            this.compare(beforeAtlas, afterAtlas, outputDirectory);
        });
    }

    private Atlas load(Path path) {
        return ATLAS_RESOURCE_LOADER.load(new File(path.toFile()));
    }

    private void run(Path before, Path after, Path outputDirectory) {
        Time time = Time.now();
        this.logger.info("Comparing {} and {}", (Object)before, (Object)after);
        if (after.toFile().isDirectory()) {
            if (!before.toFile().isDirectory()) {
                this.logger.error("Your -before parameter must point to a directory of atlas shards if you want to compare shard by shard with an -after directory also of shards!");
                System.exit(64);
            }
            try (Pool pool = new Pool(this.threads, "atlas-diff-worker");){
                pool.queue(() -> this.compareShardByShard(before, after, outputDirectory));
            }
        } else {
            Atlas beforeAtlas = this.load(before);
            Atlas afterAtlas = this.load(after);
            this.compare(beforeAtlas, afterAtlas, outputDirectory);
        }
        this.logger.info("AtlasDeltaGenerator complete. Total time: {}.", (Object)time.elapsedSince());
    }
}

