/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.delta;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.delta.Diff;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.matching.PolyLineRoute;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.statistic.storeless.CounterWithStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDelta
implements Serializable {
    private static final long serialVersionUID = 1189641317938152158L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasDelta.class);
    private static final int COUNTER_REPORT = 100000;
    private final Atlas before;
    private final Atlas after;
    private final SortedSet<Diff> differences;
    private final boolean withGeometryMatching;
    private final transient CounterWithStatistic counter;

    public AtlasDelta(Atlas before, Atlas after) {
        this(before, after, false);
    }

    public AtlasDelta(Atlas before, Atlas after, boolean withGeometryMatching) {
        this.before = before;
        this.after = after;
        this.differences = new TreeSet<Diff>();
        this.counter = new CounterWithStatistic(logger, 100000L, "Processed");
        this.withGeometryMatching = withGeometryMatching;
    }

    public AtlasDelta generate() {
        logger.info("Looking for removed items.");
        for (AtlasEntity entity : this.before) {
            this.counter.increment();
            if (entity.getType().entityForIdentifier(this.after, entity.getIdentifier()) != null || entity instanceof Edge && this.hasGoodMatch((Edge)entity, this.after)) continue;
            this.differences.add(new Diff(entity.getType(), Diff.DiffType.REMOVED, Diff.DiffReason.REMOVED, this.before, this.after, entity.getIdentifier()));
        }
        logger.info("Looking for added items.");
        for (AtlasEntity entity : this.after) {
            this.counter.increment();
            if (entity.getType().entityForIdentifier(this.before, entity.getIdentifier()) != null || entity instanceof Edge && this.hasGoodMatch((Edge)entity, this.before)) continue;
            this.differences.add(new Diff(entity.getType(), Diff.DiffType.ADDED, Diff.DiffReason.ADDED, this.before, this.after, entity.getIdentifier()));
        }
        logger.info("Looking for changed items.");
        for (AtlasEntity baseEntity : this.before) {
            this.counter.increment();
            long identifier = baseEntity.getIdentifier();
            AtlasEntity alterEntity = baseEntity.getType().entityForIdentifier(this.after, baseEntity.getIdentifier());
            if (alterEntity == null) continue;
            if (!baseEntity.getTags().equals(alterEntity.getTags())) {
                this.differences.add(new Diff(baseEntity.getType(), Diff.DiffType.CHANGED, Diff.DiffReason.TAGS, this.before, this.after, identifier));
                continue;
            }
            if (this.differentInRelation(baseEntity, alterEntity)) {
                this.differences.add(new Diff(baseEntity.getType(), Diff.DiffType.CHANGED, Diff.DiffReason.RELATION_MEMBER, this.before, this.after, identifier));
                continue;
            }
            if (baseEntity instanceof Node) {
                if (!this.differentNodes((Node)baseEntity, (Node)alterEntity)) continue;
                this.differences.add(new Diff(ItemType.NODE, Diff.DiffType.CHANGED, Diff.DiffReason.GEOMETRY_OR_TOPOLOGY, this.before, this.after, identifier));
                continue;
            }
            if (baseEntity instanceof Edge) {
                if (!this.differentEdges((Edge)baseEntity, (Edge)alterEntity)) continue;
                this.differences.add(new Diff(ItemType.EDGE, Diff.DiffType.CHANGED, Diff.DiffReason.GEOMETRY_OR_TOPOLOGY, this.before, this.after, identifier));
                continue;
            }
            if (baseEntity instanceof Area) {
                if (!this.differentAreas((Area)baseEntity, (Area)alterEntity)) continue;
                this.differences.add(new Diff(ItemType.AREA, Diff.DiffType.CHANGED, Diff.DiffReason.GEOMETRY_OR_TOPOLOGY, this.before, this.after, identifier));
                continue;
            }
            if (baseEntity instanceof Line) {
                if (!this.differentLines((Line)baseEntity, (Line)alterEntity)) continue;
                this.differences.add(new Diff(ItemType.LINE, Diff.DiffType.CHANGED, Diff.DiffReason.GEOMETRY_OR_TOPOLOGY, this.before, this.after, identifier));
                continue;
            }
            if (baseEntity instanceof Point) {
                if (!this.differentPoints((Point)baseEntity, (Point)alterEntity)) continue;
                this.differences.add(new Diff(ItemType.POINT, Diff.DiffType.CHANGED, Diff.DiffReason.GEOMETRY_OR_TOPOLOGY, this.before, this.after, identifier));
                continue;
            }
            if (!(baseEntity instanceof Relation) || !this.differentRelations((Relation)baseEntity, (Relation)alterEntity)) continue;
            this.differences.add(new Diff(ItemType.RELATION, Diff.DiffType.CHANGED, Diff.DiffReason.RELATION_TOPOLOGY, this.before, this.after, identifier));
        }
        this.counter.summary();
        return this;
    }

    public Atlas getAfter() {
        return this.after;
    }

    public Atlas getBefore() {
        return this.before;
    }

    public SortedSet<Diff> getDifferences() {
        return this.differences;
    }

    public String toDiffViewFriendlyString() {
        return Diff.toDiffViewFriendlyString(this.differences);
    }

    public String toGeoJson() {
        return Diff.toGeoJson(this.differences);
    }

    public String toGeoJson(Predicate<Diff> filter) {
        return Diff.toGeoJson(this.differences, filter);
    }

    public String toRelationsGeoJson() {
        return Diff.toRelationsGeoJson(this.differences);
    }

    public String toRelationsGeoJson(Predicate<Diff> filter) {
        return Diff.toRelationsGeoJson(this.differences, filter);
    }

    public String toString() {
        return Diff.toString(this.differences);
    }

    private boolean differentAreas(Area baseArea, Area alterArea) {
        try {
            return !baseArea.asPolygon().equals(alterArea.asPolygon());
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare areas {} and {}", baseArea, alterArea, e);
        }
    }

    private boolean differentEdgeSet(SortedSet<Edge> baseEdges, SortedSet<Edge> alterEdges) {
        boolean differentEdgeSetBasic = this.differentEdgeSetBasic(baseEdges, alterEdges);
        boolean differentEdgeSetWithMatch = this.differentEdgeSetWithMatch(baseEdges, alterEdges);
        return differentEdgeSetBasic && differentEdgeSetWithMatch;
    }

    private boolean differentEdgeSetBasic(SortedSet<Edge> baseEdges, SortedSet<Edge> alterEdges) {
        if (baseEdges.size() != alterEdges.size()) {
            return true;
        }
        Iterator baseInEdgeIterator = baseEdges.iterator();
        Iterator alterInEdgeIterator = alterEdges.iterator();
        for (int i = 0; i < baseEdges.size(); ++i) {
            Edge baseInEdge = (Edge)baseInEdgeIterator.next();
            Edge alterInEdge = (Edge)alterInEdgeIterator.next();
            if (baseInEdge.getIdentifier() == alterInEdge.getIdentifier()) continue;
            return true;
        }
        return false;
    }

    private boolean differentEdgeSetWithMatch(Set<Edge> baseEdges, Set<Edge> alterEdges) {
        if (baseEdges.isEmpty() && alterEdges.isEmpty()) {
            return false;
        }
        boolean baseToAlterResult = baseEdges.isEmpty();
        for (Edge edge : baseEdges) {
            if (!alterEdges.isEmpty() && this.hasPerfectMatch(edge, alterEdges)) continue;
            baseToAlterResult = true;
            break;
        }
        boolean alterToBaseResult = alterEdges.isEmpty();
        for (Edge edge : alterEdges) {
            if (!baseEdges.isEmpty() && this.hasPerfectMatch(edge, baseEdges)) continue;
            alterToBaseResult = true;
            break;
        }
        return baseToAlterResult && alterToBaseResult;
    }

    private boolean differentEdges(Edge baseEdge, Edge alterEdge) {
        try {
            boolean result = false;
            if (!baseEdge.asPolyLine().equals(alterEdge.asPolyLine())) {
                result = true;
            }
            if (!result && baseEdge.start().getIdentifier() != alterEdge.start().getIdentifier()) {
                result = true;
            }
            if (!result && baseEdge.end().getIdentifier() != alterEdge.end().getIdentifier()) {
                result = true;
            }
            if (result) {
                result = !this.hasGoodMatch(baseEdge, alterEdge.getAtlas());
            }
            return result;
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare edges {} and {}", baseEdge, alterEdge, e);
        }
    }

    private boolean differentInRelation(AtlasEntity baseEntity, AtlasEntity alterEntity) {
        try {
            Set<Relation> baseRelations = baseEntity.relations();
            Set<Relation> alterRelations = alterEntity.relations();
            if (baseRelations.size() != alterRelations.size()) {
                return true;
            }
            for (Relation baseRelation : baseRelations) {
                int j;
                Relation alterRelation = null;
                for (Relation alterRelationCandidate : alterRelations) {
                    if (alterRelationCandidate.getIdentifier() != baseRelation.getIdentifier()) continue;
                    alterRelation = alterRelationCandidate;
                    break;
                }
                if (alterRelation == null) {
                    return true;
                }
                int baseIndex = -1;
                int alterIndex = -1;
                RelationMemberList baseMembers = baseRelation.members();
                RelationMemberList alterMembers = alterRelation.members();
                for (j = 0; j < baseMembers.size(); ++j) {
                    RelationMember baseMember = baseMembers.get(j);
                    if (baseMember.getEntity().getIdentifier() != baseEntity.getIdentifier()) continue;
                    baseIndex = j;
                }
                for (j = 0; j < alterMembers.size(); ++j) {
                    RelationMember alterMember = alterMembers.get(j);
                    if (alterMember.getEntity().getIdentifier() != baseEntity.getIdentifier()) continue;
                    alterIndex = j;
                }
                if (baseIndex < 0 || alterIndex < 0) {
                    throw new CoreException("Corrupted Atlas dataset.");
                }
                if (baseIndex != alterIndex) {
                    return true;
                }
                if (!baseMembers.get(baseIndex).getRole().equals(alterMembers.get(alterIndex).getRole())) {
                    return true;
                }
                if (baseMembers.get(baseIndex).getEntity().getType() == alterMembers.get(alterIndex).getEntity().getType()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare relations for {} and {}", baseEntity, alterEntity, e);
        }
    }

    private boolean differentLines(Line baseLine, Line alterLine) {
        try {
            return !baseLine.asPolyLine().equals(alterLine.asPolyLine());
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare line geometries for {} and {}", baseLine, alterLine, e);
        }
    }

    private boolean differentNodes(Node baseNode, Node alterNode) {
        try {
            if (!baseNode.getLocation().equals(alterNode.getLocation())) {
                return true;
            }
            if (this.differentEdgeSet(baseNode.inEdges(), alterNode.inEdges())) {
                return true;
            }
            return this.differentEdgeSet(baseNode.outEdges(), alterNode.outEdges());
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare nodes {} and {}", baseNode, alterNode, e);
        }
    }

    private boolean differentPoints(Point basePoint, Point alterPoint) {
        try {
            return !basePoint.getLocation().equals(alterPoint.getLocation());
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare points {} and {}", basePoint, alterPoint, e);
        }
    }

    private boolean differentRelationMemberListsWithMatch(RelationMemberList baseMembers, RelationMemberList alterMembers) {
        SortedSet<Edge> baseEdges = Iterables.stream(baseMembers).map(member -> member.getEntity()).filter(entity -> entity instanceof Edge).map(entity -> (Edge)entity).collectToSortedSet();
        SortedSet<Edge> alterEdges = Iterables.stream(alterMembers).map(member -> member.getEntity()).filter(entity -> entity instanceof Edge).map(entity -> (Edge)entity).collectToSortedSet();
        return this.differentEdgeSet(baseEdges, alterEdges);
    }

    private boolean differentRelations(Relation baseRelation, Relation alterRelation) {
        try {
            RelationMemberList baseMembers = baseRelation.members();
            RelationMemberList alterMembers = alterRelation.members();
            return !baseMembers.equals(alterMembers) && !this.differentRelationMemberListsWithMatch(baseMembers, alterMembers);
        }
        catch (Exception e) {
            throw new CoreException("Unable to compare relations {} and {}", baseRelation, alterRelation, e);
        }
    }

    private boolean hasGoodMatch(Edge edge, Atlas other) {
        if (this.withGeometryMatching) {
            Rectangle bounds = edge.bounds();
            return this.hasPerfectMatch(edge, other.edgesIntersecting(bounds, otherEdge -> edge.getOsmIdentifier() == otherEdge.getOsmIdentifier()));
        }
        return false;
    }

    private boolean hasPerfectMatch(Edge edge, Iterable<Edge> otherEdges) {
        List<PolyLine> candidates;
        PolyLine source;
        Optional<PolyLineRoute> match;
        if (this.withGeometryMatching && (match = (source = edge.asPolyLine()).costDistanceToOneWay(candidates = Iterables.stream(otherEdges).map(LineItem::asPolyLine).collectToList()).match(Distance.ZERO)).isPresent() && match.get().getCost().isLessThanOrEqualTo(Distance.ZERO)) {
            logger.trace("Edge {} from {} has no equal member but found a match with no cost.", (Object)edge, (Object)edge.getAtlas().getName());
            return true;
        }
        return false;
    }
}

