/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLocationItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompletePoint
extends Point
implements CompleteLocationItem<CompletePoint> {
    private static final long serialVersionUID = 309534717673911086L;
    private Rectangle bounds;
    private long identifier;
    private Location location;
    private Map<String, String> tags;
    private Set<Long> relationIdentifiers;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();

    public static CompletePoint from(Point point) {
        if (point instanceof CompletePoint && !((CompletePoint)point).isFull()) {
            throw new CoreException("Point parameter was a CompletePoint but it was not full: {}", point);
        }
        return new CompletePoint(point.getIdentifier(), point.getLocation(), point.getTags(), point.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompletePoint shallowFrom(Point point) {
        if (point.bounds() == null) {
            throw new CoreException("Point parameter bounds were null");
        }
        return new CompletePoint(point.getIdentifier()).withBoundsExtendedBy(point.bounds());
    }

    public CompletePoint(Long identifier, Location location, Map<String, String> tags, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = location != null ? location.bounds() : null;
        this.identifier = identifier;
        this.location = location;
        this.tags = tags;
        this.relationIdentifiers = relationIdentifiers;
    }

    CompletePoint(long identifier) {
        this(identifier, null, null, null);
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.POINT;
    }

    public CompletePoint copy() {
        return new CompletePoint(this.identifier, this.location, this.tags, this.relationIdentifiers);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompletePoint) {
            CompletePoint that = (CompletePoint)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.getLocation(), that.getLocation());
        }
        return false;
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isFull() {
        return this.bounds != null && this.location != null && this.tags != null && this.relationIdentifiers != null;
    }

    @Override
    public boolean isShallow() {
        return this.location == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public String prettify(PrettifyStringFormat format, boolean truncate) {
        String separator = "";
        if (format == PrettifyStringFormat.MINIMAL_SINGLE_LINE) {
            separator = "";
        } else if (format == PrettifyStringFormat.MINIMAL_MULTI_LINE) {
            separator = "\n";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " ");
        builder.append("[");
        builder.append(separator);
        builder.append("identifier: " + this.identifier + ", ");
        builder.append(separator);
        if (this.location != null) {
            builder.append("location: " + this.location + ", ");
            builder.append(separator);
        }
        if (this.tags != null) {
            builder.append("tags: " + this.tags + ", ");
            builder.append(separator);
        }
        if (this.relationIdentifiers != null) {
            builder.append("parentRelations: " + this.relationIdentifiers + ", ");
            builder.append(separator);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Set<Long> relationIdentifiers() {
        return this.relationIdentifiers;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags != null ? new HashMap<String, String>(tags) : null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", location=" + this.location + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    @Override
    public String toWkt() {
        if (this.location == null) {
            return null;
        }
        return this.location.toWkt();
    }

    @Override
    public CompletePoint withAddedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers.add(relationIdentifier);
        return this;
    }

    public CompletePoint withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    @Override
    public CompletePoint withGeometry(Iterable<Location> locations) {
        if (!locations.iterator().hasNext()) {
            throw new CoreException("Cannot interpret empty Iterable as a Location");
        }
        return this.withLocation(locations.iterator().next());
    }

    @Override
    public CompletePoint withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public CompletePoint withLocation(Location location) {
        this.location = location;
        if (this.location != null) {
            this.bounds = location.bounds();
        }
        return this;
    }

    @Override
    public CompletePoint withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompletePoint withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    @Override
    public CompletePoint withRemovedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers = this.relationIdentifiers.stream().filter(keepId -> keepId.longValue() != relationIdentifier.longValue()).collect(Collectors.toSet());
        return this;
    }
}

