/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLocationItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompleteNode
extends Node
implements CompleteLocationItem<CompleteNode> {
    private static final long serialVersionUID = -8229589987121555419L;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();
    private Rectangle bounds;
    private long identifier;
    private Location location;
    private Map<String, String> tags;
    private SortedSet<Long> inEdgeIdentifiers;
    private SortedSet<Long> outEdgeIdentifiers;
    private Set<Long> explicitlyExcludedInEdgeIdentifiers;
    private Set<Long> explicitlyExcludedOutEdgeIdentifiers;
    private Set<Long> relationIdentifiers;

    public static CompleteNode from(Node node) {
        if (node instanceof CompleteNode && !((CompleteNode)node).isFull()) {
            throw new CoreException("Node parameter was a CompleteNode but it was not full: {}", node);
        }
        return new CompleteNode(node.getIdentifier(), node.getLocation(), node.getTags(), node.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), node.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), node.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteNode shallowFrom(Node node) {
        if (node.bounds() == null) {
            throw new CoreException("Node parameter bounds were null");
        }
        return new CompleteNode(node.getIdentifier()).withBoundsExtendedBy(node.bounds());
    }

    public CompleteNode(Long identifier, Location location, Map<String, String> tags, SortedSet<Long> inEdgeIdentifiers, SortedSet<Long> outEdgeIdentifiers, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = location != null ? location.bounds() : null;
        this.identifier = identifier;
        this.location = location;
        this.tags = tags;
        this.inEdgeIdentifiers = inEdgeIdentifiers;
        this.outEdgeIdentifiers = outEdgeIdentifiers;
        this.explicitlyExcludedInEdgeIdentifiers = new HashSet<Long>();
        this.explicitlyExcludedOutEdgeIdentifiers = new HashSet<Long>();
        this.relationIdentifiers = relationIdentifiers;
    }

    CompleteNode(long identifier) {
        this(identifier, null, null, null, null, null);
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.NODE;
    }

    public CompleteNode copy() {
        return new CompleteNode(this.identifier, this.location, this.tags, this.inEdgeIdentifiers, this.outEdgeIdentifiers, this.relationIdentifiers);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteNode) {
            CompleteNode that = (CompleteNode)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.getLocation(), that.getLocation()) && Objects.equals(this.inEdges(), that.inEdges()) && Objects.equals(this.outEdges(), that.outEdges());
        }
        return false;
    }

    public Set<Long> explicitlyExcludedInEdgeIdentifiers() {
        return this.explicitlyExcludedInEdgeIdentifiers;
    }

    public Set<Long> explicitlyExcludedOutEdgeIdentifiers() {
        return this.explicitlyExcludedOutEdgeIdentifiers;
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Set<Long> inEdgeIdentifiers() {
        return this.inEdgeIdentifiers;
    }

    @Override
    public SortedSet<Edge> inEdges() {
        return this.inEdgeIdentifiers == null ? null : (SortedSet)this.inEdgeIdentifiers.stream().map(CompleteEdge::new).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean isFull() {
        return this.bounds != null && this.location != null && this.tags != null && this.inEdgeIdentifiers != null && this.outEdgeIdentifiers != null && this.relationIdentifiers != null;
    }

    @Override
    public boolean isShallow() {
        return this.location == null && this.inEdgeIdentifiers == null && this.outEdgeIdentifiers == null && this.tags == null && this.relationIdentifiers == null;
    }

    public Set<Long> outEdgeIdentifiers() {
        return this.outEdgeIdentifiers;
    }

    @Override
    public SortedSet<Edge> outEdges() {
        return this.outEdgeIdentifiers == null ? null : (SortedSet)this.outEdgeIdentifiers.stream().map(CompleteEdge::new).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public String prettify(PrettifyStringFormat format, boolean truncate) {
        String separator = "";
        if (format == PrettifyStringFormat.MINIMAL_SINGLE_LINE) {
            separator = "";
        } else if (format == PrettifyStringFormat.MINIMAL_MULTI_LINE) {
            separator = "\n";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " ");
        builder.append("[");
        builder.append(separator);
        builder.append("identifier: " + this.identifier + ", ");
        builder.append(separator);
        if (this.location != null) {
            builder.append("location: " + this.location + ", ");
            builder.append(separator);
        }
        if (this.inEdgeIdentifiers != null) {
            builder.append("inEdges: " + this.inEdgeIdentifiers + ", ");
            builder.append(separator);
        }
        if (this.explicitlyExcludedInEdgeIdentifiers != null && !this.explicitlyExcludedInEdgeIdentifiers.isEmpty()) {
            builder.append("explicitlyExcludedInEdges: " + this.explicitlyExcludedInEdgeIdentifiers + ", ");
            builder.append(separator);
        }
        if (this.outEdgeIdentifiers != null) {
            builder.append("outEdges: " + this.outEdgeIdentifiers + ", ");
            builder.append(separator);
        }
        if (this.explicitlyExcludedOutEdgeIdentifiers != null && !this.explicitlyExcludedOutEdgeIdentifiers.isEmpty()) {
            builder.append("explicitlyExcludedOutEdges: " + this.explicitlyExcludedOutEdgeIdentifiers + ", ");
            builder.append(separator);
        }
        if (this.tags != null) {
            builder.append("tags: " + this.tags + ", ");
            builder.append(separator);
        }
        if (this.relationIdentifiers != null) {
            builder.append("parentRelations: " + this.relationIdentifiers + ", ");
            builder.append(separator);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Set<Long> relationIdentifiers() {
        return this.relationIdentifiers;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }

    public void setExplicitlyExcludedInEdgeIdentifiers(Set<Long> edges) {
        this.explicitlyExcludedInEdgeIdentifiers = edges;
    }

    public void setExplicitlyExcludedOutEdgeIdentifiers(Set<Long> edges) {
        this.explicitlyExcludedOutEdgeIdentifiers = edges;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags != null ? new HashMap<String, String>(tags) : null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", inEdgeIdentifiers=" + this.inEdgeIdentifiers + ", outEdgeIdentifiers=" + this.outEdgeIdentifiers + ", location=" + this.location + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    @Override
    public String toWkt() {
        if (this.location == null) {
            return null;
        }
        return this.location.toWkt();
    }

    public CompleteNode withAddedInEdgeIdentifier(Long inEdgeIdentifier) {
        this.inEdgeIdentifiers.add(inEdgeIdentifier);
        return this;
    }

    public CompleteNode withAddedOutEdgeIdentifier(Long inEdgeIdentifier) {
        this.outEdgeIdentifiers.add(inEdgeIdentifier);
        return this;
    }

    @Override
    public CompleteNode withAddedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers.add(relationIdentifier);
        return this;
    }

    public CompleteNode withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    @Override
    public CompleteEntity withGeometry(Iterable<Location> locations) {
        if (!locations.iterator().hasNext()) {
            throw new CoreException("Cannot interpret empty Iterable as a Location");
        }
        return this.withLocation(locations.iterator().next());
    }

    @Override
    public CompleteNode withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public CompleteNode withInEdgeIdentifiers(SortedSet<Long> inEdgeIdentifiers) {
        this.inEdgeIdentifiers = inEdgeIdentifiers;
        return this;
    }

    public CompleteNode withInEdgeIdentifiersAndSource(SortedSet<Long> inEdgeIdentifiers, Node source) {
        Set sourceIdentifiers = source.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        Sets.SetView excludedBasedOnSource = Sets.difference(sourceIdentifiers, inEdgeIdentifiers);
        this.inEdgeIdentifiers = inEdgeIdentifiers;
        this.explicitlyExcludedInEdgeIdentifiers.addAll(excludedBasedOnSource);
        return this;
    }

    public CompleteNode withInEdges(Set<Edge> inEdges) {
        this.inEdgeIdentifiers = inEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new));
        return this;
    }

    public CompleteNode withInEdgesAndSource(Set<Edge> inEdges, Node source) {
        return this.withInEdgeIdentifiersAndSource(inEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), source);
    }

    @Override
    public CompleteNode withLocation(Location location) {
        this.location = location;
        if (this.location != null) {
            this.bounds = location.bounds();
        }
        return this;
    }

    public CompleteNode withOutEdgeIdentifiers(SortedSet<Long> outEdgeIdentifiers) {
        this.outEdgeIdentifiers = outEdgeIdentifiers;
        return this;
    }

    public CompleteNode withOutEdgeIdentifiersAndSource(SortedSet<Long> outEdgeIdentifiers, Node source) {
        Set sourceIdentifiers = source.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        Sets.SetView excludedBasedOnSource = Sets.difference(sourceIdentifiers, outEdgeIdentifiers);
        this.outEdgeIdentifiers = outEdgeIdentifiers;
        this.explicitlyExcludedOutEdgeIdentifiers.addAll(excludedBasedOnSource);
        return this;
    }

    public CompleteNode withOutEdges(Set<Edge> outEdges) {
        this.outEdgeIdentifiers = outEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new));
        return this;
    }

    public CompleteNode withOutEdgesAndSource(Set<Edge> outEdges, Node source) {
        return this.withOutEdgeIdentifiersAndSource(outEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), source);
    }

    @Override
    public CompleteNode withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteNode withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    public CompleteNode withRemovedInEdgeIdentifier(Long inEdgeIdentifier) {
        this.inEdgeIdentifiers.remove(inEdgeIdentifier);
        this.explicitlyExcludedInEdgeIdentifiers.add(inEdgeIdentifier);
        return this;
    }

    public CompleteNode withRemovedOutEdgeIdentifier(Long outEdgeIdentifier) {
        this.outEdgeIdentifiers.remove(outEdgeIdentifier);
        this.explicitlyExcludedOutEdgeIdentifiers.add(outEdgeIdentifier);
        return this;
    }

    @Override
    public CompleteNode withRemovedRelationIdentifier(Long relationIdentifier) {
        this.relationIdentifiers = this.relationIdentifiers.stream().filter(keepId -> keepId.longValue() != relationIdentifier.longValue()).collect(Collectors.toSet());
        return this;
    }

    public CompleteNode withReplacedInEdgeIdentifier(Long beforeInEdgeIdentifier, Long afterInEdgeIdentifier) {
        return this.withRemovedInEdgeIdentifier(beforeInEdgeIdentifier).withAddedInEdgeIdentifier(afterInEdgeIdentifier);
    }

    public CompleteNode withReplacedOutEdgeIdentifier(Long beforeOutEdgeIdentifier, Long afterOutEdgeIdentifier) {
        return this.withRemovedOutEdgeIdentifier(beforeOutEdgeIdentifier).withAddedOutEdgeIdentifier(afterOutEdgeIdentifier);
    }
}

