/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public enum CompleteItemType {
    NODE(CompleteNode.class, ItemType.NODE),
    EDGE(CompleteEdge.class, ItemType.EDGE),
    AREA(CompleteArea.class, ItemType.AREA),
    LINE(CompleteLine.class, ItemType.LINE),
    POINT(CompletePoint.class, ItemType.POINT),
    RELATION(CompleteRelation.class, ItemType.RELATION);

    private final Class<? extends CompleteEntity> completeEntityClass;
    private final ItemType itemType;

    public static CompleteItemType from(ItemType itemType) {
        return Arrays.stream(CompleteItemType.values()).filter(completeItemType -> completeItemType.itemType == itemType).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static <C extends CompleteEntity> C shallowFrom(AtlasEntity reference) {
        ItemType itemType = reference.getType();
        CompleteItemType completeItemType = CompleteItemType.from(itemType);
        C completeEntity = completeItemType.completeEntityShallowFrom(reference);
        return completeEntity;
    }

    private CompleteItemType(Class<? extends CompleteEntity> completeEntityClass, ItemType itemType) {
        this.completeEntityClass = completeEntityClass;
        this.itemType = itemType;
    }

    public <C extends CompleteEntity> C completeEntityFrom(AtlasEntity reference) {
        this.validate(reference);
        return (C)((CompleteEntity)((Object)CompleteEntity.from(reference)));
    }

    public <C extends CompleteEntity> C completeEntityShallowFrom(AtlasEntity reference) {
        this.validate(reference);
        return (C)((CompleteEntity)((Object)CompleteEntity.shallowFrom(reference)));
    }

    public Class<? extends CompleteEntity> getCompleteEntityClass() {
        return this.completeEntityClass;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    private void validate(AtlasEntity reference) {
        Validate.isTrue(this.getItemType().getMemberClass().isAssignableFrom(reference.getClass()), "reference: " + reference + "; cannot be converted to completed entity " + this + ".", new Object[0]);
    }
}

