/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command.buildings;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.IOUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuilding;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuildingFinder;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.scalars.Surface;

public class TinyBuildingsSearchSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Surface> MINIMUM_BUILDING_SIZE_PARAMETER = new Command.Switch("minimum", "The minimum area permitted for a building", value -> Surface.UNIT_METER_SQUARED_ON_EARTH_SURFACE.scaleBy(Double.valueOf(value)), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_FILE_PARAMETER = new Command.Switch("output", "File containing the CSV information about each tiny building", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private Surface minimumSurface;
    private TinyBuildingLogger counter;

    public TinyBuildingsSearchSubCommand() {
        super("buildings-for-ants", "Lists all of the buildings with areas smaller than a given size");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(MINIMUM_BUILDING_SIZE_PARAMETER, OUTPUT_FILE_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-minimum=[scale factor of square meters]\n", new Object[0]);
        writer.printf("-output=/path/to/output/file\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        try {
            this.counter.close();
        }
        catch (IOException oops) {
            throw new CoreException("Failure to close", oops);
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        StreamSupport.stream(new ComplexBuildingFinder().find(atlas).spliterator(), false).map(ComplexBuilding.class::cast).filter(this::tooSmall).forEach(this.counter);
    }

    @Override
    protected void start(CommandMap command) {
        super.start(command);
        this.minimumSurface = (Surface)command.get(MINIMUM_BUILDING_SIZE_PARAMETER);
        this.counter = new TinyBuildingLogger(this.createStream(command));
    }

    private PrintStream createStream(CommandMap command) {
        try {
            Path output = (Path)command.get(OUTPUT_FILE_PARAMETER);
            try {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            catch (IOException oops) {
                throw new CoreException("Error when creating output directory", oops);
            }
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(output.toFile())));
        }
        catch (IOException oops) {
            throw new CoreException("Failure to open output", oops);
        }
    }

    private boolean tooSmall(ComplexBuilding building) {
        return building.getOutline().surface().isLessThanOrEqualTo(this.minimumSurface);
    }

    private static final class TinyBuildingLogger
    implements Consumer<ComplexBuilding>,
    Closeable {
        private final PrintStream output;

        private TinyBuildingLogger(PrintStream output) {
            this.output = output;
        }

        @Override
        public void accept(ComplexBuilding tinyBuilding) {
            String url = String.format("http://www.openstreetmap.org/%s/%d", tinyBuilding.getSource().getType() == ItemType.AREA ? "way" : "relation", tinyBuilding.getOsmIdentifier());
            this.output.printf("%s,%d,%d,%s,%.2f\n", tinyBuilding.getTag(ISOCountryTag.class, Optional.empty(), new Taggable.TagSearchOption[0]).orElse("UNK"), tinyBuilding.getIdentifier(), tinyBuilding.getOsmIdentifier(), url, tinyBuilding.getOutline().surface().asMeterSquared());
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.output);
        }
    }
}

