/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMissingISOSubCommand
extends AbstractAtlasSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasMissingISOSubCommand.class);
    private AtomicInteger counter;
    private Time start;

    public AtlasMissingISOSubCommand() {
        super("isoloss", "outputs all of the atlas objects that are missing ISO country codes");
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-combine : merge all of the atlas files into a MultiAtlas before outputting geojson\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        int value = this.counter.get();
        if (value > 0) {
            logger.error(String.format("Total Items missing ISO Codes: %s", DecimalFormat.getNumberInstance().format(value)));
        }
        logger.info("Time elapsed {}", (Object)this.start.elapsedSince());
        return Math.min(value, 1);
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        Predicate<Taggable> missingISOCountryTag = Validators.hasValuesFor(ISOCountryTag.class).negate();
        StreamSupport.stream(atlas.items().spliterator(), true).filter(missingISOCountryTag).forEach(this::log);
    }

    @Override
    protected void start(CommandMap command) {
        this.counter = new AtomicInteger();
        this.start = Time.now();
    }

    private void log(AtlasItem item) {
        this.counter.incrementAndGet();
        logger.error(String.format("[item] [%25s] [%9d]", item.getAtlas().getName(), item.getOsmIdentifier()));
    }
}

