/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNodeFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.RestrictedPath;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasListRestrictedPathsCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<File> OUTPUT_PARAMETER = new Command.Switch("output", "The output file to list all turn restriction ids", value -> new File((String)value), Command.Optionality.OPTIONAL);
    private final TreeSet<RestrictedPath> restrictedPaths = new TreeSet((restriction1, restriction2) -> Integer.compare(restriction1.hashCode(), restriction2.hashCode()));

    public AtlasListRestrictedPathsCommand() {
        super("restrictedPaths", "lists restrictedPaths");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        block13: {
            Optional<?> possibleFile = command.getOption(OUTPUT_PARAMETER);
            if (possibleFile.isPresent()) {
                try (PrintStream out = new PrintStream(new FileOutputStream(((File)possibleFile.get()).getFile(), true));){
                    this.restrictedPaths.forEach(value -> out.println(value));
                    break block13;
                }
                catch (IOException oops) {
                    throw new CoreException("Error writing restrictedPaths to file", oops);
                }
            }
            try (PrintStream out = new PrintStream(System.out);){
                this.restrictedPaths.forEach(value -> out.println(value));
            }
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        StreamSupport.stream(new BigNodeFinder().find(atlas).spliterator(), false).flatMap(bigNode -> bigNode.turnRestrictions().stream()).forEach(this.restrictedPaths::add);
    }
}

