/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasItemsWithSharedShapepointsSubCommand
extends AbstractAtlasSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasItemsWithSharedShapepointsSubCommand.class);
    private static final Command.Switch<Path> OUTPUT_FILE_PARAMETER = new Command.Switch("output", "Where we want to store the duplicate point error logs", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private Multimap<String, Long> countryToOSMids;
    private Time start;
    private int atlasFiles;

    public AtlasItemsWithSharedShapepointsSubCommand() {
        super("duplicate-points", "Outputs all of the OSM ids for items with consecutive identical shapepoints");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_FILE_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("\t-output=/path/to/output/folder/for/each/country%n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        for (Map.Entry<String, Collection<Long>> badIdsForCountry : this.countryToOSMids.asMap().entrySet()) {
            PrintStream stream = this.outputFor(badIdsForCountry.getKey(), command);
            try {
                stream.println(badIdsForCountry.getValue().stream().sorted().map(String::valueOf).collect(Collectors.joining("\n")));
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        long totalErrors = this.countryToOSMids.asMap().values().parallelStream().flatMap(Collection::parallelStream).count();
        NumberFormat formatter = DecimalFormat.getIntegerInstance();
        if (logger.isInfoEnabled()) {
            logger.info("Completed: {} atlas files and found {} errors from {} countries took {}", new Object[]{formatter.format(this.atlasFiles), formatter.format(totalErrors), formatter.format(this.countryToOSMids.keySet().size()), this.start.elapsedSince()});
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        logger.info("Starting {}", (Object)atlas.getName());
        ++this.atlasFiles;
        ConcurrentHashMap.KeySetView badOsmIDS = ConcurrentHashMap.newKeySet();
        StreamSupport.stream(atlas.items().spliterator(), true).map(PolyLineTrouble::new).filter(PolyLineTrouble::hasDuplicatePoints).map(PolyLineTrouble::getOsmId).forEach(badOsmIDS::add);
        Optional<String> countryNameOption = atlas.metaData().getCountry();
        if (countryNameOption.isPresent()) {
            String countryName = countryNameOption.get();
            badOsmIDS.forEach(id -> this.countryToOSMids.put(countryName, (Long)id));
            if (!badOsmIDS.isEmpty()) {
                logger.warn("Found {} overlaps in {}", (Object)badOsmIDS.size(), (Object)atlas.getName());
            }
        }
    }

    protected PrintStream outputFor(String isoCountry, CommandMap command) {
        Path outputDirectory = (Path)command.get(OUTPUT_FILE_PARAMETER);
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
            Path outputFile = outputDirectory.resolve(String.format("%s.duplicatepoints", isoCountry));
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile.toFile())));
        }
        catch (IOException oops) {
            throw new CoreException("Failure when creating outputstream for {}", isoCountry, oops);
        }
    }

    @Override
    protected void start(CommandMap command) {
        super.start(command);
        this.countryToOSMids = ArrayListMultimap.create();
        this.start = Time.now();
    }

    private static final class PolyLineTrouble {
        private final long osmId;
        private final PolyLine polyline;

        PolyLineTrouble(AtlasItem item) {
            this.osmId = item.getOsmIdentifier();
            this.polyline = new PolyLine(item.getRawGeometry());
        }

        Long getOsmId() {
            return this.osmId;
        }

        boolean hasDuplicatePoints() {
            Location previous = null;
            for (Location location : this.polyline) {
                if (location.equals(previous)) {
                    return true;
                }
                previous = location;
            }
            return false;
        }
    }
}

