/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasGeoJSONSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Path> OUTPUT_PARAMETER = new Command.Switch("output", "The geojson file to save the Atlas as geojson to: otherwise sent to stdout", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.OPTIONAL);
    private JsonWriter writer;

    public AtlasGeoJSONSubCommand() {
        super("geojson", "outputs the atlas as geojson data");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-output=/path/to/output/geojson/file: the path to the output geojson file\n", new Object[0]);
        writer.printf("-combine : merge all of the atlas files into a MultiAtlas before outputting geojson\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        this.writer.close();
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        this.getWriter(command).write(atlas.asGeoJson());
    }

    private JsonWriter getWriter(CommandMap map) {
        if (this.writer == null) {
            map.getOption(OUTPUT_PARAMETER).ifPresent(path -> {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    this.writer = new JsonWriter(new File(path.toString()));
                }
                catch (IOException oops) {
                    throw new CoreException("Error when creating output stream", oops);
                }
            });
            if (this.writer == null) {
                this.writer = new JsonWriter(new OutputStreamWritableResource(System.out));
            }
        }
        return this.writer;
    }
}

