/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasOutputTestSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasFindEntitiesByIdSubCommand
extends AbstractAtlasOutputTestSubCommand {
    private static final Command.Switch<Set<Long>> OSM_ID_PARAMETER = new Command.Switch("osmid", "list of comma-delimited OSM Identifiers of the entities we want to export", possibleMultipleOSMIdentifier -> Stream.of(possibleMultipleOSMIdentifier.split(",")).map(Long::parseLong).collect(Collectors.toSet()), Command.Optionality.REQUIRED);
    private Set<Long> identifiers;

    public AtlasFindEntitiesByIdSubCommand() {
        super("atlas-with-this-entity", "Creates a new atlas containing the area around any items found that match the set of ids provided by the -osmid parameter");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OSM_ID_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        super.usage(writer);
        writer.println("-osmid=OSM identifier : comma-separated numeric osm identifiers of the items we're trying to locate");
    }

    @Override
    protected boolean filter(AtlasEntity item) {
        return this.identifiers.contains(item.getOsmIdentifier());
    }

    @Override
    protected void start(CommandMap command) {
        super.start(command);
        this.identifiers = (Set)command.get(OSM_ID_PARAMETER);
    }
}

