/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNodeFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuildingFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.islands.ComplexIslandFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.restriction.ComplexTurnRestrictionFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntityFinder;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasFeatureCountsSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<File> OUTPUT_PARAMETER = new Command.Switch("output", "The output file to save the statistics", value -> new File((String)value), Command.Optionality.REQUIRED);
    private final Table<String, AtlasType, Long> featureCounts = TreeBasedTable.create();

    public AtlasFeatureCountsSubCommand() {
        super("featureCounts", "lists counts of objects found");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        File file = (File)command.get(OUTPUT_PARAMETER);
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file.getFile(), true)));){
            for (String country : this.featureCounts.rowKeySet()) {
                for (AtlasType type : AtlasType.values()) {
                    out.println(String.format("%s-%s: %d", new Object[]{country, type, this.featureCounts.contains(country, (Object)type) ? this.featureCounts.get(country, (Object)type) : 0L}));
                }
                out.println();
            }
        }
        catch (IOException oops) {
            throw new CoreException("Error writing to file: {}", file.getAbsolutePath().toString(), oops);
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        for (AtlasType type : AtlasType.values()) {
            this.updateHashMapForAtlasType(type, atlas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHashMapForAtlasType(AtlasType type, Atlas atlas) {
        long additionalCount;
        long oldCount = 0L;
        String country = atlas.metaData().getCountry().orElseGet(() -> "UNKNOWN");
        switch (type) {
            case NODE: {
                additionalCount = atlas.numberOfNodes();
                break;
            }
            case LINE: {
                additionalCount = atlas.numberOfLines();
                break;
            }
            case AREA: {
                additionalCount = atlas.numberOfAreas();
                break;
            }
            case POINT: {
                additionalCount = atlas.numberOfPoints();
                break;
            }
            case EDGE: {
                additionalCount = atlas.numberOfEdges();
                break;
            }
            case RELATION: {
                additionalCount = atlas.numberOfRelations();
                break;
            }
            case COMPLEX_BUILDING: {
                additionalCount = Iterables.count(new ComplexBuildingFinder().find(atlas), i -> 1L);
                break;
            }
            case COMPLEX_WATER: {
                additionalCount = Iterables.count(new ComplexWaterEntityFinder().find(atlas), i -> 1L);
                break;
            }
            case COMPLEX_ISLAND: {
                additionalCount = Iterables.count(new ComplexIslandFinder().find(atlas), i -> 1L);
                break;
            }
            case COMPLEX_TURN_RESTRICTION: {
                additionalCount = Iterables.count(new ComplexTurnRestrictionFinder().find(atlas), i -> 1L);
                break;
            }
            case COMPLEX_BIG_NODE: {
                additionalCount = Iterables.count(new BigNodeFinder().find(atlas), i -> 1L);
                break;
            }
            default: {
                throw new CoreException("Unexpected AtlasType: " + type.toString());
            }
        }
        AtlasFeatureCountsSubCommand atlasFeatureCountsSubCommand = this;
        synchronized (atlasFeatureCountsSubCommand) {
            if (this.featureCounts.contains(country, (Object)type)) {
                oldCount = this.featureCounts.get(country, (Object)type);
            }
            this.featureCounts.put(country, type, oldCount + additionalCount);
        }
    }

    protected static enum AtlasType {
        NODE,
        LINE,
        AREA,
        POINT,
        EDGE,
        RELATION,
        COMPLEX_BUILDING,
        COMPLEX_WATER,
        COMPLEX_ISLAND,
        COMPLEX_TURN_RESTRICTION,
        COMPLEX_BIG_NODE;

    }
}

