/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.testing;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.Sets;

public class AtlasChangeGeneratorSplitRoundabout
implements AtlasChangeGenerator {
    private static final long serialVersionUID = -6596053817414805897L;

    @Override
    public Set<FeatureChange> generateWithoutValidation(Atlas atlas) {
        AtomicLong identifierGenerator = new AtomicLong();
        HashSet<FeatureChange> result = new HashSet<FeatureChange>();
        for (Edge edge : atlas.edges(JunctionTag::isRoundabout)) {
            PolyLine currentShape = edge.asPolyLine();
            if (currentShape.size() <= 2 || edge.hasReverseEdge()) continue;
            Location cut = currentShape.get(currentShape.size() / 2);
            PolyLine shape1 = currentShape.between(currentShape.first(), 0, cut, 0);
            PolyLine shape2 = currentShape.between(cut, 0, currentShape.last(), currentShape.last().equals(currentShape.first()) ? 1 : 0);
            long middleNodeIdentifier = identifierGenerator.incrementAndGet();
            long oldEdgeIdentifier = edge.getIdentifier();
            long newEdgeIdentifier1 = identifierGenerator.incrementAndGet();
            long newEdgeIdentifier2 = identifierGenerator.incrementAndGet();
            CompleteEdge firstEdge = CompleteEdge.from(edge).withIdentifier(newEdgeIdentifier1).withPolyLine(shape1).withEndNodeIdentifier(middleNodeIdentifier);
            CompleteEdge secondEdge = CompleteEdge.from(edge).withIdentifier(newEdgeIdentifier2).withPolyLine(shape2).withStartNodeIdentifier(middleNodeIdentifier);
            edge.relations().stream().map(relation -> {
                RelationMemberList newMembers = new RelationMemberList(relation.members().stream().filter(member -> !member.getEntity().equals(edge)).collect(Collectors.toList()));
                return CompleteRelation.shallowFrom(relation).withMembersAndSource(newMembers, (Relation)relation).withAddedMember((AtlasEntity)firstEdge, edge).withAddedMember((AtlasEntity)secondEdge, edge);
            }).map(relation -> FeatureChange.add(relation, atlas)).forEach(result::add);
            result.add(FeatureChange.remove(CompleteEdge.shallowFrom(edge), atlas));
            result.add(FeatureChange.add(firstEdge, atlas));
            result.add(FeatureChange.add(secondEdge, atlas));
            result.add(FeatureChange.add(new CompleteNode(middleNodeIdentifier, cut, Maps.hashMap(new String[0]), Sets.treeSet((Comparable[])new Long[]{newEdgeIdentifier1}), Sets.treeSet((Comparable[])new Long[]{newEdgeIdentifier2}), Sets.hashSet(new Long[0])), atlas));
            result.add(FeatureChange.add(CompleteNode.shallowFrom(edge.end()).withInEdges(edge.end().inEdges()).withReplacedInEdgeIdentifier(oldEdgeIdentifier, newEdgeIdentifier2), atlas));
            result.add(FeatureChange.add(CompleteNode.shallowFrom(edge.start()).withOutEdges(edge.start().outEdges()).withReplacedOutEdgeIdentifier(oldEdgeIdentifier, newEdgeIdentifier1), atlas));
        }
        return result;
    }
}

