/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometryPrintable;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.WktPrintable;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescription;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.geojson.GeoJson;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class FeatureChangeGeoJsonSerializer
implements BiConsumer<FeatureChange, WritableResource>,
Converter<FeatureChange, String> {
    private static final Function<Iterable<? extends AtlasEntity>, JsonElement> identifierMapper = entity -> {
        JsonArray result = new JsonArray();
        Iterables.stream(entity).map(AtlasObject::getIdentifier).collectToSortedSet().forEach(number -> result.add(new JsonPrimitive((Number)number)));
        return result;
    };
    private static final Function<Map<String, String>, JsonElement> tagPrinter = map -> {
        JsonObject result = new JsonObject();
        TreeMap sortedMap = new TreeMap(map);
        for (Map.Entry entry : sortedMap.entrySet()) {
            result.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    };
    private final Gson jsonSerializer;

    private static <T> void add(JsonObject result, String name, T property, Function<T, JsonElement> writer) {
        if (property == null) {
            result.addProperty(name, (String)null);
        } else {
            result.add(name, writer.apply(property));
        }
    }

    private static <T> void addProperty(JsonObject result, String name, T property, Function<T, ? extends Object> writer) {
        result.addProperty(name, property == null ? null : writer.apply(property).toString());
    }

    public FeatureChangeGeoJsonSerializer(boolean prettyPrint, boolean showDescription) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeHierarchyAdapter(FeatureChange.class, new FeatureChangeTypeHierarchyAdapter(showDescription));
        this.jsonSerializer = gsonBuilder.create();
    }

    public FeatureChangeGeoJsonSerializer(boolean prettyPrint) {
        this(prettyPrint, true);
    }

    @Override
    public void accept(FeatureChange featureChange, WritableResource resource) {
        try (SafeBufferedWriter writer = resource.writer();){
            this.jsonSerializer.toJson((Object)featureChange, (Appendable)writer);
        }
        catch (IOException e) {
            throw new CoreException("Could not save FeatureChange to resource {}", resource.getName(), e);
        }
    }

    @Override
    public String convert(FeatureChange featureChange) {
        return this.jsonSerializer.toJson(featureChange);
    }

    private static class AtlasEntityPropertiesConverter
    implements Converter<AtlasEntity, JsonObject> {
        private AtlasEntityPropertiesConverter() {
        }

        @Override
        public JsonObject convert(AtlasEntity source) {
            JsonObject properties = new JsonObject();
            properties.addProperty("entityType", source.getType().toString());
            properties.addProperty("completeEntityClass", source.getClass().getName());
            properties.addProperty("identifier", source.getIdentifier());
            FeatureChangeGeoJsonSerializer.add(properties, "tags", source.getTags(), tagPrinter);
            FeatureChangeGeoJsonSerializer.add(properties, "relations", source.relations(), identifierMapper);
            if (source instanceof Edge) {
                FeatureChangeGeoJsonSerializer.addProperty(properties, "startNode", ((Edge)source).start(), AtlasObject::getIdentifier);
                FeatureChangeGeoJsonSerializer.addProperty(properties, "endNode", ((Edge)source).end(), AtlasObject::getIdentifier);
            } else if (source instanceof Node) {
                FeatureChangeGeoJsonSerializer.add(properties, "inEdges", ((Node)source).inEdges(), identifierMapper);
                FeatureChangeGeoJsonSerializer.add(properties, "outEdges", ((Node)source).outEdges(), identifierMapper);
            } else if (source instanceof Relation) {
                Relation relation = (Relation)source;
                FeatureChangeGeoJsonSerializer.add(properties, "members", relation.members(), members -> {
                    JsonArray beanResult = new JsonArray();
                    members.forEach(member -> beanResult.add(new JsonPrimitive(member.toString())));
                    return beanResult;
                });
            }
            return properties;
        }
    }

    private static class AtlasEntityGeometryPrintableConverter
    implements Converter<FeatureChange, GeometryPrintable> {
        private AtlasEntityGeometryPrintableConverter() {
        }

        @Override
        public GeometryPrintable convert(FeatureChange featureChange) {
            GeoJsonGeometry result;
            AtlasEntity source = featureChange.getAfterView();
            if (source instanceof Area) {
                result = ((Area)source).asPolygon();
                if (result == null && featureChange.getBeforeView() != null) {
                    result = ((Area)featureChange.getBeforeView()).asPolygon();
                }
            } else if (source instanceof LineItem) {
                result = ((LineItem)source).asPolyLine();
                if (result == null && featureChange.getBeforeView() != null) {
                    result = ((LineItem)featureChange.getBeforeView()).asPolyLine();
                }
            } else if (source instanceof LocationItem) {
                result = ((LocationItem)source).getLocation();
                if (result == null && featureChange.getBeforeView() != null) {
                    result = ((LocationItem)featureChange.getBeforeView()).getLocation();
                }
            } else {
                result = ((Relation)source).bounds();
            }
            if (result == null) {
                result = source.bounds();
            }
            return result;
        }
    }

    protected static class FeatureChangeTypeHierarchyAdapter
    implements JsonSerializer<FeatureChange> {
        private final boolean showDescription;

        private static void addGeometryGeojson(JsonObject result, GeometryPrintable property) {
            FeatureChangeGeoJsonSerializer.add(result, "geometry", property, GeoJson::asGeoJson);
        }

        private static void addGeometryWkt(JsonObject result, GeometryPrintable property) {
            FeatureChangeGeoJsonSerializer.addProperty(result, "WKT", property, WktPrintable::toWkt);
        }

        FeatureChangeTypeHierarchyAdapter(boolean showDescription) {
            this.showDescription = showDescription;
        }

        public JsonElement serialize(FeatureChange source) {
            JsonObject result = new JsonObject();
            result.addProperty("type", "Feature");
            Rectangle bounds = source.bounds();
            result.add("bbox", bounds.asGeoJsonBbox());
            GeometryPrintable geometryPrintable = new AtlasEntityGeometryPrintableConverter().convert(source);
            FeatureChangeTypeHierarchyAdapter.addGeometryGeojson(result, geometryPrintable);
            JsonObject properties = new JsonObject();
            properties.addProperty("featureChangeType", source.getChangeType().toString());
            FeatureChangeGeoJsonSerializer.add(properties, "metadata", source.getMetaData(), tagPrinter);
            if (this.showDescription) {
                FeatureChangeGeoJsonSerializer.add(properties, "description", source.explain(), ChangeDescription::toJsonElement);
            }
            new AtlasEntityPropertiesConverter().convert(source.getAfterView()).entrySet().forEach(entry -> properties.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            FeatureChangeTypeHierarchyAdapter.addGeometryWkt(properties, geometryPrintable);
            properties.addProperty("bboxWKT", source.bounds().toWkt());
            result.add("properties", properties);
            return result;
        }

        @Override
        public JsonElement serialize(FeatureChange source, Type typeOfSource, JsonSerializationContext context) {
            return this.serialize(source);
        }
    }
}

