/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.serializer.FeatureChangeGeoJsonSerializer;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class ChangeGeoJsonSerializer
implements BiConsumer<Change, WritableResource>,
Converter<Change, String> {
    private final Gson jsonSerializer;

    public ChangeGeoJsonSerializer() {
        this(true);
    }

    public ChangeGeoJsonSerializer(boolean prettyPrint, boolean showDescription) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeHierarchyAdapter(Change.class, new ChangeTypeHierarchyAdapter(showDescription));
        this.jsonSerializer = gsonBuilder.create();
    }

    public ChangeGeoJsonSerializer(boolean prettyPrint) {
        this(prettyPrint, true);
    }

    @Override
    public void accept(Change change, WritableResource resource) {
        try (SafeBufferedWriter writer = resource.writer();){
            this.jsonSerializer.toJson((Object)change, (Appendable)writer);
        }
        catch (IOException e) {
            throw new CoreException("Could not save FeatureChange to resource {}", resource.getName(), e);
        }
    }

    @Override
    public String convert(Change change) {
        return this.jsonSerializer.toJson(change);
    }

    private static class ChangeTypeHierarchyAdapter
    implements JsonSerializer<Change> {
        private final FeatureChangeGeoJsonSerializer.FeatureChangeTypeHierarchyAdapter featureChangeTypeHierarchyAdapter;

        ChangeTypeHierarchyAdapter(boolean showDescription) {
            this.featureChangeTypeHierarchyAdapter = new FeatureChangeGeoJsonSerializer.FeatureChangeTypeHierarchyAdapter(showDescription);
        }

        @Override
        public JsonElement serialize(Change source, Type typeOfSource, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.addProperty("type", "FeatureCollection");
            Rectangle bounds = source.bounds();
            result.add("bbox", bounds.asGeoJsonBbox());
            JsonArray features = new JsonArray();
            source.changes().map(this.featureChangeTypeHierarchyAdapter::serialize).forEach(features::add);
            result.add("features", features);
            JsonObject properties = new JsonObject();
            properties.addProperty("bboxWKT", source.bounds().toWkt());
            result.add("properties", properties);
            return result;
        }
    }
}

