/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.description;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorComparator;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.GeometryChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.LongElementChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.RelationMemberChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.TagChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public final class ChangeDescriptorGenerator {
    private static final ChangeDescriptorComparator COMPARATOR = new ChangeDescriptorComparator();
    private static final String CORRUPTED_FEATURECHANGE_MESSAGE = "Corrupted FeatureChange: afterView {} != null but beforeView {} == null";
    private final AtlasEntity beforeView;
    private final AtlasEntity afterView;
    private final ChangeDescriptorType changeDescriptorType;

    ChangeDescriptorGenerator(AtlasEntity beforeView, AtlasEntity afterView, ChangeDescriptorType changeDescriptorType) {
        this.beforeView = beforeView;
        this.afterView = afterView;
        this.changeDescriptorType = changeDescriptorType;
    }

    List<ChangeDescriptor> generate() {
        ArrayList<ChangeDescriptor> descriptors = new ArrayList<ChangeDescriptor>();
        if (this.changeDescriptorType == ChangeDescriptorType.REMOVE) {
            return descriptors;
        }
        descriptors.addAll(this.generateTagDescriptors());
        descriptors.addAll(this.generateGeometryDescriptors());
        descriptors.addAll(this.generateParentRelationDescriptors(CompleteEntity::relationIdentifiers));
        if (this.afterView.getType() == ItemType.NODE) {
            descriptors.addAll(this.generateNodeInOutDescriptors(ChangeDescriptorName.IN_EDGE, CompleteNode::inEdgeIdentifiers));
            descriptors.addAll(this.generateNodeInOutDescriptors(ChangeDescriptorName.OUT_EDGE, CompleteNode::outEdgeIdentifiers));
        }
        if (this.afterView.getType() == ItemType.EDGE) {
            descriptors.addAll(this.generateEdgeStartEndDescriptors(ChangeDescriptorName.START_NODE, CompleteEdge::startNodeIdentifier));
            descriptors.addAll(this.generateEdgeStartEndDescriptors(ChangeDescriptorName.END_NODE, CompleteEdge::endNodeIdentifier));
        }
        if (this.afterView.getType() == ItemType.RELATION) {
            descriptors.addAll(this.generateRelationMemberDescriptors());
        }
        descriptors.sort(COMPARATOR);
        return descriptors;
    }

    ChangeDescriptorType getChangeDescriptorType() {
        return this.changeDescriptorType;
    }

    private List<LongElementChangeDescriptor> generateEdgeStartEndDescriptors(ChangeDescriptorName name, Function<CompleteEdge, Long> memberExtractor) {
        Long beforeIdentifier;
        CompleteEdge beforeEntity = (CompleteEdge)this.beforeView;
        CompleteEdge afterEntity = (CompleteEdge)this.afterView;
        if (memberExtractor.apply(afterEntity) == null) {
            return new ArrayList<LongElementChangeDescriptor>();
        }
        if (beforeEntity != null) {
            if (memberExtractor.apply(beforeEntity) == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, new Object[]{name, name});
            }
            beforeIdentifier = memberExtractor.apply(beforeEntity);
        } else {
            beforeIdentifier = null;
        }
        Long afterIdentifier = memberExtractor.apply(afterEntity);
        return this.generateLongValueDescriptors(name, beforeIdentifier, afterIdentifier);
    }

    private List<ChangeDescriptor> generateGeometryDescriptors() {
        ArrayList<ChangeDescriptor> descriptors = new ArrayList<ChangeDescriptor>();
        if (this.afterView.getType() == ItemType.RELATION) {
            return descriptors;
        }
        CompleteEntity beforeEntity = (CompleteEntity)((Object)this.beforeView);
        CompleteEntity afterEntity = (CompleteEntity)((Object)this.afterView);
        if (afterEntity.getGeometry() == null) {
            return descriptors;
        }
        ArrayList<Location> beforeGeometry = new ArrayList<Location>();
        ArrayList<Location> afterGeometry = new ArrayList<Location>();
        afterEntity.getGeometry().forEach(afterGeometry::add);
        if (beforeEntity != null) {
            if (beforeEntity.getGeometry() == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, "geometry", "geometry");
            }
            beforeEntity.getGeometry().forEach(beforeGeometry::add);
        }
        descriptors.addAll(GeometryChangeDescriptor.getDescriptorsForGeometry(beforeGeometry, afterGeometry));
        return descriptors;
    }

    private List<LongElementChangeDescriptor> generateLongSetDescriptors(ChangeDescriptorName name, Set<Long> beforeSet, Set<Long> afterSet) {
        ArrayList<LongElementChangeDescriptor> descriptors = new ArrayList<LongElementChangeDescriptor>();
        Sets.SetView<Long> removedFromAfterView = Sets.difference(beforeSet, afterSet);
        Sets.SetView<Long> addedToAfterView = Sets.difference(afterSet, beforeSet);
        for (Long identifier : removedFromAfterView) {
            descriptors.add(new LongElementChangeDescriptor(ChangeDescriptorType.REMOVE, identifier, null, name));
        }
        for (Long identifier : addedToAfterView) {
            descriptors.add(new LongElementChangeDescriptor(ChangeDescriptorType.ADD, identifier, name));
        }
        return descriptors;
    }

    private List<LongElementChangeDescriptor> generateLongValueDescriptors(ChangeDescriptorName name, Long beforeIdentifier, Long afterIdentifier) {
        ArrayList<LongElementChangeDescriptor> descriptors = new ArrayList<LongElementChangeDescriptor>();
        if (beforeIdentifier == null) {
            descriptors.add(new LongElementChangeDescriptor(ChangeDescriptorType.ADD, null, afterIdentifier, name));
        } else {
            descriptors.add(new LongElementChangeDescriptor(ChangeDescriptorType.UPDATE, beforeIdentifier, afterIdentifier, name));
        }
        return descriptors;
    }

    private List<LongElementChangeDescriptor> generateNodeInOutDescriptors(ChangeDescriptorName name, Function<CompleteNode, Set<Long>> memberExtractor) {
        HashSet<Long> beforeSet;
        CompleteNode beforeEntity = (CompleteNode)this.beforeView;
        CompleteNode afterEntity = (CompleteNode)this.afterView;
        if (memberExtractor.apply(afterEntity) == null) {
            return new ArrayList<LongElementChangeDescriptor>();
        }
        if (beforeEntity != null) {
            if (memberExtractor.apply(beforeEntity) == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, new Object[]{name, name});
            }
            beforeSet = memberExtractor.apply(beforeEntity);
        } else {
            beforeSet = new HashSet();
        }
        Set<Long> afterSet = memberExtractor.apply(afterEntity);
        return this.generateLongSetDescriptors(name, beforeSet, afterSet);
    }

    private List<LongElementChangeDescriptor> generateParentRelationDescriptors(Function<CompleteEntity, Set<Long>> memberExtractor) {
        HashSet<Long> beforeSet;
        ChangeDescriptorName name = ChangeDescriptorName.PARENT_RELATION;
        CompleteEntity beforeEntity = (CompleteEntity)((Object)this.beforeView);
        CompleteEntity afterEntity = (CompleteEntity)((Object)this.afterView);
        if (memberExtractor.apply(afterEntity) == null) {
            return new ArrayList<LongElementChangeDescriptor>();
        }
        if (beforeEntity != null) {
            if (memberExtractor.apply(beforeEntity) == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, new Object[]{name, name});
            }
            beforeSet = memberExtractor.apply(beforeEntity);
        } else {
            beforeSet = new HashSet();
        }
        Set<Long> afterSet = memberExtractor.apply(afterEntity);
        return this.generateLongSetDescriptors(name, beforeSet, afterSet);
    }

    private List<ChangeDescriptor> generateRelationMemberDescriptors() {
        Set<Object> beforeBeanSet;
        ArrayList<ChangeDescriptor> descriptors = new ArrayList<ChangeDescriptor>();
        CompleteRelation beforeEntity = (CompleteRelation)this.beforeView;
        CompleteRelation afterEntity = (CompleteRelation)this.afterView;
        if (afterEntity.members() == null) {
            return descriptors;
        }
        if (beforeEntity != null) {
            if (beforeEntity.members() == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, "relation members", "relation members");
            }
            beforeBeanSet = beforeEntity.members().asBean().asSet();
        } else {
            beforeBeanSet = new HashSet();
        }
        Set<RelationBean.RelationBeanItem> afterBeanSet = afterEntity.members().asBean().asSet();
        Sets.SetView<RelationBean.RelationBeanItem> itemsRemovedFromAfterView = Sets.difference(beforeBeanSet, afterBeanSet);
        Sets.SetView<RelationBean.RelationBeanItem> itemsAddedToAfterView = Sets.difference(afterBeanSet, beforeBeanSet);
        for (RelationBean.RelationBeanItem item : itemsRemovedFromAfterView) {
            descriptors.add(new RelationMemberChangeDescriptor(ChangeDescriptorType.REMOVE, item.getIdentifier(), item.getType(), item.getRole()));
        }
        for (RelationBean.RelationBeanItem item : itemsAddedToAfterView) {
            descriptors.add(new RelationMemberChangeDescriptor(ChangeDescriptorType.ADD, item.getIdentifier(), item.getType(), item.getRole()));
        }
        return descriptors;
    }

    private List<ChangeDescriptor> generateTagDescriptors() {
        Map<Object, Object> beforeTags;
        ArrayList<ChangeDescriptor> descriptors = new ArrayList<ChangeDescriptor>();
        if (this.afterView.getTags() == null) {
            return descriptors;
        }
        if (this.beforeView != null) {
            if (this.beforeView.getTags() == null) {
                throw new CoreException(CORRUPTED_FEATURECHANGE_MESSAGE, "tags", "tags");
            }
            beforeTags = this.beforeView.getTags();
        } else {
            beforeTags = new HashMap();
        }
        Map<String, String> afterTags = this.afterView.getTags();
        Sets.SetView<Object> keysRemovedFromAfterView = Sets.difference(beforeTags.keySet(), afterTags.keySet());
        Sets.SetView<String> keysAddedToAfterView = Sets.difference(afterTags.keySet(), beforeTags.keySet());
        Sets.SetView<Object> keysShared = Sets.intersection(beforeTags.keySet(), afterTags.keySet());
        for (String string : keysRemovedFromAfterView) {
            descriptors.add(new TagChangeDescriptor(ChangeDescriptorType.REMOVE, string, (String)beforeTags.get(string)));
        }
        for (String string : keysAddedToAfterView) {
            descriptors.add(new TagChangeDescriptor(ChangeDescriptorType.ADD, string, afterTags.get(string)));
        }
        for (String string : keysShared) {
            if (((String)beforeTags.get(string)).equals(afterTags.get(string))) continue;
            descriptors.add(new TagChangeDescriptor(ChangeDescriptorType.UPDATE, string, afterTags.get(string), (String)beforeTags.get(string)));
        }
        return descriptors;
    }
}

