/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.FeatureChangeMergeException;
import org.openstreetmap.atlas.exception.change.MergeFailureType;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.function.QuaternaryOperator;
import org.openstreetmap.atlas.utilities.function.SenaryFunction;
import org.openstreetmap.atlas.utilities.function.TernaryOperator;

public final class MemberMergeStrategies {
    static final BinaryOperator<Long> autofailBinaryLongMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_MERGE, "autofailBinaryLongMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<Long> autofailQuaternaryLongMerger = (beforeLeft, beforeRight, afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_MERGE, "autofailQuaternaryLongMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<Map<String, String>> autofailBinaryTagMerger = (afterMapLeft, afterMapRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_TAG_MERGE, "autofailBinaryTagMerger:\n{}\nvs\n{}", afterMapLeft, afterMapRight);
    };
    static final QuaternaryOperator<Map<String, String>> autofailQuaternaryTagMerger = (beforeMapLeft, afterMapLeft, beforeMapRight, afterMapRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_TAG_MERGE, "autofailQuaternaryTagMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeMapLeft, beforeMapRight, afterMapLeft, afterMapRight);
    };
    static final BinaryOperator<Set<Long>> autofailBinaryLongSetMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_SET_MERGE, "autofailBinaryLongSetMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<Set<Long>> autofailQuaternaryLongSetMerger = (beforeLeft, afterLeft, beforeRight, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_SET_MERGE, "autofailQuaternaryLongSetMerger: before\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<SortedSet<Long>> autofailBinaryLongSortedSetMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_SORTED_SET_MERGE, "autofailBinaryLongSortedSetMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<SortedSet<Long>> autofailQuaternaryLongSortedSetMerger = (beforeLeft, afterLeft, beforeRight, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LONG_SORTED_SET_MERGE, "autofailQuaternaryLongSortedSetMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<Location> autofailBinaryLocationMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LOCATION_MERGE, "autofailBinaryLocationMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<Location> autofailQuaternaryLocationMerger = (beforeLeft, afterLeft, beforeRight, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_LOCATION_MERGE, "autofailQuaternaryLocationMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<PolyLine> autofailBinaryPolyLineMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_POLYLINE_MERGE, "autofailBinaryPolyLineMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<PolyLine> autofailQuaternaryPolyLineMerger = (beforeLeft, afterLeft, beforeRight, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_POLYLINE_MERGE, "autofailQuaternaryPolyLineMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<Polygon> autofailBinaryPolygonMerger = (afterLeft, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_POLYGON_MERGE, "autofailBinaryPolygonMerger:\n{}\nvs\n{}", afterLeft, afterRight);
    };
    static final QuaternaryOperator<Polygon> autofailQuaternaryPolygonMerger = (beforeLeft, afterLeft, beforeRight, afterRight) -> {
        throw new FeatureChangeMergeException(MergeFailureType.AUTOFAIL_POLYGON_MERGE, "autofailQuaternaryPolygonMerger: before:\n{}\nvs\n{}\nafter:\n{}\nvs\n{}", beforeLeft, beforeRight, afterLeft, afterRight);
    };
    static final BinaryOperator<Map<String, String>> simpleTagMerger = (afterMapLeft, afterMapRight) -> {
        try {
            return Maps.withMaps(afterMapLeft, afterMapRight);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.SIMPLE_TAG_MERGE_FAIL, "simpleTagMerger failed", exception);
        }
    };
    static final BinaryOperator<Set<Long>> simpleLongSetMerger = (afterSetLeft, afterSetRight) -> {
        try {
            return org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, afterSetLeft, afterSetRight);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.SIMPLE_LONG_SET_MERGE_FAIL, "simpleLongSetMerger failed", exception);
        }
    };
    static final BinaryOperator<SortedSet<Long>> simpleLongSortedSetMerger = (afterSetLeft, afterSetRight) -> {
        try {
            return org.openstreetmap.atlas.utilities.collections.Sets.withSortedSets(false, afterSetLeft, afterSetRight);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.SIMPLE_LONG_SORTED_SET_MERGE_FAIL, "simpleLongSortedSetMerger failed", exception);
        }
    };
    static final BinaryOperator<RelationBean> simpleRelationBeanMerger = (afterBeanLeft, afterBeanRight) -> {
        try {
            return RelationBean.mergeBeans(afterBeanLeft, afterBeanRight);
        }
        catch (Exception exception) {
            throw new FeatureChangeMergeException(MergeFailureType.SIMPLE_RELATION_BEAN_MERGE_FAIL, "simpleRelationBeanMerger failed", exception);
        }
    };
    static final TernaryOperator<Long> diffBasedLongMerger = (beforeLong, afterLongLeft, afterLongRight) -> {
        try {
            return (Long)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforeLong, (Long)afterLongLeft, afterLongRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.DIFF_BASED_LONG_MERGE_FAIL), "mutually exclusive Long merge failed", exception);
        }
    };
    static final TernaryOperator<Location> diffBasedLocationMerger = (beforeLocation, afterLocationLeft, afterLocationRight) -> {
        try {
            return (Location)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforeLocation, (Location)afterLocationLeft, afterLocationRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.DIFF_BASED_LOCATION_MERGE_FAIL), "mutually exclusive Location merge failed", exception);
        }
    };
    static final TernaryOperator<PolyLine> diffBasedPolyLineMerger = (beforePolyLine, afterPolyLineLeft, afterPolyLineRight) -> {
        try {
            return (PolyLine)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforePolyLine, (PolyLine)afterPolyLineLeft, afterPolyLineRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.DIFF_BASED_POLYLINE_MERGE_FAIL), "mutually exclusive PolyLine merge failed", exception);
        }
    };
    static final TernaryOperator<Polygon> diffBasedPolygonMerger = (beforePolygon, afterPolygonLeft, afterPolygonRight) -> {
        try {
            return (Polygon)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforePolygon, (Polygon)afterPolygonLeft, afterPolygonRight);
        }
        catch (FeatureChangeMergeException exception) {
            throw new FeatureChangeMergeException(exception.withNewTopLevelFailure(MergeFailureType.DIFF_BASED_POLYGON_MERGE_FAIL), "mutually exclusive Polygon merge failed", exception);
        }
    };
    static final TernaryOperator<RelationBean> diffBasedRelationBeanMerger = (beforeBean, afterLeftBean, afterRightBean) -> {
        Integer newValue;
        Integer beforeValue;
        Map<RelationBean.RelationBeanItem, Integer> beforeBeanMap = beforeBean.asMap();
        Map<RelationBean.RelationBeanItem, Integer> afterLeftBeanMap = afterLeftBean.asMap();
        Map<RelationBean.RelationBeanItem, Integer> afterRightBeanMap = afterRightBean.asMap();
        MemberMergeStrategies.verifyExplicitlyExcludedSets(beforeBean.asSet(), afterLeftBean.asSet(), afterLeftBean.getExplicitlyExcluded(), beforeBean.asSet(), afterRightBean.asSet(), afterRightBean.getExplicitlyExcluded());
        Map<RelationBean.RelationBeanItem, Integer> removedFromLeftView = MemberMergeStrategies.computeMapDifferenceCounts(beforeBeanMap, afterLeftBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> removedFromRightView = MemberMergeStrategies.computeMapDifferenceCounts(beforeBeanMap, afterRightBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> addedToLeftView = MemberMergeStrategies.computeMapDifferenceCounts(afterLeftBeanMap, beforeBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> addedToRightView = MemberMergeStrategies.computeMapDifferenceCounts(afterRightBeanMap, beforeBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<RelationBean.RelationBeanItem, Integer> removedFromLeftEntry : removedFromLeftView.entrySet()) {
            RelationBean.RelationBeanItem leftKey = removedFromLeftEntry.getKey();
            Integer n = removedFromLeftEntry.getValue();
            Integer rightValue = removedFromRightView.get(leftKey);
            if (rightValue == null || n.equals(rightValue)) continue;
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_RELATION_BEAN_REMOVE_REMOVE_CONFLICT, "diffBasedRelationBeanMerger failed due to REMOVE/REMOVE conflict on key: [{}]: beforeValue absolute count was {} but removedLeft/Right diff counts conflict [{} vs {}]", leftKey, beforeBeanMap.get(leftKey), n, rightValue);
        }
        Sets.SetView<RelationBean.RelationBeanItem> addedLeftRemovedRightConflicts = Sets.intersection(addedToLeftView.keySet(), removedFromRightView.keySet());
        if (!addedLeftRemovedRightConflicts.isEmpty()) {
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_RELATION_BEAN_ADD_REMOVE_CONFLICT, "diffBasedRelationBeanMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", addedLeftRemovedRightConflicts);
        }
        Sets.SetView<RelationBean.RelationBeanItem> addedRightRemovedLeftConflicts = Sets.intersection(addedToRightView.keySet(), removedFromLeftView.keySet());
        if (!addedRightRemovedLeftConflicts.isEmpty()) {
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_RELATION_BEAN_ADD_REMOVE_CONFLICT, "diffBasedRelationBeanMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", addedLeftRemovedRightConflicts);
        }
        for (Map.Entry entry2 : addedToLeftView.entrySet()) {
            RelationBean.RelationBeanItem leftKey = (RelationBean.RelationBeanItem)entry2.getKey();
            Iterator leftValue = (Integer)entry2.getValue();
            Integer n = addedToRightView.get(leftKey);
            if (n == null || ((Integer)((Object)leftValue)).equals(n)) continue;
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_RELATION_BEAN_ADD_ADD_CONFLICT, "diffBasedRelationBeanMerger failed due to ADD/ADD conflict on key: [{}]: beforeValue absolute count was {} but addedLeft/Right diff counts conflict [{} vs {}]", leftKey, beforeBeanMap.get(leftKey) != null ? beforeBeanMap.get(leftKey) : 0, leftValue, n);
        }
        HashMap removedMergedView = new HashMap();
        removedFromLeftView.entrySet().stream().forEach(entry -> removedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        removedFromRightView.entrySet().stream().forEach(entry -> removedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        HashMap hashMap = new HashMap();
        addedToLeftView.entrySet().stream().forEach(entry -> addedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        addedToRightView.entrySet().stream().forEach(entry -> addedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        HashMap<RelationBean.RelationBeanItem, Integer> resultMap = new HashMap<RelationBean.RelationBeanItem, Integer>(beforeBeanMap);
        for (Map.Entry entry3 : removedMergedView.entrySet()) {
            RelationBean.RelationBeanItem removedKey = (RelationBean.RelationBeanItem)entry3.getKey();
            Integer removedCount = (Integer)entry3.getValue();
            beforeValue = beforeBeanMap.get(removedKey);
            newValue = beforeValue - removedCount;
            resultMap.put(removedKey, newValue);
        }
        for (Map.Entry entry4 : hashMap.entrySet()) {
            RelationBean.RelationBeanItem addedKey = (RelationBean.RelationBeanItem)entry4.getKey();
            Integer addedCount = (Integer)entry4.getValue();
            beforeValue = beforeBeanMap.get(addedKey);
            newValue = beforeValue == null ? Integer.valueOf(0 + addedCount) : Integer.valueOf(beforeValue + addedCount);
            resultMap.put(addedKey, newValue);
        }
        RelationBean resultBean = new RelationBean();
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            RelationBean.RelationBeanItem resultKey = (RelationBean.RelationBeanItem)resultEntry.getKey();
            Integer resultCount = (Integer)resultEntry.getValue();
            for (int count = 0; count < resultCount; ++count) {
                resultBean.addItem(resultKey);
            }
        }
        Stream.concat(afterLeftBean.getExplicitlyExcluded().stream(), afterRightBean.getExplicitlyExcluded().stream()).forEach(resultBean::addItemExplicitlyExcluded);
        return resultBean;
    };
    static final TernaryOperator<Set<Long>> diffBasedLongSetMerger = (beforeSet, afterLeftSet, afterRightSet) -> {
        Sets.SetView removedFromLeftView = Sets.difference(beforeSet, afterLeftSet);
        Sets.SetView removedFromRightView = Sets.difference(beforeSet, afterRightSet);
        Sets.SetView addedToLeftView = Sets.difference(afterLeftSet, beforeSet);
        Sets.SetView addedToRightView = Sets.difference(afterRightSet, beforeSet);
        Set removedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, removedFromLeftView, removedFromRightView);
        Set addedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeftView, addedToRightView);
        HashSet result = new HashSet(beforeSet);
        result.removeAll(removedMerged);
        result.addAll(addedMerged);
        return result;
    };
    static final TernaryOperator<SortedSet<Long>> diffBasedLongSortedSetMerger = (beforeSet, afterLeftSet, afterRightSet) -> new TreeSet((Collection)diffBasedLongSetMerger.apply(beforeSet, (Set<Long>)afterLeftSet, afterRightSet));
    static final TernaryOperator<Map<String, String>> diffBasedTagMerger = (beforeMap, afterLeftMap, afterRightMap) -> {
        Sets.SetView keysRemovedFromLeftView = Sets.difference(beforeMap.keySet(), afterLeftMap.keySet());
        Sets.SetView keysRemovedFromRightView = Sets.difference(beforeMap.keySet(), afterRightMap.keySet());
        Map<String, String> addedToLeftView = Sets.difference(afterLeftMap.entrySet(), beforeMap.entrySet()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> addedToRightView = Sets.difference(afterRightMap.entrySet(), beforeMap.entrySet()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Sets.SetView<String> sharedAddedKeys = Sets.intersection(addedToLeftView.keySet(), addedToRightView.keySet());
        for (String sharedKey : sharedAddedKeys) {
            String rightValue;
            String leftValue = addedToLeftView.get(sharedKey);
            if (Objects.equals(leftValue, rightValue = addedToRightView.get(sharedKey))) continue;
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_TAG_ADD_ADD_CONFLICT, "diffBasedTagMerger failed due to ADD/ADD conflict on keys: [{} -> {}] vs [{} -> {}]", sharedKey, leftValue, sharedKey, rightValue);
        }
        Set keysRemovedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, keysRemovedFromLeftView, keysRemovedFromRightView);
        Set keysAddedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeftView.keySet(), addedToRightView.keySet());
        Sets.SetView conflicts = Sets.intersection(keysRemovedMerged, keysAddedMerged);
        if (!conflicts.isEmpty()) {
            throw new FeatureChangeMergeException(MergeFailureType.DIFF_BASED_TAG_ADD_REMOVE_CONFLICT, "diffBasedTagMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", conflicts);
        }
        HashMap result = new HashMap(beforeMap);
        keysRemovedMerged.forEach(result::remove);
        keysAddedMerged.forEach(key -> {
            String value = (String)addedToLeftView.get(key);
            if (value == null) {
                value = (String)addedToRightView.get(key);
            }
            result.put(key, value);
        });
        return result;
    };
    static final SenaryFunction<SortedSet<Long>, SortedSet<Long>, Set<Long>, SortedSet<Long>, SortedSet<Long>, Set<Long>, SortedSet<Long>> conflictingBeforeViewSetMerger = (beforeLeftSet, afterLeftSet, explicitlyExcludedLeftSet, beforeRightSet, afterRightSet, explicitlyExcludedRightSet) -> {
        MemberMergeStrategies.verifyExplicitlyExcludedSets(beforeLeftSet, afterLeftSet, explicitlyExcludedLeftSet, beforeRightSet, afterRightSet, explicitlyExcludedRightSet);
        Set removedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, explicitlyExcludedLeftSet, explicitlyExcludedRightSet);
        Sets.SetView addedToLeft = Sets.difference(afterLeftSet, beforeLeftSet);
        Sets.SetView addedToRight = Sets.difference(afterRightSet, beforeRightSet);
        Set addedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeft, addedToRight);
        Sets.SetView conflicts = Sets.intersection(removedMerged, addedMerged);
        if (!conflicts.isEmpty()) {
            throw new FeatureChangeMergeException(MergeFailureType.CONFLICTING_BEFORE_VIEW_SET_ADD_REMOVE_CONFLICT, "conflictingBeforeViewSetMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", conflicts);
        }
        Set mergedBeforeView = (Set)simpleLongSetMerger.apply((Set<Long>)beforeLeftSet, beforeRightSet);
        mergedBeforeView.removeAll(removedMerged);
        mergedBeforeView.addAll(addedMerged);
        TreeSet resultSet = new TreeSet();
        mergedBeforeView.forEach(resultSet::add);
        return resultSet;
    };
    static final QuaternaryOperator<RelationBean> conflictingBeforeViewRelationBeanMerger = (beforeLeftBean, afterLeftBean, beforeRightBean, afterRightBean) -> {
        MemberMergeStrategies.verifyExplicitlyExcludedSets(beforeLeftBean.asSet(), afterLeftBean.asSet(), afterLeftBean.getExplicitlyExcluded(), beforeRightBean.asSet(), afterRightBean.asSet(), afterRightBean.getExplicitlyExcluded());
        Set removedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, afterLeftBean.getExplicitlyExcluded(), afterRightBean.getExplicitlyExcluded());
        Sets.SetView<RelationBean.RelationBeanItem> addedToLeft = Sets.difference(afterLeftBean.asSet(), beforeLeftBean.asSet());
        Sets.SetView<RelationBean.RelationBeanItem> addedToRight = Sets.difference(afterRightBean.asSet(), beforeRightBean.asSet());
        Set addedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeft, addedToRight);
        Sets.SetView conflicts = Sets.intersection(removedMerged, addedMerged);
        if (!conflicts.isEmpty()) {
            throw new FeatureChangeMergeException(MergeFailureType.CONFLICTING_BEFORE_VIEW_RELATION_BEAN_ADD_REMOVE_CONFLICT, "conflictingBeforeViewRelationBeanMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", conflicts);
        }
        Set<RelationBean.RelationBeanItem> mergedBeforeView = ((RelationBean)simpleRelationBeanMerger.apply((RelationBean)beforeLeftBean, beforeRightBean)).asSet();
        mergedBeforeView.removeAll(removedMerged);
        mergedBeforeView.addAll(addedMerged);
        RelationBean resultBean = new RelationBean();
        mergedBeforeView.forEach(resultBean::addItem);
        Stream.concat(afterLeftBean.getExplicitlyExcluded().stream(), afterRightBean.getExplicitlyExcluded().stream()).forEach(resultBean::addItemExplicitlyExcluded);
        return resultBean;
    };

    private static <T> Map<T, Integer> computeMapDifferenceCounts(Map<T, Integer> before, Map<T, Integer> after) {
        HashMap<T, Integer> result = new HashMap<T, Integer>();
        for (Map.Entry<T, Integer> beforeEntry : before.entrySet()) {
            T beforeKey = beforeEntry.getKey();
            Integer beforeCount = beforeEntry.getValue();
            Integer afterCount = after.get(beforeKey);
            if (afterCount != null) {
                result.put(beforeKey, beforeCount - afterCount);
                continue;
            }
            result.put(beforeKey, beforeCount);
        }
        return result;
    }

    private static <T> TernaryOperator<T> getDiffBasedMutuallyExclusiveMerger() {
        return (beforeView, afterViewLeft, afterViewRight) -> {
            if (afterViewLeft.equals(afterViewRight)) {
                return afterViewLeft;
            }
            if (afterViewLeft.equals(beforeView)) {
                return afterViewRight;
            }
            if (afterViewRight.equals(beforeView)) {
                return afterViewLeft;
            }
            throw new FeatureChangeMergeException(MergeFailureType.MUTUALLY_EXCLUSIVE_ADD_ADD_CONFLICT, "diffBasedMutuallyExclusiveMerger failed due to ADD/ADD conflict: beforeView was:\n{}\nbut afterViews were:\n{}\nvs\n{}", beforeView, afterViewLeft, afterViewRight);
        };
    }

    private static <T> void verifyExplicitlyExcludedSets(Set<T> beforeLeft, Set<T> afterLeft, Set<T> explicitlyExcludedLeft, Set<T> beforeRight, Set<T> afterRight, Set<T> explicitlyExcludedRight) {
        Sets.SetView<T> implicitlyRemovedFromLeft = Sets.difference(beforeLeft, afterLeft);
        Sets.SetView<T> implicitlyRemovedFromRight = Sets.difference(beforeRight, afterRight);
        if (!explicitlyExcludedLeft.equals(implicitlyRemovedFromLeft)) {
            throw new CoreException("explicitlyExcludedLeft set did not match the implicitly computed removedFromLeft set:\n{}\nvs\n{}\nThis is likely because members were removed without using the correct withXAndSource API", explicitlyExcludedLeft, implicitlyRemovedFromLeft);
        }
        if (!explicitlyExcludedRight.equals(implicitlyRemovedFromRight)) {
            throw new CoreException("explicitlyExcludedRight set did not match the implicitly computed removedFromRight set:\n{}\nvs\n{}\nThis is likely because members were removed without using the correct withXAndSource API", explicitlyExcludedRight, implicitlyRemovedFromRight);
        }
    }

    private MemberMergeStrategies() {
    }
}

