/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.MemberMergeStrategies;
import org.openstreetmap.atlas.geography.atlas.change.MemberMerger;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeatureChangeMergingHelpers {
    static final String IN_EDGE_IDENTIFIERS_FIELD = "inEdgeIdentifiers";
    static final String OUT_EDGE_IDENTIFIERS_FIELD = "outEdgeIdentifiers";
    private static final String AFTER_ENTITY_RIGHT_WAS_NULL = "afterEntityRight was null, this should never happen!";
    private static final String AFTER_ENTITY_LEFT_WAS_NULL = "afterEntityLeft was null, this should never happen!";
    private static final Logger logger = LoggerFactory.getLogger(FeatureChangeMergingHelpers.class);

    public static FeatureChange mergeADDFeatureChangePair(FeatureChange left, FeatureChange right) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean = new MemberMerger.Builder().withMemberName("tags").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(Taggable::getTags).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleTagMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedTagMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryTagMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryTagMerger).build().mergeMember();
        MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean = new MemberMerger.Builder().withMemberName("parentRelations").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> atlasEntity.relations() == null ? null : atlasEntity.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet())).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleLongSetMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongSetMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongSetMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLongSetMerger).build().mergeMember();
        if (afterEntityLeft instanceof LocationItem) {
            return FeatureChangeMergingHelpers.mergeLocationItems(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof LineItem) {
            return FeatureChangeMergingHelpers.mergeLineItems(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Area) {
            return FeatureChangeMergingHelpers.mergeAreas(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Relation) {
            return FeatureChangeMergingHelpers.mergeRelations(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown AtlasEntity subtype {}", afterEntityLeft.getClass().getName());
    }

    public static Map<String, String> mergeMetaData(FeatureChange left, FeatureChange right) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> leftMap = left.getMetaData();
        Map<String, String> rightMap = right.getMetaData();
        for (Map.Entry<String, String> leftEntry : leftMap.entrySet()) {
            if (rightMap.containsKey(leftEntry.getKey())) {
                String mergedValue;
                List<String> rightValues;
                List<String> leftValues = Arrays.asList(leftEntry.getValue().split(","));
                if (leftValues.equals(rightValues = Arrays.asList(rightMap.get(leftEntry.getKey()).split(",")))) {
                    mergedValue = new StringList(leftValues).join(",");
                } else {
                    TreeSet<String> values = new TreeSet<String>();
                    values.addAll(leftValues);
                    values.addAll(rightValues);
                    mergedValue = new StringList(values).join(",");
                }
                result.put(leftEntry.getKey(), mergedValue);
                continue;
            }
            result.put(leftEntry.getKey(), leftEntry.getValue());
        }
        for (Map.Entry<String, String> rightEntry : rightMap.entrySet()) {
            if (result.containsKey(rightEntry.getKey())) continue;
            result.put(rightEntry.getKey(), rightEntry.getValue());
        }
        return result;
    }

    public static FeatureChange mergeREMOVEFeatureChangePair(FeatureChange left, FeatureChange right) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        if (beforeEntityLeft instanceof Node) {
            Node beforeNodeLeft = (Node)beforeEntityLeft;
            Node beforeNodeRight = (Node)beforeEntityRight;
            CompleteNode mergedBeforeNode = CompleteNode.from(beforeNodeLeft);
            TreeSet leftInEdgeIdentifiers = new TreeSet(beforeNodeLeft.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
            TreeSet rightInEdgeIdentifiers = new TreeSet(beforeNodeRight.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
            TreeSet leftOutEdgeIdentifiers = new TreeSet(beforeNodeLeft.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
            TreeSet rightOutEdgeIdentifiers = new TreeSet(beforeNodeRight.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
            if (!((Object)leftInEdgeIdentifiers).equals(rightInEdgeIdentifiers)) {
                mergedBeforeNode.withInEdgeIdentifiers((SortedSet)MemberMergeStrategies.simpleLongSortedSetMerger.apply(leftInEdgeIdentifiers, rightInEdgeIdentifiers));
            }
            if (!((Object)leftOutEdgeIdentifiers).equals(rightOutEdgeIdentifiers)) {
                mergedBeforeNode.withOutEdgeIdentifiers((SortedSet)MemberMergeStrategies.simpleLongSortedSetMerger.apply(leftOutEdgeIdentifiers, rightOutEdgeIdentifiers));
            }
            return new FeatureChange(ChangeType.REMOVE, left.getAfterView(), mergedBeforeNode);
        }
        if (beforeEntityLeft instanceof Relation) {
            RelationBean rightMembers;
            Relation beforeRelationLeft = (Relation)beforeEntityLeft;
            Relation beforeRelationRight = (Relation)beforeEntityRight;
            CompleteRelation mergedBeforeRelation = CompleteRelation.from(beforeRelationLeft);
            RelationBean leftMembers = beforeRelationLeft.members().asBean();
            if (!leftMembers.equalsIncludingExplicitlyExcluded(rightMembers = beforeRelationRight.members().asBean())) {
                mergedBeforeRelation.withMembers(RelationBean.mergeBeans(leftMembers, rightMembers), Rectangle.forLocated(beforeRelationLeft, beforeRelationRight));
            }
            return new FeatureChange(ChangeType.REMOVE, left.getAfterView(), mergedBeforeRelation);
        }
        return left;
    }

    private static FeatureChange mergeAreas(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<Polygon> mergedPolygonBean = new MemberMerger.Builder().withMemberName("polygon").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((Area)atlasEntity).asPolygon()).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryPolygonMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedPolygonMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryPolygonMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryPolygonMerger).build().mergeMember();
        CompleteArea mergedAfterArea = new CompleteArea(left.getIdentifier(), mergedPolygonBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterArea.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterArea.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeArea = beforeEntityLeft != null ? ((CompleteArea)CompleteArea.shallowFrom((Area)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withPolygon(mergedPolygonBean.getMergedBeforeMember()).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterArea, (AtlasEntity)((Object)mergedBeforeArea));
    }

    private static FeatureChange mergeEdges(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<PolyLine> mergedPolyLineBean, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<Long> mergedStartNodeIdentifierBean = new MemberMerger.Builder().withMemberName("startNode").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(edge -> ((Edge)edge).start() == null ? null : Long.valueOf(((Edge)edge).start().getIdentifier())).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryLongMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLongMerger).build().mergeMember();
        MemberMerger.MergedMemberBean<Long> mergedEndNodeIdentifierBean = new MemberMerger.Builder().withMemberName("endNode").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(edge -> ((Edge)edge).end() == null ? null : Long.valueOf(((Edge)edge).end().getIdentifier())).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryLongMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLongMerger).build().mergeMember();
        CompleteEdge mergedAfterEdge = new CompleteEdge(left.getIdentifier(), mergedPolyLineBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedStartNodeIdentifierBean.getMergedAfterMember(), mergedEndNodeIdentifierBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterEdge.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterEdge.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeEdge = beforeEntityLeft != null ? ((CompleteEdge)CompleteEdge.shallowFrom((Edge)beforeEntityLeft).withStartNodeIdentifier(mergedStartNodeIdentifierBean.getMergedBeforeMember()).withEndNodeIdentifier(mergedEndNodeIdentifierBean.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withPolyLine(mergedPolyLineBean.getMergedBeforeMember()).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterEdge, (AtlasEntity)((Object)mergedBeforeEdge));
    }

    private static FeatureChange mergeLineItems(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<PolyLine> mergedPolyLineBean = new MemberMerger.Builder().withMemberName("polyLine").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((LineItem)atlasEntity).asPolyLine()).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryPolyLineMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedPolyLineMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryPolyLineMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryPolyLineMerger).build().mergeMember();
        if (afterEntityLeft instanceof Edge) {
            return FeatureChangeMergingHelpers.mergeEdges(left, right, mergedPolyLineBean, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Line) {
            return FeatureChangeMergingHelpers.mergeLines(left, right, mergedPolyLineBean, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown AtlasEntity subtype {}", afterEntityLeft.getClass().getName());
    }

    private static FeatureChange mergeLines(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<PolyLine> mergedPolyLineBean, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        CompleteLine mergedAfterLine = new CompleteLine(left.getIdentifier(), mergedPolyLineBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterLine.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterLine.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeLine = beforeEntityLeft != null ? ((CompleteLine)CompleteLine.shallowFrom((Line)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withPolyLine(mergedPolyLineBean.getMergedBeforeMember()).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterLine, (AtlasEntity)((Object)mergedBeforeLine));
    }

    private static FeatureChange mergeLocationItems(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<Location> mergedLocationBean = new MemberMerger.Builder().withMemberName("location").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((LocationItem)atlasEntity).getLocation()).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryLocationMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLocationMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLocationMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLocationMerger).build().mergeMember();
        if (afterEntityLeft instanceof Node) {
            return FeatureChangeMergingHelpers.mergeNodes(left, right, mergedLocationBean, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Point) {
            return FeatureChangeMergingHelpers.mergePoints(left, right, mergedLocationBean, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown LocationItem subtype {}", afterEntityLeft.getClass().getName());
    }

    private static FeatureChange mergeNodes(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Location> mergedLocationBean, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<SortedSet<Long>> mergedInEdgeIdentifiersBean = new MemberMerger.Builder().withMemberName(IN_EDGE_IDENTIFIERS_FIELD).withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((Node)atlasEntity).inEdges() == null ? null : (SortedSet)((Node)atlasEntity).inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new))).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleLongSortedSetMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongSortedSetMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongSortedSetMerger).withBeforeViewMerger(MemberMergeStrategies.simpleLongSortedSetMerger).useHackForMergingConflictingConnectedEdgeSetBeforeViews((CompleteNode)afterEntityLeft, (CompleteNode)afterEntityRight).build().mergeMember();
        MemberMerger.MergedMemberBean<SortedSet<Long>> mergedOutEdgeIdentifiersBean = new MemberMerger.Builder().withMemberName(OUT_EDGE_IDENTIFIERS_FIELD).withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((Node)atlasEntity).outEdges() == null ? null : (SortedSet)((Node)atlasEntity).outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new))).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleLongSortedSetMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongSortedSetMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongSortedSetMerger).withBeforeViewMerger(MemberMergeStrategies.simpleLongSortedSetMerger).useHackForMergingConflictingConnectedEdgeSetBeforeViews((CompleteNode)afterEntityLeft, (CompleteNode)afterEntityRight).build().mergeMember();
        CompleteNode mergedAfterNode = new CompleteNode(left.getIdentifier(), mergedLocationBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedInEdgeIdentifiersBean.getMergedAfterMember(), mergedOutEdgeIdentifiersBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterNode.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterNode.withBoundsExtendedBy(afterEntityRight.bounds());
        mergedAfterNode.setExplicitlyExcludedInEdgeIdentifiers((Set)MemberMergeStrategies.simpleLongSetMerger.apply(((CompleteNode)afterEntityLeft).explicitlyExcludedInEdgeIdentifiers(), ((CompleteNode)afterEntityRight).explicitlyExcludedInEdgeIdentifiers()));
        mergedAfterNode.setExplicitlyExcludedOutEdgeIdentifiers((Set)MemberMergeStrategies.simpleLongSetMerger.apply(((CompleteNode)afterEntityLeft).explicitlyExcludedOutEdgeIdentifiers(), ((CompleteNode)afterEntityRight).explicitlyExcludedOutEdgeIdentifiers()));
        CompleteEntity mergedBeforeNode = beforeEntityLeft != null ? ((CompleteNode)CompleteNode.shallowFrom((Node)beforeEntityLeft).withInEdgeIdentifiers(mergedInEdgeIdentifiersBean.getMergedBeforeMember()).withOutEdgeIdentifiers(mergedOutEdgeIdentifiersBean.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withLocation(mergedLocationBean.getMergedBeforeMember()).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterNode, (AtlasEntity)((Object)mergedBeforeNode));
    }

    private static FeatureChange mergePoints(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Location> mergedLocationBean, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        CompletePoint mergedAfterPoint = new CompletePoint(left.getIdentifier(), mergedLocationBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterPoint.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterPoint.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforePoint = beforeEntityLeft != null ? ((CompletePoint)CompletePoint.shallowFrom((Point)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withLocation(mergedLocationBean.getMergedBeforeMember()).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterPoint, (AtlasEntity)((Object)mergedBeforePoint));
    }

    private static FeatureChange mergeRelations(FeatureChange left, FeatureChange right, MemberMerger.MergedMemberBean<Map<String, String>> mergedTagsBean, MemberMerger.MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MemberMerger.MergedMemberBean<RelationBean> mergedMembersBean = new MemberMerger.Builder().withMemberName("relationMembers").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(entity -> ((Relation)entity).members() == null ? null : ((Relation)entity).members().asBean()).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleRelationBeanMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedRelationBeanMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.conflictingBeforeViewRelationBeanMerger).withBeforeViewMerger(MemberMergeStrategies.simpleRelationBeanMerger).build().mergeMember();
        MemberMerger.MergedMemberBean<Set<Long>> mergedAllRelationsWithSameOsmIdentifierBean = new MemberMerger.Builder().withMemberName("allRelationsWithSameOsmIdentifier").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(atlasEntity -> ((Relation)atlasEntity).allRelationsWithSameOsmIdentifier() == null ? null : ((Relation)atlasEntity).allRelationsWithSameOsmIdentifier().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet())).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleLongSetMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongSetMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongSetMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLongSetMerger).build().mergeMember();
        MemberMerger.MergedMemberBean<RelationBean> mergedAllKnownMembersBean = new MemberMerger.Builder().withMemberName("allKnownOsmMembers").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(entity -> ((Relation)entity).allKnownOsmMembers() == null ? null : ((Relation)entity).allKnownOsmMembers().asBean()).withAfterViewNoBeforeMerger(MemberMergeStrategies.simpleRelationBeanMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedRelationBeanMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.conflictingBeforeViewRelationBeanMerger).withBeforeViewMerger(MemberMergeStrategies.simpleRelationBeanMerger).build().mergeMember();
        MemberMerger.MergedMemberBean<Long> mergedOsmRelationIdentifier = new MemberMerger.Builder().withMemberName("osmRelationIdentifier").withBeforeEntityLeft(beforeEntityLeft).withAfterEntityLeft(afterEntityLeft).withBeforeEntityRight(beforeEntityRight).withAfterEntityRight(afterEntityRight).withMemberExtractor(entity -> ((Relation)entity).osmRelationIdentifier()).withAfterViewNoBeforeMerger(MemberMergeStrategies.autofailBinaryLongMerger).withAfterViewConsistentBeforeViewMerger(MemberMergeStrategies.diffBasedLongMerger).withAfterViewConflictingBeforeViewMerger(MemberMergeStrategies.autofailQuaternaryLongMerger).withBeforeViewMerger(MemberMergeStrategies.autofailBinaryLongMerger).build().mergeMember();
        Rectangle mergedBounds = Rectangle.forLocated(afterEntityLeft, afterEntityRight);
        CompleteRelation mergedAfterRelation = new CompleteRelation(left.getIdentifier(), mergedTagsBean.getMergedAfterMember(), mergedBounds, mergedMembersBean.getMergedAfterMember(), mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember() != null ? mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember().stream().collect(Collectors.toList()) : null, mergedAllKnownMembersBean.getMergedAfterMember(), mergedOsmRelationIdentifier.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterRelation.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterRelation.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeRelation = beforeEntityLeft != null ? ((CompleteRelation)CompleteRelation.shallowFrom((Relation)beforeEntityLeft).withMembers(mergedMembersBean.getMergedBeforeMember(), beforeEntityLeft.bounds()).withAllRelationsWithSameOsmIdentifier(mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember() != null ? mergedAllRelationsWithSameOsmIdentifierBean.getMergedBeforeMember().stream().collect(Collectors.toList()) : null).withAllKnownOsmMembers(mergedAllKnownMembersBean.getMergedBeforeMember()).withOsmRelationIdentifier(mergedOsmRelationIdentifier.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterRelation, (AtlasEntity)((Object)mergedBeforeRelation));
    }

    private FeatureChangeMergingHelpers() {
    }
}

