/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.AtlasEntityKey;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;

public class FeatureChangeBoundsExpander {
    private final Set<FeatureChange> featureChanges;
    private Atlas atlas;
    private final Predicate<FeatureChange> needsUpdate = featureChange -> {
        if (featureChange.getItemType() == ItemType.NODE) {
            return true;
        }
        if (featureChange.getChangeType() == ChangeType.ADD) {
            return false;
        }
        Set<Relation> relations = featureChange.getAfterView().relations();
        if (relations != null && !relations.isEmpty()) {
            return true;
        }
        AtlasEntity entity = this.atlas.entity(featureChange.getIdentifier(), featureChange.getItemType());
        return entity != null && !entity.relations().isEmpty();
    };
    private final Set<FeatureChange> result = new HashSet<FeatureChange>();
    private final Set<FeatureChange> featureChangesToUpdate = new HashSet<FeatureChange>();
    private final MultiMapWithSet<AtlasEntityKey, Rectangle> typeIdentifierToExtensionBounds = new MultiMapWithSet();
    private final Map<AtlasEntityKey, FeatureChange> typeIdentifierToFeatureChange = new HashMap<AtlasEntityKey, FeatureChange>();

    public FeatureChangeBoundsExpander(Set<FeatureChange> featureChanges, Atlas atlas) {
        this.featureChanges = featureChanges;
        this.atlas = atlas;
    }

    public Set<FeatureChange> apply() {
        if (!this.result.isEmpty()) {
            throw new CoreException("Cannot apply the same bounds expander twice!");
        }
        this.featureChanges.forEach(featureChange -> this.typeIdentifierToFeatureChange.put(AtlasEntityKey.from(featureChange.getItemType(), featureChange.getIdentifier()), (FeatureChange)featureChange));
        this.findBounds();
        for (FeatureChange featureChange2 : this.featureChangesToUpdate) {
            Object expansionRectangles = this.typeIdentifierToExtensionBounds.get(AtlasEntityKey.from(featureChange2.getItemType(), featureChange2.getIdentifier()));
            FeatureChange newFeatureChange = featureChange2;
            if (expansionRectangles != null) {
                newFeatureChange = new FeatureChange(featureChange2.getChangeType(), this.expanded(featureChange2.getAfterView(), (Set<Rectangle>)expansionRectangles), featureChange2.getBeforeView());
            }
            this.result.add(newFeatureChange);
        }
        return this.result;
    }

    private AtlasEntity expanded(AtlasEntity other, Set<Rectangle> expansionRectangles) {
        Rectangle newBounds = Rectangle.forLocated(expansionRectangles);
        if (other instanceof CompleteNode) {
            return ((CompleteNode)other).withBoundsExtendedBy(newBounds);
        }
        if (other instanceof CompleteEdge) {
            return ((CompleteEdge)other).withBoundsExtendedBy(newBounds);
        }
        if (other instanceof CompleteArea) {
            return ((CompleteArea)other).withBoundsExtendedBy(newBounds);
        }
        if (other instanceof CompleteLine) {
            return ((CompleteLine)other).withBoundsExtendedBy(newBounds);
        }
        if (other instanceof CompletePoint) {
            return ((CompletePoint)other).withBoundsExtendedBy(newBounds);
        }
        if (other instanceof CompleteRelation) {
            return ((CompleteRelation)other).withBoundsExtendedBy(newBounds);
        }
        throw new CoreException("AtlasEntity is of a non-workable type: {}", other.getClass().getName());
    }

    private void findBounds() {
        for (FeatureChange featureChange : this.featureChanges) {
            ItemType itemType = featureChange.getItemType();
            if (this.needsUpdate.test(featureChange)) {
                this.featureChangesToUpdate.add(featureChange);
            } else {
                this.result.add(featureChange);
            }
            if (itemType == ItemType.RELATION) {
                this.findBoundsFromRelation((Relation)featureChange.getAfterView());
                Relation relationFromAtlas = this.atlas.relation(featureChange.getIdentifier());
                if (relationFromAtlas != null) {
                    this.findBoundsFromRelation(relationFromAtlas);
                }
            }
            if (itemType != ItemType.EDGE) continue;
            this.findBoundsFromEdge((Edge)featureChange.getAfterView());
            Edge edgeFromAtlas = this.atlas.edge(featureChange.getIdentifier());
            if (edgeFromAtlas == null) continue;
            this.findBoundsFromEdge(edgeFromAtlas);
        }
        for (Edge edge : this.atlas.edges()) {
            AtlasEntityKey startKey = AtlasEntityKey.from(ItemType.NODE, edge.start().getIdentifier());
            AtlasEntityKey endKey = AtlasEntityKey.from(ItemType.NODE, edge.end().getIdentifier());
            if (!this.typeIdentifierToFeatureChange.containsKey(startKey) && !this.typeIdentifierToFeatureChange.containsKey(endKey)) continue;
            this.findBoundsFromEdge(edge);
        }
        for (Relation relation : this.atlas.relations()) {
            HashSet memberKeys = new HashSet();
            relation.members().forEach(member -> memberKeys.add(AtlasEntityKey.from(member.getEntity().getType(), member.getEntity().getIdentifier())));
            if (!memberKeys.stream().anyMatch(this.typeIdentifierToFeatureChange::containsKey)) continue;
            this.findBoundsFromRelation(relation);
        }
    }

    private void findBoundsFromEdge(Edge edge) {
        Node start = edge.start();
        Node end = edge.end();
        Rectangle bounds = edge.bounds();
        if (start != null) {
            this.typeIdentifierToExtensionBounds.add(AtlasEntityKey.from(ItemType.NODE, start.getIdentifier()), bounds);
        }
        if (end != null) {
            this.typeIdentifierToExtensionBounds.add(AtlasEntityKey.from(ItemType.NODE, end.getIdentifier()), bounds);
        }
    }

    private void findBoundsFromRelation(Relation relation) {
        RelationMemberList members = relation.members();
        if (members != null && !members.isEmpty()) {
            Rectangle bounds = relation.bounds();
            members.forEach(relationMember -> {
                AtlasEntity entity = relationMember.getEntity();
                this.typeIdentifierToExtensionBounds.add(AtlasEntityKey.from(entity.getType(), entity.getIdentifier()), bounds);
            });
        }
    }
}

