/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeNode
extends Node {
    private static final long serialVersionUID = 4353679260691518275L;
    private static final Logger logger = LoggerFactory.getLogger(ChangeNode.class);
    private final Node source;
    private final Node override;
    private transient Set<Relation> relationsCache;
    private transient Object relationsCacheLock = new Object();
    private transient SortedSet<Edge> inEdgesCache;
    private transient Object inEdgesCacheLock = new Object();
    private transient SortedSet<Edge> outEdgesCache;
    private transient Object outEdgesCacheLock = new Object();

    protected ChangeNode(ChangeAtlas atlas, Node source, Node override) {
        super(atlas);
        this.source = source;
        this.override = override;
    }

    @Override
    public long getIdentifier() {
        return this.attribute(AtlasObject::getIdentifier, "identifier");
    }

    @Override
    public Location getLocation() {
        return this.attribute(LocationItem::getLocation, "location");
    }

    @Override
    public Map<String, String> getTags() {
        return this.attribute(Taggable::getTags, "tags");
    }

    public SortedSet<Long> inEdgeIdentifiers() {
        List<SortedSet> inEdgeSetList = this.allAvailableAttributes(Node::inEdges, "in edges");
        Set mergedIdentifiers = inEdgeSetList.stream().flatMap(Collection::stream).map(AtlasObject::getIdentifier).filter(edgeIdentifier -> this.getChangeAtlas().edge((long)edgeIdentifier) != null).collect(Collectors.toSet());
        if (this.override != null) {
            CompleteNode completeNodeOverride = (CompleteNode)this.override;
            mergedIdentifiers = mergedIdentifiers.stream().filter(edgeIdentifier -> !completeNodeOverride.explicitlyExcludedInEdgeIdentifiers().contains(edgeIdentifier)).collect(Collectors.toSet());
        }
        return new TreeSet<Long>(mergedIdentifiers);
    }

    @Override
    public SortedSet<Edge> inEdges() {
        Supplier<SortedSet> creator = () -> this.inEdgeIdentifiers().stream().map(edgeIdentifier -> this.getChangeAtlas().edge((long)edgeIdentifier)).collect(Collectors.toCollection(TreeSet::new));
        return ChangeEntity.getOrCreateCache(this.inEdgesCache, cache -> {
            this.inEdgesCache = cache;
        }, this.inEdgesCacheLock, creator);
    }

    public SortedSet<Long> outEdgeIdentifiers() {
        List<SortedSet> outEdgeSetList = this.allAvailableAttributes(Node::outEdges, "out edges");
        Set mergedIdentifiers = outEdgeSetList.stream().flatMap(Collection::stream).map(AtlasObject::getIdentifier).filter(edgeIdentifier -> this.getChangeAtlas().edge((long)edgeIdentifier) != null).collect(Collectors.toSet());
        if (this.override != null) {
            CompleteNode completeNodeOverride = (CompleteNode)this.override;
            mergedIdentifiers = mergedIdentifiers.stream().filter(edgeIdentifier -> !completeNodeOverride.explicitlyExcludedOutEdgeIdentifiers().contains(edgeIdentifier)).collect(Collectors.toSet());
        }
        return new TreeSet<Long>(mergedIdentifiers);
    }

    @Override
    public SortedSet<Edge> outEdges() {
        Supplier<SortedSet> creator = () -> this.outEdgeIdentifiers().stream().map(edgeIdentifier -> this.getChangeAtlas().edge((long)edgeIdentifier)).collect(Collectors.toCollection(TreeSet::new));
        return ChangeEntity.getOrCreateCache(this.outEdgesCache, cache -> {
            this.outEdgesCache = cache;
        }, this.outEdgesCacheLock, creator);
    }

    @Override
    public Set<Relation> relations() {
        Supplier<Set> creator = () -> ChangeEntity.filterRelations(this.attribute(AtlasEntity::relations, "relations"), this.getChangeAtlas());
        return ChangeEntity.getOrCreateCache(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, creator);
    }

    private <T> List<T> allAvailableAttributes(Function<Node, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeAndOptionallyBackup(this.source, this.override, memberExtractor, name);
    }

    private <T> T attribute(Function<Node, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeOrBackup(this.source, this.override, memberExtractor, name);
    }

    private ChangeAtlas getChangeAtlas() {
        return (ChangeAtlas)this.getAtlas();
    }
}

