/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public final class ChangeEntity {
    static Set<Relation> filterRelations(Set<Relation> listed, ChangeAtlas parent) {
        return listed.stream().map(relation -> parent.relation(relation.getIdentifier())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    static <T, M extends AtlasEntity> List<T> getAttributeAndOptionallyBackup(M source, M override, Function<M, T> memberExtractor, String name) {
        T member;
        ArrayList<T> result = new ArrayList<T>();
        if (override != null && (member = memberExtractor.apply(override)) != null) {
            result.add(member);
        }
        if (source != null && (member = memberExtractor.apply(source)) != null) {
            result.add(member);
        }
        if (result.isEmpty()) {
            throw new CoreException("Could not retrieve attribute \"{}\" from override nor source!\noverride: {}\nsource:{}", name, override, source);
        }
        return result;
    }

    static <T, M extends AtlasEntity> T getAttributeOrBackup(M source, M override, Function<M, T> memberExtractor, String name) {
        T result = null;
        if (override != null) {
            result = memberExtractor.apply(override);
        }
        if (result == null && source != null) {
            result = memberExtractor.apply(source);
        }
        if (result == null) {
            throw new CoreException("Could not retrieve attribute \"{}\" from override nor source!\noverride: {}\nsource:{}", name, override, source);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> V getOrCreateCache(V fieldCache, Consumer<V> cacheSetter, Object lock, Supplier<V> creator) {
        V localRelationCache = fieldCache;
        if (localRelationCache == null) {
            Object object = lock;
            synchronized (object) {
                localRelationCache = fieldCache;
                if (localRelationCache == null) {
                    localRelationCache = creator.get();
                    cacheSetter.accept(localRelationCache);
                }
            }
        }
        return localRelationCache;
    }

    private ChangeEntity() {
    }
}

