/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.validators.ChangeValidator;

public class ChangeBuilder {
    private final Change change = new Change();
    private boolean open = true;

    public static ChangeBuilder newInstance() {
        return new ChangeBuilder();
    }

    public synchronized ChangeBuilder add(FeatureChange featureChange) {
        if (!this.open) {
            throw new CoreException("Cannot append to a Change object that has already been validated");
        }
        this.change.add(featureChange);
        return this;
    }

    public synchronized ChangeBuilder addAll(Stream<FeatureChange> featureChanges) {
        featureChanges.forEach(this::add);
        return this;
    }

    public synchronized ChangeBuilder addAll(Iterable<FeatureChange> featureChanges) {
        return this.addAll(StreamSupport.stream(featureChanges.spliterator(), false));
    }

    public synchronized ChangeBuilder addAll(FeatureChange ... featureChanges) {
        return this.addAll(Arrays.stream(featureChanges));
    }

    public synchronized Change get() {
        new ChangeValidator(this.change).validate();
        this.open = false;
        return this.change;
    }

    public synchronized int peekNumberOfChanges() {
        return this.change.changeCount();
    }

    public ChangeBuilder withName(String name) {
        this.change.withName(name);
        return this;
    }
}

