/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.AbstractAtlas;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeArea;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEdge;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.change.ChangeLine;
import org.openstreetmap.atlas.geography.atlas.change.ChangeNode;
import org.openstreetmap.atlas.geography.atlas.change.ChangePoint;
import org.openstreetmap.atlas.geography.atlas.change.ChangeRelation;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.validators.AtlasValidator;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class ChangeAtlas
extends AbstractAtlas {
    private static final long serialVersionUID = -5741815439928958165L;
    private static final ChangeRelation NULL_PLACEHOLDER_RELATION = new ChangeRelation(null, null, null);
    private static final ChangeNode NULL_PLACEHOLDER_NODE = new ChangeNode(null, null, null);
    private static final ChangeEdge NULL_PLACEHOLDER_EDGE = new ChangeEdge(null, null, null);
    private static final ChangeArea NULL_PLACEHOLDER_AREA = new ChangeArea(null, null, null);
    private static final ChangeLine NULL_PLACEHOLDER_LINE = new ChangeLine(null, null, null);
    private static final ChangePoint NULL_PLACEHOLDER_POINT = new ChangePoint(null, null, null);
    private final Change change;
    private final Atlas source;
    private String name;
    private boolean validated = false;
    private transient Rectangle bounds;
    private transient AtlasMetaData metaData;
    private transient Long numberOfNodes;
    private transient Long numberOfEdges;
    private transient Long numberOfAreas;
    private transient Long numberOfLines;
    private transient Long numberOfPoints;
    private transient Long numberOfRelations;
    private transient Map<Long, ChangeRelation> relationsCache;
    private transient Object relationsCacheLock = new Object();
    private transient Map<Long, ChangeNode> nodesCache;
    private transient Object nodesCacheLock = new Object();
    private transient Map<Long, ChangeEdge> edgesCache;
    private transient Object edgesCacheLock = new Object();
    private transient Map<Long, ChangeArea> areasCache;
    private transient Object areasCacheLock = new Object();
    private transient Map<Long, ChangeLine> linesCache;
    private transient Object linesCacheLock = new Object();
    private transient Map<Long, ChangePoint> pointsCache;
    private transient Object pointsCacheLock = new Object();

    private static void checkChanges(Change ... changes) {
        if (changes == null) {
            throw new CoreException("Change cannot be null in a ChangeAtlas.");
        }
        if (changes.length < 1) {
            throw new CoreException("ChangeAtlas has to have at least one Change.");
        }
    }

    private static void checkSource(Atlas source) {
        if (source == null) {
            throw new CoreException("Source Atlas cannot be null in a ChangeAtlas.");
        }
    }

    public ChangeAtlas(Atlas source, Change ... changes) {
        this(source, "", changes);
    }

    public ChangeAtlas(Atlas source, String name, Change ... changes) {
        ChangeAtlas.checkSource(source);
        ChangeAtlas.checkChanges(changes);
        this.change = Change.merge(changes);
        this.source = source;
        this.name = name == null || name.isEmpty() ? source.getName() : name;
        this.validate();
    }

    public ChangeAtlas(Change ... changes) {
        this("", changes);
    }

    public ChangeAtlas(String name, Change ... changes) {
        ChangeAtlas.checkChanges(changes);
        Change changeInternal = Change.merge(changes);
        boolean valid = false;
        Atlas sourceInternal = null;
        FeatureChange dummy = null;
        for (FeatureChange featureChange : changeInternal.getFeatureChanges()) {
            if (featureChange.getChangeType() != ChangeType.ADD) continue;
            if (!featureChange.afterViewIsFull()) {
                throw new CoreException("ChangeAtlas needs all ADD featureChanges to be full (no partial after view) to exist with no source Atlas.");
            }
            if (sourceInternal == null) {
                PackedAtlasBuilder builder = new PackedAtlasBuilder();
                builder.addPoint(-1L, Location.CENTER, Maps.hashMap(new String[0]));
                sourceInternal = builder.get();
                dummy = FeatureChange.remove(CompletePoint.shallowFrom(sourceInternal.point(-1L)));
            }
            valid = true;
        }
        if (!valid) {
            throw new CoreException("ChangeAtlas needs at least a full ADD featureChange to exist with no source Atlas.");
        }
        ChangeBuilder changeBuilder = new ChangeBuilder();
        changeBuilder.addAll(changeInternal.changes());
        changeBuilder.add(dummy);
        this.change = changeBuilder.get();
        this.source = sourceInternal;
        this.name = name == null || name.isEmpty() ? sourceInternal.getName() : name;
        new AtlasValidator(this).validate();
    }

    @Override
    public Area area(long identifier) {
        Supplier<ChangeArea> creator = () -> this.entityFor(identifier, ItemType.AREA, () -> this.source.area(identifier), (sourceEntity, overrideEntity) -> new ChangeArea(this, (Area)sourceEntity, (Area)overrideEntity));
        return this.getFromCacheOrCreate(this.areasCache, cache -> {
            this.areasCache = cache;
        }, this.areasCacheLock, NULL_PLACEHOLDER_AREA, identifier, creator);
    }

    @Override
    public Iterable<Area> areas() {
        return this.entitiesFor(ItemType.AREA, this::area, this.source.areas());
    }

    @Override
    public synchronized Rectangle bounds() {
        if (this.bounds == null) {
            this.bounds = Rectangle.forLocated(Iterables.stream(this));
        }
        return this.bounds;
    }

    @Override
    public Edge edge(long identifier) {
        Predicate<ChangeEdge> nullableEdge = edge -> edge.start() == null || edge.end() == null;
        Supplier<ChangeEdge> creator = () -> this.entityFor(identifier, ItemType.EDGE, () -> this.source.edge(identifier), (sourceEntity, overrideEntity) -> new ChangeEdge(this, (Edge)sourceEntity, (Edge)overrideEntity));
        return this.getFromCacheOrCreate(this.edgesCache, cache -> {
            this.edgesCache = cache;
        }, this.edgesCacheLock, NULL_PLACEHOLDER_EDGE, identifier, creator, Optional.of(nullableEdge));
    }

    @Override
    public Iterable<Edge> edges() {
        return this.entitiesFor(ItemType.EDGE, this::edge, this.source.edges());
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return super.getName();
        }
        return this.name;
    }

    @Override
    public Line line(long identifier) {
        Supplier<ChangeLine> creator = () -> this.entityFor(identifier, ItemType.LINE, () -> this.source.line(identifier), (sourceEntity, overrideEntity) -> new ChangeLine(this, (Line)sourceEntity, (Line)overrideEntity));
        return this.getFromCacheOrCreate(this.linesCache, cache -> {
            this.linesCache = cache;
        }, this.linesCacheLock, NULL_PLACEHOLDER_LINE, identifier, creator);
    }

    @Override
    public Iterable<Line> lines() {
        return this.entitiesFor(ItemType.LINE, this::line, this.source.lines());
    }

    @Override
    public synchronized AtlasMetaData metaData() {
        if (this.metaData == null) {
            AtlasMetaData sourceMetaData = this.source.metaData();
            if (sourceMetaData == null) {
                sourceMetaData = new AtlasMetaData();
            }
            AtlasSize size = new AtlasSize(this);
            this.metaData = sourceMetaData.copyWithNewSize(size).copyWithNewOriginal(false);
        }
        return this.metaData;
    }

    @Override
    public Node node(long identifier) {
        Supplier<ChangeNode> creator = () -> this.entityFor(identifier, ItemType.NODE, () -> this.source.node(identifier), (sourceEntity, overrideEntity) -> new ChangeNode(this, (Node)sourceEntity, (Node)overrideEntity));
        return this.getFromCacheOrCreate(this.nodesCache, cache -> {
            this.nodesCache = cache;
        }, this.nodesCacheLock, NULL_PLACEHOLDER_NODE, identifier, creator);
    }

    @Override
    public Iterable<Node> nodes() {
        return this.entitiesFor(ItemType.NODE, this::node, this.source.nodes());
    }

    @Override
    public synchronized long numberOfAreas() {
        if (this.numberOfAreas == null) {
            this.numberOfAreas = Iterables.size(this.areas());
        }
        return this.numberOfAreas;
    }

    @Override
    public synchronized long numberOfEdges() {
        if (this.numberOfEdges == null) {
            this.numberOfEdges = Iterables.size(this.edges());
        }
        return this.numberOfEdges;
    }

    @Override
    public synchronized long numberOfLines() {
        if (this.numberOfLines == null) {
            this.numberOfLines = Iterables.size(this.lines());
        }
        return this.numberOfLines;
    }

    @Override
    public synchronized long numberOfNodes() {
        if (this.numberOfNodes == null) {
            this.numberOfNodes = Iterables.size(this.nodes());
        }
        return this.numberOfNodes;
    }

    @Override
    public synchronized long numberOfPoints() {
        if (this.numberOfPoints == null) {
            this.numberOfPoints = Iterables.size(this.points());
        }
        return this.numberOfPoints;
    }

    @Override
    public synchronized long numberOfRelations() {
        if (this.numberOfRelations == null) {
            this.numberOfRelations = Iterables.size(this.relations());
        }
        return this.numberOfRelations;
    }

    @Override
    public Point point(long identifier) {
        Supplier<ChangePoint> creator = () -> this.entityFor(identifier, ItemType.POINT, () -> this.source.point(identifier), (sourceEntity, overrideEntity) -> new ChangePoint(this, (Point)sourceEntity, (Point)overrideEntity));
        return this.getFromCacheOrCreate(this.pointsCache, cache -> {
            this.pointsCache = cache;
        }, this.pointsCacheLock, NULL_PLACEHOLDER_POINT, identifier, creator);
    }

    @Override
    public Iterable<Point> points() {
        return this.entitiesFor(ItemType.POINT, this::point, this.source.points());
    }

    @Override
    public Relation relation(long identifier) {
        Predicate<ChangeRelation> nullableRelation = relationCandidate -> relationCandidate.members().isEmpty();
        Supplier<ChangeRelation> creator = () -> this.entityFor(identifier, ItemType.RELATION, () -> this.source.relation(identifier), (sourceEntity, overrideEntity) -> new ChangeRelation(this, (Relation)sourceEntity, (Relation)overrideEntity));
        return this.getFromCacheOrCreate(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, NULL_PLACEHOLDER_RELATION, identifier, creator, Optional.of(nullableRelation));
    }

    @Override
    public Iterable<Relation> relations() {
        return this.entitiesFor(ItemType.RELATION, this::relation, this.source.relations());
    }

    public void validate() {
        if (!this.validated) {
            new AtlasValidator(this).validate();
            this.validated = true;
        }
    }

    public ChangeAtlas withName(String name) {
        this.name = name;
        return this;
    }

    private <M extends AtlasEntity> Iterable<M> entitiesFor(ItemType itemType, LongFunction<M> entityForIdentifier, Iterable<M> sourceEntities) {
        return new MultiIterable(this.change.getFeatureChanges().stream().filter(featureChange -> featureChange.getItemType() == itemType && featureChange.getChangeType() == ChangeType.ADD).map(featureChange -> (AtlasEntity)entityForIdentifier.apply(featureChange.getIdentifier())).filter(Objects::nonNull).collect(Collectors.toList()), Iterables.stream(sourceEntities).filter(entity -> !this.change.changeFor(itemType, entity.getIdentifier()).isPresent()).map(entity -> (AtlasEntity)entityForIdentifier.apply(entity.getIdentifier())).filter(Objects::nonNull).collect());
    }

    private <M extends AtlasEntity> M entityFor(long identifier, ItemType itemType, Supplier<AtlasEntity> sourceSupplier, BiFunction<AtlasEntity, AtlasEntity, M> entityConstructorFromSource) {
        Optional<FeatureChange> itemChangeOption = this.change.changeFor(itemType, identifier);
        AtlasEntity sourceItem = sourceSupplier.get();
        if (itemChangeOption.isPresent()) {
            FeatureChange itemChange = itemChangeOption.get();
            if (ChangeType.REMOVE == itemChange.getChangeType()) {
                return null;
            }
            return (M)((AtlasEntity)entityConstructorFromSource.apply(sourceItem, itemChange.getAfterView()));
        }
        if (sourceItem != null) {
            return (M)((AtlasEntity)entityConstructorFromSource.apply(sourceItem, null));
        }
        return null;
    }

    private <E> E getFromCacheOrCreate(Map<Long, E> cache, Consumer<Map<Long, E>> cacheSetter, Object lock, E nullPlaceholder, Long identifier, Supplier<E> creator) {
        return this.getFromCacheOrCreate(cache, cacheSetter, lock, nullPlaceholder, identifier, creator, Optional.empty());
    }

    private <E> E getFromCacheOrCreate(Map<Long, E> cache, Consumer<Map<Long, E>> cacheSetter, Object lock, E nullPlaceholder, Long identifier, Supplier<E> creator, Optional<Predicate<E>> entityNullable) {
        Object result;
        Map cacheIn = ChangeEntity.getOrCreateCache(cache, cacheSetter, lock, ConcurrentHashMap::new);
        if (cacheIn.containsKey(identifier)) {
            result = cacheIn.get(identifier);
            result = result == nullPlaceholder ? null : result;
        } else {
            result = creator.get();
            if (result == null || entityNullable.isPresent() && entityNullable.get().test(result)) {
                cacheIn.put(identifier, nullPlaceholder);
                result = null;
            } else {
                cacheIn.put(identifier, result);
            }
        }
        return result;
    }
}

