/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder.store;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveEdgeIdentifier;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveRoute;

public class AtlasPrimitiveRouteIdentifier
implements Iterable<AtlasPrimitiveEdgeIdentifier>,
Serializable {
    private static final long serialVersionUID = 2321636844479248974L;
    private List<AtlasPrimitiveEdgeIdentifier> primitiveRouteIdentifier;

    public static AtlasPrimitiveRouteIdentifier from(AtlasPrimitiveRoute atlasPrimitiveRoute) {
        ArrayList<AtlasPrimitiveEdgeIdentifier> atlasPrimitiveEdgeIds = new ArrayList<AtlasPrimitiveEdgeIdentifier>();
        atlasPrimitiveRoute.forEach(edge -> atlasPrimitiveEdgeIds.add(AtlasPrimitiveEdgeIdentifier.from(edge)));
        return new AtlasPrimitiveRouteIdentifier(atlasPrimitiveEdgeIds);
    }

    public AtlasPrimitiveRouteIdentifier() {
    }

    public AtlasPrimitiveRouteIdentifier(AtlasPrimitiveEdgeIdentifier ... primitiveEdgeIds) {
        this.primitiveRouteIdentifier = ImmutableList.copyOf(primitiveEdgeIds);
    }

    public AtlasPrimitiveRouteIdentifier(Iterable<AtlasPrimitiveEdgeIdentifier> primitiveEdgeIds) {
        this.primitiveRouteIdentifier = ImmutableList.copyOf(primitiveEdgeIds);
    }

    public AtlasPrimitiveEdgeIdentifier end() {
        if (this.primitiveRouteIdentifier.size() > 0) {
            return this.primitiveRouteIdentifier.get(this.primitiveRouteIdentifier.size() - 1);
        }
        throw new CoreException("Illegal State : Empty route");
    }

    public boolean equals(Object other) {
        if (other instanceof AtlasPrimitiveRouteIdentifier) {
            AtlasPrimitiveRouteIdentifier that = (AtlasPrimitiveRouteIdentifier)other;
            if (this.primitiveRouteIdentifier.size() == that.primitiveRouteIdentifier.size()) {
                return new EqualsBuilder().append(this.primitiveRouteIdentifier, that.primitiveRouteIdentifier).isEquals();
            }
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.primitiveRouteIdentifier).hashCode();
    }

    public boolean isOverlappedBy(AtlasPrimitiveRouteIdentifier primitiveRouteIdentifier) {
        if (primitiveRouteIdentifier == null) {
            return false;
        }
        int lastOverlapIndex = -1;
        for (AtlasPrimitiveEdgeIdentifier primitiveEdgeIdentifier : primitiveRouteIdentifier) {
            int index = this.primitiveRouteIdentifier.indexOf(primitiveEdgeIdentifier);
            if (index <= lastOverlapIndex) {
                return false;
            }
            lastOverlapIndex = index;
        }
        return true;
    }

    @Override
    public Iterator<AtlasPrimitiveEdgeIdentifier> iterator() {
        return this.primitiveRouteIdentifier.iterator();
    }

    public int overlapCount(AtlasPrimitiveRouteIdentifier subRouteIdentifier) {
        int overlapCount = 0;
        if (this.primitiveRouteIdentifier == null || subRouteIdentifier == null) {
            return overlapCount;
        }
        Iterator<AtlasPrimitiveEdgeIdentifier> subRouteIdentifierIterator = subRouteIdentifier.iterator();
        AtlasPrimitiveEdgeIdentifier subRouteEdgeIdentifier = subRouteIdentifierIterator.hasNext() ? subRouteIdentifierIterator.next() : null;
        for (AtlasPrimitiveEdgeIdentifier edge : this.primitiveRouteIdentifier) {
            if (subRouteEdgeIdentifier == null) break;
            if (edge.equals(subRouteEdgeIdentifier)) {
                if (!subRouteIdentifierIterator.hasNext()) {
                    ++overlapCount;
                    subRouteIdentifierIterator = subRouteIdentifier.iterator();
                }
            } else {
                subRouteIdentifierIterator = subRouteIdentifier.iterator();
                if (edge.equals(subRouteIdentifier.start())) {
                    subRouteEdgeIdentifier = subRouteIdentifierIterator.hasNext() ? subRouteIdentifierIterator.next() : null;
                }
            }
            subRouteEdgeIdentifier = subRouteIdentifierIterator.hasNext() ? subRouteIdentifierIterator.next() : null;
        }
        return overlapCount;
    }

    public void setPrimitiveRouteIdentifier(List<AtlasPrimitiveEdgeIdentifier> primitiveRouteIdentifier) {
        this.primitiveRouteIdentifier = primitiveRouteIdentifier;
    }

    public int size() {
        return this.primitiveRouteIdentifier.size();
    }

    public AtlasPrimitiveEdgeIdentifier start() {
        if (this.primitiveRouteIdentifier.size() > 0) {
            return this.primitiveRouteIdentifier.get(0);
        }
        throw new CoreException("Illegal State : Empty route");
    }

    public List<AtlasPrimitiveEdgeIdentifier> subRoute(int fromIndex, int toIndex) {
        return this.primitiveRouteIdentifier.subList(fromIndex, toIndex);
    }

    public String toString() {
        return "AtlasPrimitiveRouteIdentifier [identifier=" + this.primitiveRouteIdentifier + "]";
    }
}

