/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public class RelationBean
extends AbstractCollection<RelationBeanItem>
implements Serializable {
    private static final long serialVersionUID = 8511830231633569713L;
    private List<RelationBeanItem> beanItems = new ArrayList<RelationBeanItem>();
    private final Set<RelationBeanItem> explicitlyExcluded = new HashSet<RelationBeanItem>();

    public static RelationBean fromSet(Set<RelationBeanItem> set) {
        RelationBean bean = new RelationBean();
        for (RelationBeanItem item : set) {
            bean.addItem(item);
        }
        return bean;
    }

    public static RelationBean mergeBeans(RelationBean left, RelationBean right) {
        RelationBean result = new RelationBean();
        for (RelationBeanItem leftItem : left) {
            if (right.isExplicitlyExcluded(leftItem)) continue;
            result.addItem(leftItem);
        }
        for (RelationBeanItem rightItem : right) {
            Optional<RelationBeanItem> existingLeftItem = left.getItemFor(rightItem.getIdentifier(), rightItem.getType());
            if (existingLeftItem.isPresent() && existingLeftItem.get().getRole().equals(rightItem.getRole()) || left.isExplicitlyExcluded(rightItem)) continue;
            result.addItem(rightItem);
        }
        left.explicitlyExcluded.forEach(result::addItemExplicitlyExcluded);
        right.explicitlyExcluded.forEach(result::addItemExplicitlyExcluded);
        return result;
    }

    @Override
    public boolean add(RelationBeanItem item) {
        this.addItem(item);
        return true;
    }

    public void addItem(Long identifier, String role, ItemType itemType) {
        this.beanItems.add(new RelationBeanItem(identifier, role, itemType));
    }

    public void addItem(RelationBeanItem item) {
        this.addItem(item.getIdentifier(), item.getRole(), item.getType());
    }

    public void addItemExplicitlyExcluded(Long identifier, String role, ItemType itemType) {
        this.addItemExplicitlyExcluded(new RelationBeanItem(identifier, role, itemType));
    }

    public void addItemExplicitlyExcluded(RelationBeanItem item) {
        this.explicitlyExcluded.add(item);
    }

    public List<RelationBeanItem> asList() {
        return new ArrayList<RelationBeanItem>(this.beanItems);
    }

    public Map<RelationBeanItem, Integer> asMap() {
        HashMap<RelationBeanItem, Integer> result = new HashMap<RelationBeanItem, Integer>();
        for (RelationBeanItem beanItem : this) {
            if (result.containsKey(beanItem)) {
                int count = (Integer)result.get(beanItem);
                result.put(beanItem, ++count);
                continue;
            }
            result.put(beanItem, 1);
        }
        return result;
    }

    public Set<RelationBeanItem> asSet() {
        return new HashSet<RelationBeanItem>(this.asMap().keySet());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RelationBean) {
            RelationBean that = (RelationBean)other;
            return this.asMap().equals(that.asMap());
        }
        return false;
    }

    public boolean equalsIncludingExplicitlyExcluded(Object other) {
        if (other instanceof RelationBean) {
            return other instanceof RelationBean && this.equals(other) && this.explicitlyExcluded.equals(((RelationBean)other).explicitlyExcluded);
        }
        return false;
    }

    public Set<RelationBeanItem> getExplicitlyExcluded() {
        return this.explicitlyExcluded;
    }

    public Optional<RelationBeanItem> getItemFor(long identifier, ItemType type) {
        for (int index = 0; index < this.beanItems.size(); ++index) {
            if (this.beanItems.get(index).getIdentifier() != identifier || this.beanItems.get(index).getType() != type) continue;
            return Optional.of(this.getItemFor(index));
        }
        return Optional.empty();
    }

    public Optional<RelationBeanItem> getItemFor(long identifier, String role, ItemType type) {
        for (int index = 0; index < this.beanItems.size(); ++index) {
            if (this.beanItems.get(index).getIdentifier() != identifier || !role.equals(this.beanItems.get(index).getRole()) || this.beanItems.get(index).getType() != type) continue;
            return Optional.of(this.getItemFor(index));
        }
        return Optional.empty();
    }

    public List<Long> getMemberIdentifiers() {
        return this.beanItems.stream().map(RelationBeanItem::getIdentifier).collect(Collectors.toList());
    }

    public List<String> getMemberRoles() {
        return this.beanItems.stream().map(RelationBeanItem::getRole).collect(Collectors.toList());
    }

    public List<ItemType> getMemberTypes() {
        return this.beanItems.stream().map(RelationBeanItem::getType).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getMemberIdentifiers(), this.getMemberRoles(), this.getMemberTypes());
    }

    @Override
    public boolean isEmpty() {
        return this.beanItems.isEmpty();
    }

    @Override
    public Iterator<RelationBeanItem> iterator() {
        return this.beanItems.iterator();
    }

    public RelationBean merge(RelationBean other) {
        return RelationBean.mergeBeans(this, other);
    }

    public List<String> removeAllMatchingItems(Long identifier, ItemType itemType) {
        ArrayList<RelationBeanItem> newBeanItems = new ArrayList<RelationBeanItem>();
        ArrayList<String> removedRoles = new ArrayList<String>();
        for (RelationBeanItem item : this.beanItems) {
            if (item.getIdentifier().equals(identifier) && item.getType().equals((Object)itemType)) {
                removedRoles.add(item.getRole());
                continue;
            }
            newBeanItems.add(new RelationBeanItem(item.getIdentifier(), item.getRole(), item.getType()));
        }
        if (!removedRoles.isEmpty()) {
            this.beanItems = newBeanItems;
        }
        return removedRoles;
    }

    public boolean removeItem(Long identifier, String role, ItemType itemType) {
        return this.removeItem(new RelationBeanItem(identifier, role, itemType));
    }

    public boolean removeItem(RelationBeanItem item) {
        return this.beanItems.remove(item);
    }

    @Override
    public int size() {
        return this.beanItems.size();
    }

    @Override
    public String toString() {
        return "RelationBean [" + this.beanItems + "]";
    }

    private RelationBeanItem getItemFor(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("Invalid index {}", index);
        }
        return new RelationBeanItem(this.beanItems.get(index));
    }

    private boolean isExplicitlyExcluded(RelationBeanItem relationBeanItem) {
        return this.explicitlyExcluded.contains(relationBeanItem);
    }

    public static class RelationBeanItem
    implements Serializable {
        private static final long serialVersionUID = 441160361936498695L;
        private final Long identifier;
        private final String role;
        private final ItemType type;

        public RelationBeanItem(Long identifier, String role, ItemType type) {
            this.identifier = identifier;
            this.role = role;
            this.type = type;
        }

        public RelationBeanItem(RelationBeanItem item) {
            this.identifier = item.identifier;
            this.role = item.role;
            this.type = item.type;
        }

        public boolean equals(Object other) {
            if (other instanceof RelationBeanItem) {
                RelationBeanItem that = (RelationBeanItem)other;
                return this.getIdentifier().equals(that.getIdentifier()) && this.getRole().equals(that.getRole()) && this.getType() == that.getType();
            }
            return false;
        }

        public Long getIdentifier() {
            return this.identifier;
        }

        public String getRole() {
            return this.role;
        }

        public ItemType getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.identifier, this.role, this.type});
        }

        public String toString() {
            return "[" + this.type + ", " + this.identifier + ", " + this.role + "]";
        }
    }
}

