/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.geojson.GeoJsonProperties;

public class AtlasSize
implements Serializable,
GeoJsonProperties {
    private static final long serialVersionUID = -4365680097735345765L;
    private static final long DEFAULT_ESTIMATE = 1024L;
    public static final AtlasSize DEFAULT = new AtlasSize(1024L, 1024L, 1024L, 1024L, 1024L, 1024L);
    private final long edgeNumber;
    private final long nodeNumber;
    private final long areaNumber;
    private final long lineNumber;
    private final long pointNumber;
    private final long relationNumber;

    public AtlasSize(Iterable<AtlasEntity> entities) {
        long nodeNumber = 0L;
        long edgeNumber = 0L;
        long areaNumber = 0L;
        long lineNumber = 0L;
        long pointNumber = 0L;
        long relationNumber = 0L;
        block8: for (AtlasEntity entity : entities) {
            ItemType type = entity.getType();
            switch (type) {
                case NODE: {
                    ++nodeNumber;
                    continue block8;
                }
                case EDGE: {
                    ++edgeNumber;
                    continue block8;
                }
                case AREA: {
                    ++areaNumber;
                    continue block8;
                }
                case LINE: {
                    ++lineNumber;
                    continue block8;
                }
                case POINT: {
                    ++pointNumber;
                    continue block8;
                }
                case RELATION: {
                    ++relationNumber;
                    continue block8;
                }
            }
            throw new CoreException("Invalid Item Type {}", new Object[]{type});
        }
        this.edgeNumber = edgeNumber;
        this.nodeNumber = nodeNumber;
        this.areaNumber = areaNumber;
        this.lineNumber = lineNumber;
        this.pointNumber = pointNumber;
        this.relationNumber = relationNumber;
    }

    public AtlasSize(long edgeNumber, long nodeNumber, long areaNumber, long lineNumber, long pointNumber, long relationNumber) {
        this.edgeNumber = edgeNumber;
        this.nodeNumber = nodeNumber;
        this.areaNumber = areaNumber;
        this.lineNumber = lineNumber;
        this.pointNumber = pointNumber;
        this.relationNumber = relationNumber;
    }

    public boolean equals(Object other) {
        if (other instanceof AtlasSize) {
            if (this == other) {
                return true;
            }
            AtlasSize that = (AtlasSize)other;
            if (this.getEdgeNumber() != that.getEdgeNumber()) {
                return false;
            }
            if (this.getNodeNumber() != that.getNodeNumber()) {
                return false;
            }
            if (this.getAreaNumber() != that.getAreaNumber()) {
                return false;
            }
            if (this.getLineNumber() != that.getLineNumber()) {
                return false;
            }
            if (this.getPointNumber() != that.getPointNumber()) {
                return false;
            }
            return this.getRelationNumber() == that.getRelationNumber();
        }
        return false;
    }

    public long getAreaNumber() {
        return this.areaNumber;
    }

    public long getEdgeNumber() {
        return this.edgeNumber;
    }

    public long getEntityNumber() {
        return this.nodeNumber + this.edgeNumber + this.pointNumber + this.lineNumber + this.areaNumber + this.relationNumber;
    }

    @Override
    public JsonObject getGeoJsonProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("Number of Edges", this.getEdgeNumber());
        properties.addProperty("Number of Nodes", this.getNodeNumber());
        properties.addProperty("Number of Areas", this.getAreaNumber());
        properties.addProperty("Number of Lines", this.getLineNumber());
        properties.addProperty("Number of Points", this.getPointNumber());
        properties.addProperty("Number of Relations", this.getRelationNumber());
        return properties;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public long getNodeNumber() {
        return this.nodeNumber;
    }

    public long getNonRelationEntityNumber() {
        return this.nodeNumber + this.edgeNumber + this.pointNumber + this.lineNumber + this.areaNumber;
    }

    public long getPointNumber() {
        return this.pointNumber;
    }

    public long getRelationNumber() {
        return this.relationNumber;
    }

    public int hashCode() {
        return Objects.hash(this.edgeNumber, this.nodeNumber, this.areaNumber, this.lineNumber, this.pointNumber, this.relationNumber);
    }

    public String toString() {
        return "[AtlasSize: edgeNumber=" + this.edgeNumber + ", nodeNumber=" + this.nodeNumber + ", areaNumber=" + this.areaNumber + ", lineNumber=" + this.lineNumber + ", pointNumber=" + this.pointNumber + ", relationNumber=" + this.relationNumber + "]";
    }

    public static class AtlasSizeBuilder {
        private long edgeEstimate = 1024L;
        private long nodeEstimate = 1024L;
        private long areaEstimate = 1024L;
        private long lineEstimate = 1024L;
        private long pointEstimate = 1024L;
        private long relationEstimate = 1024L;

        public AtlasSize build() {
            return new AtlasSize(this.edgeEstimate, this.nodeEstimate, this.areaEstimate, this.lineEstimate, this.pointEstimate, this.relationEstimate);
        }

        public AtlasSizeBuilder withAreaEstimate(long areaNumber) {
            this.areaEstimate = areaNumber;
            return this;
        }

        public AtlasSizeBuilder withEdgeEstimate(long edgeNumber) {
            this.edgeEstimate = edgeNumber;
            return this;
        }

        public AtlasSizeBuilder withLineEstimate(long lineNumber) {
            this.lineEstimate = lineNumber;
            return this;
        }

        public AtlasSizeBuilder withNodeEstimate(long nodeNumber) {
            this.nodeEstimate = nodeNumber;
            return this;
        }

        public AtlasSizeBuilder withPointEstimate(long pointNumber) {
            this.pointEstimate = pointNumber;
            return this;
        }

        public AtlasSizeBuilder withRelationEstimate(long relationNumber) {
            this.relationEstimate = relationNumber;
            return this;
        }
    }
}

