/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasLoadingCommand;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;

public abstract class Crawler
extends AtlasLoadingCommand {
    private static final Command.Switch<File> OUTPUT_FOLDER = new Command.Switch("outputFolder", "Location of the output folder", File::new, Command.Optionality.REQUIRED);
    private final Logger logger;

    public Crawler(Logger logger) {
        this.logger = logger;
    }

    protected void initialize(CommandMap command) {
    }

    @Override
    protected int onRun(CommandMap command) {
        File inputFolder = (File)command.get(INPUT_FOLDER);
        String atlasName = inputFolder.getName();
        File outputFolder = (File)command.get(OUTPUT_FOLDER);
        this.initialize(command);
        if (inputFolder != null) {
            this.logger.info("Loading Atlas from {}", (Object)inputFolder);
            Atlas atlas = this.loadAtlas(command);
            this.processAtlas(atlasName, atlas, outputFolder.getPath());
        }
        return 0;
    }

    protected abstract void processAtlas(String var1, Atlas var2, String var3);

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(OUTPUT_FOLDER);
    }
}

