/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.text.TextAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.items.SnappedEdge;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.atlas.sub.SubAtlasCreator;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeature;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeatureCollection;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.proto.builder.ProtoAtlasBuilder;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public abstract class BareAtlas
implements Atlas {
    public static final int MAXIMUM_RELATION_DEPTH = 500;
    private static final long serialVersionUID = 4733707438968864018L;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private transient String name;
    private final UUID identifier = UUID.randomUUID();

    protected BareAtlas() {
    }

    @Override
    public Iterable<Area> areas(Predicate<Area> matcher) {
        return Iterables.filter(this.areas(), matcher);
    }

    @Override
    public JsonObject asGeoJson() {
        return GeoJsonUtils.featureCollection(this);
    }

    @Override
    public JsonObject asGeoJson(final Predicate<AtlasEntity> matcher) {
        return GeoJsonUtils.featureCollection((GeoJsonFeatureCollection<? extends GeoJsonFeature>)new GeoJsonFeatureCollection<AtlasEntity>(){

            @Override
            public Iterable<AtlasEntity> getGeoJsonObjects() {
                return BareAtlas.this.entities(matcher);
            }

            @Override
            public JsonObject getGeoJsonProperties() {
                JsonObject properties = BareAtlas.this.getGeoJsonProperties();
                properties.addProperty("Entity filter used", true);
                return properties;
            }
        });
    }

    @Override
    public Iterable<Edge> edges(Predicate<Edge> matcher) {
        return Iterables.filter(this.edges(), matcher);
    }

    @Override
    public Iterable<AtlasEntity> entities() {
        return new MultiIterable<AtlasEntity>(this.items(), this.relations());
    }

    @Override
    public <M extends AtlasEntity> Iterable<M> entities(ItemType type, Class<M> memberClass) {
        if (type.getMemberClass() != memberClass) {
            throw new CoreException("ItemType {} and class {} do not match!", new Object[]{type, memberClass.getSimpleName()});
        }
        switch (type) {
            case NODE: {
                return this.nodes();
            }
            case EDGE: {
                return this.edges();
            }
            case AREA: {
                return this.areas();
            }
            case LINE: {
                return this.lines();
            }
            case POINT: {
                return this.points();
            }
            case RELATION: {
                return this.relations();
            }
        }
        throw new CoreException("ItemType {} unknown.", new Object[]{type});
    }

    @Override
    public Iterable<AtlasEntity> entities(Predicate<AtlasEntity> matcher) {
        return Iterables.filter(this, matcher);
    }

    @Override
    public Iterable<AtlasEntity> entitiesIntersecting(GeometricSurface surface) {
        return new MultiIterable<AtlasEntity>(this.itemsIntersecting(surface), this.relationsWithEntitiesIntersecting(surface));
    }

    @Override
    public Iterable<AtlasEntity> entitiesIntersecting(GeometricSurface surface, Predicate<AtlasEntity> matcher) {
        return Iterables.filter(this.entitiesIntersecting(surface), matcher);
    }

    @Override
    public AtlasEntity entity(long identifier, ItemType type) {
        switch (type) {
            case NODE: {
                return this.node(identifier);
            }
            case EDGE: {
                return this.edge(identifier);
            }
            case AREA: {
                return this.area(identifier);
            }
            case LINE: {
                return this.line(identifier);
            }
            case POINT: {
                return this.point(identifier);
            }
            case RELATION: {
                return this.relation(identifier);
            }
        }
        throw new CoreException("Unknown type {}", new Object[]{type});
    }

    public boolean equals(Object other) {
        if (other instanceof Atlas) {
            if (this == other) {
                return true;
            }
            Atlas that = (Atlas)other;
            for (AtlasEntity thisEntity : this) {
                AtlasEntity thatEntity = that.entity(thisEntity.getIdentifier(), thisEntity.getType());
                if (thatEntity == null || !thisEntity.getTags().equals(thatEntity.getTags())) {
                    return false;
                }
                if (thisEntity instanceof Area) {
                    Polygon thatPolygon;
                    Polygon thisPolygon = ((Area)thisEntity).asPolygon();
                    if (thisPolygon.equals(thatPolygon = ((Area)thatEntity).asPolygon())) continue;
                    return false;
                }
                if (thisEntity instanceof LineItem) {
                    PolyLine thatPolyLine;
                    PolyLine thisPolyLine = ((LineItem)thisEntity).asPolyLine();
                    if (thisPolyLine.equals(thatPolyLine = ((LineItem)thatEntity).asPolyLine())) continue;
                    return false;
                }
                if (thisEntity instanceof LocationItem) {
                    Location thatLocation;
                    Location thisLocation = ((LocationItem)thisEntity).getLocation();
                    if (thisLocation.equals(thatLocation = ((LocationItem)thatEntity).getLocation())) continue;
                    return false;
                }
                if (thisEntity instanceof Relation) {
                    RelationMemberList thatMembers;
                    RelationMemberList thisMembers = ((Relation)thisEntity).members();
                    if (thisMembers.equals(thatMembers = ((Relation)thatEntity).members())) continue;
                    return false;
                }
                throw new CoreException("Unknown type: {}", thisEntity.getClass().getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<AtlasEntity> getGeoJsonObjects() {
        return this.entities();
    }

    @Override
    public JsonObject getGeoJsonProperties() {
        JsonObject properties = this.metaData().getGeoJsonProperties();
        properties.addProperty("name", this.getName());
        return properties;
    }

    @Override
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return String.valueOf(this.getIdentifier());
        }
        return this.name;
    }

    public int hashCode() {
        return Long.hashCode(this.numberOfNodes() + this.numberOfEdges() + this.numberOfAreas() + this.numberOfLines() + this.numberOfPoints() + this.numberOfRelations());
    }

    @Override
    public Iterable<AtlasItem> items() {
        return new MultiIterable<AtlasItem>(this.nodes(), this.edges(), this.areas(), this.lines(), this.points());
    }

    @Override
    public Iterable<AtlasItem> items(Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.items(), matcher);
    }

    @Override
    public Iterable<AtlasItem> itemsContaining(Location location) {
        return new MultiIterable<AtlasItem>(this.edgesContaining(location), this.nodesAt(location), this.areasCovering(location), this.linesContaining(location), this.pointsAt(location));
    }

    @Override
    public Iterable<AtlasItem> itemsContaining(Location location, Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.itemsContaining(location), matcher);
    }

    @Override
    public Iterable<AtlasItem> itemsIntersecting(GeometricSurface surface) {
        return new MultiIterable<AtlasItem>(this.edgesIntersecting(surface), this.nodesWithin(surface), this.areasIntersecting(surface), this.linesIntersecting(surface), this.pointsWithin(surface));
    }

    @Override
    public Iterable<AtlasItem> itemsIntersecting(GeometricSurface surface, Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.itemsIntersecting(surface), matcher);
    }

    @Override
    public Iterable<AtlasItem> itemsWithin(GeometricSurface surface) {
        return new MultiIterable<AtlasItem>(this.locationItemsWithin(surface), this.lineItemsWithin(surface), this.areasWithin(surface));
    }

    @Override
    public Iterator<AtlasEntity> iterator() {
        return new MultiIterable(this.nodes(), this.edges(), this.areas(), this.lines(), this.points(), this.relations()).iterator();
    }

    @Override
    public Iterable<LineItem> lineItems() {
        return new MultiIterable<LineItem>(this.edges(), this.lines());
    }

    @Override
    public Iterable<LineItem> lineItems(Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItems(), matcher);
    }

    @Override
    public Iterable<LineItem> lineItemsContaining(Location location) {
        return new MultiIterable<LineItem>(this.edgesContaining(location), this.linesContaining(location));
    }

    @Override
    public Iterable<LineItem> lineItemsContaining(Location location, Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItemsContaining(location), matcher);
    }

    @Override
    public Iterable<LineItem> lineItemsIntersecting(GeometricSurface surface) {
        return new MultiIterable<LineItem>(this.edgesIntersecting(surface), this.linesIntersecting(surface));
    }

    @Override
    public Iterable<LineItem> lineItemsIntersecting(GeometricSurface surface, Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItemsIntersecting(surface), matcher);
    }

    @Override
    public Iterable<LineItem> lineItemsWithin(GeometricSurface surface) {
        return new MultiIterable<LineItem>(this.edgesWithin(surface), this.linesWithin(surface));
    }

    @Override
    public Iterable<Line> lines(Predicate<Line> matcher) {
        return Iterables.filter(this.lines(), matcher);
    }

    @Override
    public Iterable<LocationItem> locationItems() {
        return new MultiIterable<LocationItem>(this.nodes(), this.points());
    }

    @Override
    public Iterable<LocationItem> locationItems(Predicate<LocationItem> matcher) {
        return Iterables.filter(this.locationItems(), matcher);
    }

    @Override
    public Iterable<LocationItem> locationItemsWithin(GeometricSurface surface) {
        return new MultiIterable<LocationItem>(this.nodesWithin(surface), this.pointsWithin(surface));
    }

    @Override
    public Iterable<LocationItem> locationItemsWithin(GeometricSurface surface, Predicate<LocationItem> matcher) {
        return Iterables.filter(this.locationItemsWithin(surface), matcher);
    }

    @Override
    public Iterable<Node> nodes(Predicate<Node> matcher) {
        return Iterables.filter(this.nodes(), matcher);
    }

    @Override
    public Iterable<Point> points(Predicate<Point> matcher) {
        return Iterables.filter(this.points(), matcher);
    }

    @Override
    public Iterable<Relation> relations(Predicate<Relation> matcher) {
        return Iterables.filter(this.relations(), matcher);
    }

    @Override
    public Iterable<Relation> relationsLowerOrderFirst() {
        ArrayList<Relation> stagedRelations = new ArrayList<Relation>();
        LinkedHashSet<Relation> result = new LinkedHashSet<Relation>();
        for (Relation relation : this.relations()) {
            boolean stageable = false;
            RelationMemberList members = relation.members();
            for (RelationMember member : members) {
                if (!(member.getEntity() instanceof Relation)) continue;
                stageable = true;
            }
            if (stageable) {
                stagedRelations.add(relation);
                continue;
            }
            result.add(relation);
        }
        for (int depth = 0; !stagedRelations.isEmpty() && depth < 500; ++depth) {
            ArrayList<Relation> newStagedRelations = new ArrayList<Relation>();
            for (Relation relation : stagedRelations) {
                boolean stageable = false;
                RelationMemberList members = relation.members();
                for (RelationMember member : members) {
                    if (!(member.getEntity() instanceof Relation) || result.contains(member.getEntity())) continue;
                    stageable = true;
                }
                if (stageable) {
                    newStagedRelations.add(relation);
                    continue;
                }
                result.add(relation);
            }
            stagedRelations = newStagedRelations;
        }
        return result;
    }

    @Override
    public void saveAsGeoJson(WritableResource resource) {
        this.saveAsGeoJson(resource, item -> true);
    }

    @Override
    public void saveAsGeoJson(WritableResource resource, Predicate<AtlasEntity> matcher) {
        try (JsonWriter writer = new JsonWriter(resource);){
            writer.write(this.asGeoJson(matcher));
        }
    }

    @Override
    public void saveAsLineDelimitedGeoJsonFeatures(WritableResource resource, BiConsumer<AtlasEntity, JsonObject> jsonMutator) {
        this.saveAsLineDelimitedGeoJsonFeatures(resource, item -> true, jsonMutator);
    }

    @Override
    public void saveAsLineDelimitedGeoJsonFeatures(WritableResource resource, Predicate<AtlasEntity> matcher, BiConsumer<AtlasEntity, JsonObject> jsonMutator) {
        try (JsonWriter writer = new JsonWriter(resource);){
            this.entities(matcher).forEach(entity -> {
                JsonObject feature = entity.asGeoJson();
                jsonMutator.accept((AtlasEntity)entity, feature);
                writer.writeLine(feature);
            });
        }
    }

    @Override
    public void saveAsList(WritableResource resource) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(resource.write(), StandardCharsets.UTF_8));
        try {
            writer.write(this.toString());
            Streams.close(writer);
        }
        catch (IOException e) {
            Streams.close(writer);
            throw new CoreException("Could not save atlas as list", e);
        }
    }

    @Override
    public void saveAsProto(WritableResource resource) {
        new ProtoAtlasBuilder().write(this, resource);
    }

    @Override
    public void saveAsText(WritableResource resource) {
        new TextAtlasBuilder().write(this, resource);
    }

    @Override
    public SnappedEdge snapped(Location point, Distance threshold) {
        SnappedEdge result = null;
        for (Edge edge : this.edgesIntersecting(point.boxAround(threshold))) {
            SnappedEdge candidate = new SnappedEdge(point.snapTo(edge.asPolyLine()), edge);
            if (result != null && !candidate.getDistance().isLessThan(result.getDistance())) continue;
            result = candidate;
        }
        return result;
    }

    @Override
    public SortedSet<SnappedEdge> snaps(Location point, Distance threshold) {
        TreeSet<SnappedEdge> snaps = new TreeSet<SnappedEdge>();
        for (Edge edge : this.edgesIntersecting(point.boxAround(threshold))) {
            SnappedEdge candidate = new SnappedEdge(point.snapTo(edge.asPolyLine()), edge);
            snaps.add(candidate);
        }
        return snaps;
    }

    @Override
    public Optional<Atlas> subAtlas(GeometricSurface boundary, AtlasCutType cutType) {
        switch (cutType) {
            case SILK_CUT: {
                return SubAtlasCreator.silkCut((Atlas)this, boundary);
            }
            case SOFT_CUT: {
                return SubAtlasCreator.softCut(this, boundary, false);
            }
            case HARD_CUT_ALL: {
                return SubAtlasCreator.hardCutAllEntities((Atlas)this, boundary);
            }
            case HARD_CUT_RELATIONS_ONLY: {
                return SubAtlasCreator.softCut(this, boundary, true);
            }
        }
        throw new CoreException("Unsupported Atlas cut type: {}", new Object[]{cutType});
    }

    @Override
    public Optional<Atlas> subAtlas(Predicate<AtlasEntity> matcher, AtlasCutType cutType) {
        switch (cutType) {
            case SILK_CUT: {
                return SubAtlasCreator.silkCut((Atlas)this, matcher);
            }
            case SOFT_CUT: {
                return SubAtlasCreator.softCut(this, matcher);
            }
            case HARD_CUT_ALL: {
                return SubAtlasCreator.hardCutAllEntities((Atlas)this, matcher);
            }
            case HARD_CUT_RELATIONS_ONLY: {
                return SubAtlasCreator.hardCutRelationsOnly(this, matcher);
            }
        }
        throw new CoreException("Unsupported Atlas cut type: {}", new Object[]{cutType});
    }

    @Override
    public String summary() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(": Nodes = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfNodes()));
        builder.append(", Edges = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfEdges()));
        builder.append(", Areas = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfAreas()));
        builder.append(", Lines = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfLines()));
        builder.append(", Points = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfPoints()));
        builder.append(", Relations = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfRelations()));
        builder.append("]");
        return builder.toString();
    }

    public String toString() {
        return this.summary();
    }

    @Override
    public String toStringDetailed() {
        String newLineAfterFeature = ",\n\t\t";
        StringBuilder builder = new StringBuilder();
        builder.append("[Atlas <");
        builder.append(this.getName());
        builder.append(">: ");
        StringList list = new StringList();
        list.add(Iterables.toString(this.nodes(), "Nodes", ",\n\t\t"));
        list.add(Iterables.toString(this.edges(), "Edges", ",\n\t\t"));
        list.add(Iterables.toString(this.areas(), "Areas", ",\n\t\t"));
        list.add(Iterables.toString(this.lines(), "Lines", ",\n\t\t"));
        list.add(Iterables.toString(this.points(), "Points", ",\n\t\t"));
        list.add(Iterables.toString(this.relations(), "Relations", ",\n\t\t"));
        builder.append(list.join(",\n\t"));
        builder.append("]");
        return builder.toString();
    }

    protected void setName(String name) {
        this.name = name;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(true);
    }
}

