/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.geojson.GeoJsonProperties;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoAtlasMetaDataAdapter;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;

public final class AtlasMetaData
implements Serializable,
Taggable,
ProtoSerializable,
GeoJsonProperties {
    private static final long serialVersionUID = -285346019736489425L;
    public static final String EDGE_CONFIGURATION = "edgeConfiguration";
    public static final String AREA_CONFIGURATION = "areaConfiguration";
    public static final String WAY_SECTIONING_CONFIGURATION = "waySectioningConfiguration";
    public static final String OSM_PBF_WAY_CONFIGURATION = "osmPbfWayConfiguration";
    public static final String OSM_PBF_NODE_CONFIGURATION = "osmPbfNodeConfiguration";
    public static final String OSM_PBF_RELATION_CONFIGURATION = "osmPbfRelationConfiguration";
    private static final String UNKNOWN_VALUE = "unknown";
    private final AtlasSize size;
    private final boolean original;
    private final String codeVersion;
    private final String dataVersion;
    private final String country;
    private final String shardName;
    private final Map<String, String> tags;

    public AtlasMetaData() {
        this(AtlasSize.DEFAULT);
    }

    public AtlasMetaData(AtlasSize size) {
        this(size, true, UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE, UNKNOWN_VALUE, Maps.hashMap(new String[0]));
    }

    public AtlasMetaData(AtlasSize size, boolean original, String codeVersion, String dataVersion, String country, String shardName, Map<String, String> tags) {
        this.size = size;
        this.original = original;
        this.codeVersion = codeVersion;
        this.dataVersion = dataVersion;
        this.country = country;
        this.shardName = shardName;
        this.tags = tags;
    }

    public AtlasMetaData copyWithNewOriginal(boolean original) {
        return new AtlasMetaData(this.size, original, this.codeVersion, this.dataVersion, this.country, this.shardName, this.tags);
    }

    public AtlasMetaData copyWithNewShardName(String shardName) {
        return new AtlasMetaData(this.size, this.original, this.codeVersion, this.dataVersion, this.country, shardName, this.tags);
    }

    public AtlasMetaData copyWithNewSize(AtlasSize size) {
        return new AtlasMetaData(size, this.original, this.codeVersion, this.dataVersion, this.country, this.shardName, this.tags);
    }

    public boolean equals(Object other) {
        if (other instanceof AtlasMetaData) {
            if (this == other) {
                return true;
            }
            AtlasMetaData that = (AtlasMetaData)other;
            if (!Objects.equals(this.getSize(), that.getSize())) {
                return false;
            }
            if (this.isOriginal() != that.isOriginal()) {
                return false;
            }
            if (!Objects.equals(this.getCodeVersion(), that.getCodeVersion())) {
                return false;
            }
            if (!Objects.equals(this.getDataVersion(), that.getDataVersion())) {
                return false;
            }
            if (!Objects.equals(this.getCountry(), that.getCountry())) {
                return false;
            }
            if (!Objects.equals(this.getShardName(), that.getShardName())) {
                return false;
            }
            return Objects.equals(this.getTags(), that.getTags());
        }
        return false;
    }

    public Optional<String> getCodeVersion() {
        return Optional.ofNullable(this.codeVersion);
    }

    public Optional<String> getCountry() {
        return Optional.ofNullable(this.country);
    }

    public Optional<String> getDataVersion() {
        return Optional.ofNullable(this.dataVersion);
    }

    @Override
    public JsonObject getGeoJsonProperties() {
        JsonObject properties = new JsonObject();
        properties.add("size", this.getSize().getGeoJsonProperties());
        properties.addProperty("original", this.isOriginal());
        this.getCodeVersion().ifPresent(versionString -> properties.addProperty("Code Version", (String)versionString));
        this.getDataVersion().ifPresent(versionString -> properties.addProperty("Data Version", (String)versionString));
        this.getCountry().ifPresent(countryString -> properties.addProperty("Country", (String)countryString));
        this.getShardName().ifPresent(theShardName -> properties.addProperty("Shard Name", (String)theShardName));
        this.getTags().forEach((key, value) -> {
            if (!properties.has((String)key)) {
                properties.addProperty((String)key, (String)value);
            }
        });
        return properties;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoAtlasMetaDataAdapter();
    }

    public Optional<String> getShardName() {
        return Optional.ofNullable(this.shardName);
    }

    public AtlasSize getSize() {
        return this.size;
    }

    @Override
    public Optional<String> getTag(String key) {
        return Optional.ofNullable(this.tags.get(key));
    }

    @Override
    public Map<String, String> getTags() {
        if (this.tags == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.tags);
    }

    public int hashCode() {
        int sizeHash = this.getSize().hashCode();
        return Objects.hash(sizeHash, this.original, this.codeVersion, this.dataVersion, this.country, this.shardName, this.tags);
    }

    public boolean isOriginal() {
        return this.original;
    }

    public String toReadableString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Size: ");
        builder.append("\n\tNodes: ");
        builder.append(this.size.getNodeNumber());
        builder.append("\n\tEdges: ");
        builder.append(this.size.getEdgeNumber());
        builder.append("\n\tAreas: ");
        builder.append(this.size.getAreaNumber());
        builder.append("\n\tLines: ");
        builder.append(this.size.getLineNumber());
        builder.append("\n\tPoints: ");
        builder.append(this.size.getPointNumber());
        builder.append("\n\tRelations: ");
        builder.append(this.size.getRelationNumber());
        builder.append("\n");
        builder.append("Original: ");
        builder.append(this.original);
        builder.append("\n");
        builder.append("Code Version: ");
        builder.append(this.codeVersion);
        builder.append("\n");
        builder.append("Data Version: ");
        builder.append(this.dataVersion);
        builder.append("\n");
        builder.append("Country: ");
        builder.append(this.country);
        builder.append("\n");
        builder.append("Shard: ");
        builder.append(this.shardName);
        builder.append("\n");
        builder.append("Tags: ");
        this.tags.forEach((key, value) -> {
            builder.append("\n\t");
            builder.append((String)key);
            builder.append(" -> ");
            builder.append((String)value);
        });
        builder.append("\n");
        return builder.toString();
    }

    public String toString() {
        return "[AtlasMetaData: size=" + this.size + ", original=" + this.original + ", codeVersion=" + this.codeVersion + ", dataVersion=" + this.dataVersion + ", country=" + this.country + ", shardName=" + this.shardName + ", tags=" + this.tags + "]";
    }
}

