/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.SnappedEdge;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeatureCollection;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public interface Atlas
extends Located,
Iterable<AtlasEntity>,
Serializable,
GeoJsonFeatureCollection<AtlasEntity> {
    public static <E extends AtlasEntity> Iterable<E> entitiesMatchingId(Long[] identifiers, LongFunction<E> function) {
        return Arrays.stream(identifiers).map(function::apply).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Area area(long var1);

    default public Iterable<Area> areas(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::area);
    }

    public Iterable<Area> areas();

    public Iterable<Area> areas(Predicate<Area> var1);

    public Iterable<Area> areasCovering(Location var1);

    public Iterable<Area> areasCovering(Location var1, Predicate<Area> var2);

    public Iterable<Area> areasIntersecting(GeometricSurface var1);

    public Iterable<Area> areasIntersecting(GeometricSurface var1, Predicate<Area> var2);

    public Iterable<Area> areasWithin(GeometricSurface var1);

    public JsonObject asGeoJson(Predicate<AtlasEntity> var1);

    default public PackedAtlas cloneToPackedAtlas() {
        return new PackedAtlasCloner().cloneFrom(this);
    }

    public Edge edge(long var1);

    default public Iterable<Edge> edges(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::edge);
    }

    public Iterable<Edge> edges();

    public Iterable<Edge> edges(Predicate<Edge> var1);

    public Iterable<Edge> edgesContaining(Location var1);

    public Iterable<Edge> edgesContaining(Location var1, Predicate<Edge> var2);

    public Iterable<Edge> edgesIntersecting(GeometricSurface var1);

    public Iterable<Edge> edgesIntersecting(GeometricSurface var1, Predicate<Edge> var2);

    public Iterable<Edge> edgesWithin(GeometricSurface var1);

    public Iterable<AtlasEntity> entities();

    public <M extends AtlasEntity> Iterable<M> entities(ItemType var1, Class<M> var2);

    public Iterable<AtlasEntity> entities(Predicate<AtlasEntity> var1);

    public Iterable<AtlasEntity> entitiesIntersecting(GeometricSurface var1);

    public Iterable<AtlasEntity> entitiesIntersecting(GeometricSurface var1, Predicate<AtlasEntity> var2);

    public AtlasEntity entity(long var1, ItemType var3);

    public UUID getIdentifier();

    public String getName();

    public Iterable<AtlasItem> items();

    public Iterable<AtlasItem> items(Predicate<AtlasItem> var1);

    public Iterable<AtlasItem> itemsContaining(Location var1);

    public Iterable<AtlasItem> itemsContaining(Location var1, Predicate<AtlasItem> var2);

    public Iterable<AtlasItem> itemsIntersecting(GeometricSurface var1);

    public Iterable<AtlasItem> itemsIntersecting(GeometricSurface var1, Predicate<AtlasItem> var2);

    public Iterable<AtlasItem> itemsWithin(GeometricSurface var1);

    public Line line(long var1);

    public Iterable<LineItem> lineItems();

    public Iterable<LineItem> lineItems(Predicate<LineItem> var1);

    public Iterable<LineItem> lineItemsContaining(Location var1);

    public Iterable<LineItem> lineItemsContaining(Location var1, Predicate<LineItem> var2);

    public Iterable<LineItem> lineItemsIntersecting(GeometricSurface var1);

    public Iterable<LineItem> lineItemsIntersecting(GeometricSurface var1, Predicate<LineItem> var2);

    public Iterable<LineItem> lineItemsWithin(GeometricSurface var1);

    default public Iterable<Line> lines(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::line);
    }

    public Iterable<Line> lines();

    public Iterable<Line> lines(Predicate<Line> var1);

    public Iterable<Line> linesContaining(Location var1);

    public Iterable<Line> linesContaining(Location var1, Predicate<Line> var2);

    public Iterable<Line> linesIntersecting(GeometricSurface var1);

    public Iterable<Line> linesIntersecting(GeometricSurface var1, Predicate<Line> var2);

    public Iterable<Line> linesWithin(GeometricSurface var1);

    public Iterable<LocationItem> locationItems();

    public Iterable<LocationItem> locationItems(Predicate<LocationItem> var1);

    public Iterable<LocationItem> locationItemsWithin(GeometricSurface var1);

    public Iterable<LocationItem> locationItemsWithin(GeometricSurface var1, Predicate<LocationItem> var2);

    public AtlasMetaData metaData();

    public Node node(long var1);

    default public Iterable<Node> nodes(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::node);
    }

    public Iterable<Node> nodes();

    public Iterable<Node> nodes(Predicate<Node> var1);

    public Iterable<Node> nodesAt(Location var1);

    public Iterable<Node> nodesWithin(GeometricSurface var1);

    public Iterable<Node> nodesWithin(GeometricSurface var1, Predicate<Node> var2);

    public long numberOfAreas();

    public long numberOfEdges();

    public long numberOfLines();

    public long numberOfNodes();

    public long numberOfPoints();

    public long numberOfRelations();

    public Point point(long var1);

    default public Iterable<Point> points(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::point);
    }

    public Iterable<Point> points();

    public Iterable<Point> points(Predicate<Point> var1);

    public Iterable<Point> pointsAt(Location var1);

    public Iterable<Point> pointsWithin(GeometricSurface var1);

    public Iterable<Point> pointsWithin(GeometricSurface var1, Predicate<Point> var2);

    public Relation relation(long var1);

    default public Iterable<Relation> relations(Long ... identifiers) {
        return Atlas.entitiesMatchingId(identifiers, this::relation);
    }

    public Iterable<Relation> relations();

    public Iterable<Relation> relations(Predicate<Relation> var1);

    public Iterable<Relation> relationsLowerOrderFirst();

    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface var1);

    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface var1, Predicate<Relation> var2);

    public Iterable<Relation> relationsWithEntitiesWithin(GeometricSurface var1);

    public void save(WritableResource var1);

    public void saveAsGeoJson(WritableResource var1);

    public void saveAsGeoJson(WritableResource var1, Predicate<AtlasEntity> var2);

    public void saveAsLineDelimitedGeoJsonFeatures(WritableResource var1, BiConsumer<AtlasEntity, JsonObject> var2);

    public void saveAsLineDelimitedGeoJsonFeatures(WritableResource var1, Predicate<AtlasEntity> var2, BiConsumer<AtlasEntity, JsonObject> var3);

    public void saveAsList(WritableResource var1);

    public void saveAsProto(WritableResource var1);

    public void saveAsText(WritableResource var1);

    default public AtlasSize size() {
        return new AtlasSize(this.numberOfEdges(), this.numberOfNodes(), this.numberOfAreas(), this.numberOfLines(), this.numberOfPoints(), this.numberOfRelations());
    }

    public SnappedEdge snapped(Location var1, Distance var2);

    public SortedSet<SnappedEdge> snaps(Location var1, Distance var2);

    public Optional<Atlas> subAtlas(GeometricSurface var1, AtlasCutType var2);

    public Optional<Atlas> subAtlas(Predicate<AtlasEntity> var1, AtlasCutType var2);

    public String summary();

    public String toStringDetailed();
}

