/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringCompressedPolyLine
implements Serializable {
    private static final long serialVersionUID = 5315700936842774861L;
    private static final int PRECISION = 7;
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int ENCODING_OFFSET_MINUS_ONE = 63;
    private static final int FIVE_BIT_MASK = 31;
    private static final int SIXTH_BIT_MASK = 32;
    private static final int BIT_SHIFT = 5;
    private static final long MAXIMUM_DELTA_LONGITUDE_IN_DEGREES = 180L;
    private static final long MAXIMUM_DELTA_LONGITUDE = (long)(180.0 * Math.pow(10.0, 7.0));
    private static final byte WKB_SENTINEL = 0;
    private static final Logger logger = LoggerFactory.getLogger(StringCompressedPolyLine.class);
    private byte[] encoding;

    public StringCompressedPolyLine(byte[] encoding) {
        this.encoding = encoding;
    }

    public StringCompressedPolyLine(PolyLine polyLine) {
        try {
            this.encoding = this.compress(polyLine, 7).getBytes(CHARSET);
        }
        catch (PolyLineCompressionException exception) {
            logger.warn("Unable to use string compression", (Throwable)exception);
            this.encoding = this.getWkbFallback(polyLine);
        }
        catch (Exception exception) {
            throw new CoreException("Could not compress polyline.", exception);
        }
    }

    public PolyLine asPolyLine() {
        if (this.encoding[0] == 0) {
            byte[] strippedEncoding = new byte[this.encoding.length - 1];
            System.arraycopy(this.encoding, 1, strippedEncoding, 0, strippedEncoding.length);
            return PolyLine.wkb(strippedEncoding);
        }
        String encodedString = null;
        try {
            encodedString = new String(this.encoding, CHARSET);
            return this.asPolyLine(encodedString, 7);
        }
        catch (Exception exception) {
            throw new CoreException("Could not decompress polyline:\nEncoding: '{}'\nString: ''.", this.encoding, encodedString, exception);
        }
    }

    public byte[] getEncoding() {
        return this.encoding;
    }

    public String toString() {
        if (this.encoding[0] == 0) {
            byte[] strippedEncoding = new byte[this.encoding.length - 1];
            System.arraycopy(this.encoding, 1, strippedEncoding, 0, strippedEncoding.length);
            return PolyLine.wkb(strippedEncoding).toWkt();
        }
        try {
            return new String(this.encoding, CHARSET);
        }
        catch (Exception e) {
            throw new CoreException("Could not stringify byte array.", e);
        }
    }

    private PolyLine asPolyLine(String encoded, int precision) {
        double precision2 = Math.pow(10.0, -precision);
        int length = encoded.length();
        int index = 0;
        int latitude = 0;
        int longitude = 0;
        ArrayList<Location> array = new ArrayList<Location>();
        while (index < length) {
            int byteEncoded;
            int shift = 0;
            int result = 0;
            do {
                byteEncoded = Character.codePointAt(encoded, index++) - 63;
                result |= (byteEncoded & 0x1F) << shift;
                shift += 5;
            } while (byteEncoded >= 32);
            int deltaLatitude = (result & 1) > 0 ? ~(result >>> 1) : result >>> 1;
            latitude += deltaLatitude;
            shift = 0;
            result = 0;
            do {
                byteEncoded = Character.codePointAt(encoded, index++) - 63;
                result |= (byteEncoded & 0x1F) << shift;
                shift += 5;
            } while (byteEncoded >= 32);
            int deltalongitude = (result & 1) > 0 ? ~(result >>> 1) : result >>> 1;
            array.add(new Location(Latitude.degrees((double)latitude * precision2), Longitude.degrees((double)(longitude += deltalongitude) * precision2)));
        }
        return new PolyLine((List<? extends Location>)array);
    }

    private String compress(PolyLine points, int precision0) {
        long oldLatitude = 0L;
        long oldLongitude = 0L;
        StringBuilder encoded = new StringBuilder();
        double precision = Math.pow(10.0, precision0);
        Location last = Location.CENTER;
        for (Location location : points) {
            long latitude = Math.round(location.getLatitude().asDegrees() * precision);
            long longitude = Math.round(location.getLongitude().asDegrees() * precision);
            encoded.append(this.encodeNumber(latitude - oldLatitude));
            long deltaLongitude = longitude - oldLongitude;
            if (Math.abs(deltaLongitude) > MAXIMUM_DELTA_LONGITUDE) {
                throw new PolyLineCompressionException("Unable to compress the polyLine, two consecutive points ({} and {}) are too far apart in longitude: {} degrees.", last, location, (double)deltaLongitude / precision);
            }
            encoded.append(this.encodeNumber(deltaLongitude));
            oldLatitude = latitude;
            oldLongitude = longitude;
            last = location;
        }
        return encoded.toString();
    }

    private String encodeNumber(long number0) {
        long number = number0 << 1;
        if (number < 0L) {
            number ^= 0xFFFFFFFFFFFFFFFFL;
        }
        StringBuilder encoded = new StringBuilder();
        while (number >= 32L) {
            encoded.append(String.valueOf(Character.toChars((0x20 | (int)number & 0x1F) + 63)));
            number >>>= 5;
        }
        encoded.append(String.valueOf(Character.toChars((int)number + 63)));
        return encoded.toString();
    }

    private byte[] getWkbFallback(PolyLine polyLine) {
        byte[] wkbEncoding = polyLine.toWkb();
        byte[] finalEncoding = new byte[1 + wkbEncoding.length];
        finalEncoding[0] = 0;
        System.arraycopy(wkbEncoding, 0, finalEncoding, 1, wkbEncoding.length);
        return finalEncoding;
    }

    public static class PolyLineCompressionException
    extends CoreException {
        private static final long serialVersionUID = -3974024747280370420L;

        public PolyLineCompressionException(String message, Object ... items) {
            super(message, items);
        }
    }
}

