/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.gson.JsonObject;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.GeometryPrintable;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.converters.WkbLocationConverter;
import org.openstreetmap.atlas.geography.converters.WktLocationConverter;
import org.openstreetmap.atlas.geography.coordinates.EarthCenteredEarthFixedCoordinate;
import org.openstreetmap.atlas.geography.coordinates.GeodeticCoordinate;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class Location
implements Located,
Iterable<Location>,
Serializable,
GeometryPrintable,
GeoJsonGeometry {
    public static final String TEST_1_COORDINATES = "37.335310,-122.009566";
    public static final String TEST_2_COORDINATES = "37.321628,-122.028464";
    public static final String TEST_3_COORDINATES = "37.317585,-122.052138";
    public static final String TEST_4_COORDINATES = "37.332451,-122.028932";
    public static final String TEST_5_COORDINATES = "37.390535,-122.031007";
    public static final String TEST_6_COORDINATES = "37.325440,-122.033948";
    public static final String TEST_7_COORDINATES = "37.3314171,-122.0304871";
    public static final String TEST_8_COORDINATES = "37.3214159,-122.0303831";
    public static final Location TEST_1 = Location.forString("37.335310,-122.009566");
    public static final Location TEST_2 = Location.forString("37.321628,-122.028464");
    public static final Location TEST_3 = Location.forString("37.317585,-122.052138");
    public static final Location TEST_4 = Location.forString("37.332451,-122.028932");
    public static final Location TEST_5 = Location.forString("37.390535,-122.031007");
    public static final Location TEST_6 = Location.forString("37.325440,-122.033948");
    public static final Location TEST_7 = Location.forString("37.3314171,-122.0304871");
    public static final Location TEST_8 = Location.forString("37.3214159,-122.0303831");
    public static final Location STEVENS_CREEK = Location.forString("37.324233,-122.003467");
    public static final Location CROSSING_85_280 = Location.forString("37.332439,-122.055760");
    public static final Location CROSSING_85_17 = Location.forString("37.255731,-121.955918");
    public static final Location EIFFEL_TOWER = Location.forString("48.858241,2.294495");
    public static final Location COLOSSEUM = Location.forString("41.890224,12.492340");
    public static final Location CENTER = new Location(0L);
    private static final long serialVersionUID = 3770424147251047128L;
    private static final int INT_FULL_MASK = -1;
    private static final long INT_FULL_MASK_AS_LONG = 0xFFFFFFFFL;
    private static final int INT_SIZE = 32;
    private static final int FACTOR_OF_3 = 3;
    private static final Random RANDOM = new Random();
    private final Latitude latitude;
    private final Longitude longitude;

    public static Location forString(String locationString) {
        StringList split = StringList.split(locationString, ",");
        if (split.size() != 2) {
            throw new CoreException("Invalid Location String: {}", locationString);
        }
        double latitude = Double.parseDouble(split.get(0));
        double longitude = Double.parseDouble(split.get(1));
        return new Location(Latitude.degrees(latitude), Longitude.degrees(longitude));
    }

    public static Location forStringLongitudeLatitude(String locationString) {
        StringList split = StringList.split(locationString, ",");
        if (split.size() != 2) {
            throw new CoreException("Invalid Location String: {}", locationString);
        }
        double latitude = Double.parseDouble(split.get(1));
        double longitude = Double.parseDouble(split.get(0));
        return new Location(Latitude.degrees(latitude), Longitude.degrees(longitude));
    }

    public static Location forWkt(String wkt) {
        return new WktLocationConverter().backwardConvert(wkt);
    }

    public static Location random(Rectangle bounds) {
        int latitude = RANDOM.ints((int)bounds.lowerLeft().getLatitude().asDm7(), (int)bounds.upperRight().getLatitude().asDm7()).iterator().next();
        int longitude = RANDOM.ints((int)bounds.lowerLeft().getLongitude().asDm7(), (int)bounds.upperRight().getLongitude().asDm7()).iterator().next();
        return new Location(Latitude.dm7(latitude), Longitude.dm7(longitude));
    }

    public Location(Latitude latitude, Longitude longitude) {
        if (latitude == null) {
            throw new CoreException("Latitude is null.");
        }
        if (longitude == null) {
            throw new CoreException("Longitude is null.");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Location(Location other) {
        if (other == null) {
            throw new CoreException("Other Location was null");
        }
        this.latitude = other.latitude;
        this.longitude = other.longitude;
    }

    public Location(long concatenation) {
        int lon = (int)concatenation;
        int lat = (int)(concatenation >>> 32) & 0xFFFFFFFF;
        this.longitude = Longitude.dm7(lon);
        this.latitude = Latitude.dm7(lat);
    }

    public long asConcatenation() {
        long result = this.latitude.asDm7();
        result <<= 32;
        return result |= this.longitude.asDm7() & 0xFFFFFFFFL;
    }

    @Override
    public JsonObject asGeoJsonGeometry() {
        return GeoJsonUtils.geometry(GeoJsonType.POINT, GeoJsonUtils.coordinate(this));
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forCorners(this, this);
    }

    public Rectangle boxAround(Distance extension) {
        Location north = this.shiftAlongGreatCircle(Heading.NORTH, extension);
        Location south = this.shiftAlongGreatCircle(Heading.SOUTH, extension);
        Location east = this.shiftAlongGreatCircle(Heading.EAST, extension);
        Location west = this.shiftAlongGreatCircle(Heading.WEST, extension);
        return Rectangle.forLocations(north, south, east, west);
    }

    public Distance distanceTo(Location that) {
        if (this.getLongitude().isCloserViaAntimeridianTo(that.getLongitude())) {
            return this.haversineDistanceTo(that);
        }
        return this.equirectangularDistanceTo(that);
    }

    public boolean equals(Object other) {
        if (other instanceof Location) {
            Location that = (Location)other;
            return this.getLatitude().equals(that.getLatitude()) && this.getLongitude().equals(that.getLongitude());
        }
        return false;
    }

    public Distance equirectangularDistanceTo(Location that) {
        double lat1 = this.getLatitude().asRadians();
        double lon1 = this.getLongitude().asRadians();
        double lat2 = that.getLatitude().asRadians();
        double lon2 = that.getLongitude().asRadians();
        double xAxis = (lon2 - lon1) * Math.cos((lat1 + lat2) / 2.0);
        double yAxis = lat2 - lat1;
        return Distance.AVERAGE_EARTH_RADIUS.scaleBy(Math.sqrt(xAxis * xAxis + yAxis * yAxis));
    }

    @Override
    public GeoJsonType getGeoJsonType() {
        return GeoJsonType.POINT;
    }

    public Latitude getLatitude() {
        return this.latitude;
    }

    public Longitude getLongitude() {
        return this.longitude;
    }

    public boolean hasSameLatitudeAs(Location other) {
        return this.getLatitude().equals(other.getLatitude());
    }

    public boolean hasSameLongitudeAs(Location other) {
        return this.getLongitude().equals(other.getLongitude());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.latitude == null ? 0 : this.latitude.hashCode());
        result = 31 * result + (this.longitude == null ? 0 : this.longitude.hashCode());
        return result;
    }

    public Distance haversineDistanceTo(Location that) {
        double lat1 = this.getLatitude().asRadians();
        double lon1 = this.getLongitude().asRadians();
        double lat2 = that.getLatitude().asRadians();
        double lon2 = that.getLongitude().asRadians();
        double deltaLat = lat2 - lat1;
        double deltaLon = lon2 - lon1;
        double hav = Math.pow(Math.sin(deltaLat / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(deltaLon / 2.0), 2.0);
        double result = 2.0 * Math.atan2(Math.sqrt(hav), Math.sqrt(1.0 - hav));
        return Distance.AVERAGE_EARTH_RADIUS.scaleBy(result);
    }

    public Heading headingTo(Location that) {
        if (this.equals(that)) {
            throw new CoreException("Cannot compute some heading when two points are the same.");
        }
        double lat1 = this.getLatitude().asRadians();
        double lon1 = this.getLongitude().asRadians();
        double lat2 = that.getLatitude().asRadians();
        double lon2 = that.getLongitude().asRadians();
        double deltaLon = lon2 - lon1;
        double yAxis = Math.sin(deltaLon) * Math.cos(lat2);
        double xAxis = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return Heading.radians(Math.atan2(yAxis, xAxis));
    }

    public boolean isEastOf(Location other) {
        return this.getLongitude().isGreaterThan(other.getLongitude());
    }

    public boolean isEastOfOrOnTheSameLatitudeAs(Location other) {
        return this.getLongitude().isGreaterThanOrEqualTo(other.getLongitude());
    }

    public boolean isNorthOf(Location other) {
        return this.getLatitude().isGreaterThan(other.getLatitude());
    }

    public boolean isNorthOfOrOnTheSameLatitudeAs(Location other) {
        return this.getLatitude().isGreaterThanOrEqualTo(other.getLatitude());
    }

    @Override
    public Iterator<Location> iterator() {
        return Iterables.from(this).iterator();
    }

    public Location loxodromicMidPoint(Location that) {
        double lat1 = this.getLatitude().asRadians();
        double lon1 = this.getLongitude().asRadians();
        double lat2 = that.getLatitude().asRadians();
        double lon2 = that.getLongitude().asRadians();
        if (Math.abs(lon2 - lon1) > Math.PI) {
            lon1 += Math.PI * 2;
        }
        double pheta = (lat1 + lat2) / 2.0;
        double phi1 = Math.tan(0.7853981633974483 + lat1 / 2.0);
        double phi2 = Math.tan(0.7853981633974483 + lat2 / 2.0);
        double phi3 = Math.tan(0.7853981633974483 + pheta / 2.0);
        double lambda = ((lon2 - lon1) * Math.log(phi3) + lon1 * Math.log(phi2) - lon2 * Math.log(phi1)) / Math.log(phi2 / phi1);
        lambda = !Double.isFinite(lambda) || lon1 == lon2 ? (lon1 + lon2) / 2.0 : (lambda + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new Location(Latitude.radians(pheta), Longitude.radians(lambda));
    }

    public Location midPoint(Location that) {
        double lat1 = this.getLatitude().asRadians();
        double lon1 = this.getLongitude().asRadians();
        double lat2 = that.getLatitude().asRadians();
        double lon2 = that.getLongitude().asRadians();
        double longitudeDelta = lon2 - lon1;
        double xBearing = Math.cos(lat2) * Math.cos(longitudeDelta);
        double yBearing = Math.cos(lat2) * Math.sin(longitudeDelta);
        double pheta = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + xBearing) * (Math.cos(lat1) + xBearing) + yBearing * yBearing));
        double lambda = lon1 + Math.atan2(yBearing, Math.cos(lat1) + xBearing);
        lambda = (lambda + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        if (this.getLongitude().equals(Longitude.MAXIMUM) && that.getLongitude().equals(Longitude.MAXIMUM)) {
            lambda *= -1.0;
        }
        return new Location(Latitude.radians(pheta), Longitude.radians(lambda));
    }

    public Location shiftAlongGreatCircle(Heading initialHeading, Distance distance) {
        if (Distance.ZERO.equals(distance)) {
            return this;
        }
        double latitude1 = this.getLatitude().asRadians();
        double longitude1 = this.getLongitude().asRadians();
        double bearing = initialHeading.asRadians();
        double latitude2 = Math.asin(Math.sin(latitude1) * Math.cos(distance.asMillimeters() / Distance.AVERAGE_EARTH_RADIUS.asMillimeters()) + Math.cos(latitude1) * Math.sin(distance.asMillimeters() / Distance.AVERAGE_EARTH_RADIUS.asMillimeters()) * Math.cos(bearing));
        double longitude2 = longitude1 + Math.atan2(Math.sin(bearing) * Math.sin(distance.asMillimeters() / Distance.AVERAGE_EARTH_RADIUS.asMillimeters()) * Math.cos(latitude1), Math.cos(distance.asMillimeters() / Distance.AVERAGE_EARTH_RADIUS.asMillimeters()) - Math.sin(latitude1) * Math.sin(latitude2));
        return new Location(Latitude.radiansBounded(latitude2), Longitude.radiansBounded(longitude2));
    }

    public Snapper.SnappedLocation snapTo(MultiPolygon shape) {
        return new Snapper().snap(this, shape);
    }

    public Snapper.SnappedLocation snapTo(PolyLine shape) {
        return new Snapper().snap(this, shape);
    }

    public String toCompactString() {
        return this.getLatitude() + "," + this.getLongitude();
    }

    public EarthCenteredEarthFixedCoordinate toEarthCenteredEarthFixedCoordinate() {
        return new EarthCenteredEarthFixedCoordinate(this);
    }

    public GeodeticCoordinate toGeodeticCoordinate() {
        return new GeodeticCoordinate(this);
    }

    public String toString() {
        return this.toWkt();
    }

    @Override
    public byte[] toWkb() {
        return new WkbLocationConverter().convert(this);
    }

    @Override
    public String toWkt() {
        return new WktLocationConverter().convert(this);
    }

    @Override
    public boolean within(GeometricSurface surface) {
        return surface.fullyGeometricallyEncloses(this);
    }

    protected Point2D asAwtPoint() {
        return new Point((int)this.getLongitude().asDm7(), (int)this.getLatitude().asDm7());
    }
}

