/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.streaming;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.Resource;

public class SeekableResourceStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final Resource resource;
    private final InputStream input;
    private final long pos;

    public SeekableResourceStream(Resource resource) {
        this.resource = resource;
        this.input = resource.read();
        this.pos = 0L;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new CoreException("Unable to close stream", e);
        }
        finally {
            Streams.close(this.input);
        }
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return this.input.read(buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.input.read(buffer, 0, (int)this.resource.length());
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.input.read(buffer, offset, length);
    }

    public void seek(long pos) throws IOException {
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return true;
    }
}

