/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SparkConf;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.streaming.SeekableResourceStream;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;
import org.openstreetmap.atlas.streaming.resource.ByteArrayResource;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFileSystem.class);
    private static final Map<String, Resource> STORE = new ConcurrentHashMap<String, Resource>();
    public static final String SCHEME = "resource";
    public static final String RESOURCE_FILE_SYSTEM_CONFIGURATION = "fs.resource.impl";
    private static final FileSystem.Statistics STATISTICS_INTERNAL = new FileSystem.Statistics("resource");
    private static Class<?> clazz = null;
    private URI uri;
    private Path workingDirectory;

    public static void addResource(String path, String name, boolean gzipIt, Class<?> clazz) {
        AbstractResource input = new InputStreamResource(() -> clazz.getResourceAsStream(name));
        if (gzipIt) {
            ByteArrayResource newInput = new ByteArrayResource();
            newInput.setCompressor(Compressor.GZIP);
            input.copyTo(newInput);
            input = newInput;
        }
        ResourceFileSystem.addResource(path, input);
    }

    public static void addResource(String path, String name, boolean gzipIt) {
        if (clazz == null) {
            throw new CoreException("Need to register a class to find the resource!");
        }
        ResourceFileSystem.addResource(path, name, gzipIt, clazz);
    }

    public static void addResource(String name, Resource resource) {
        STORE.put(name, resource);
    }

    public static void addResource(String path, String name) {
        ResourceFileSystem.addResource(path, name, false);
    }

    public static void addResourceContents(String path, String contents) {
        ResourceFileSystem.addResource(path, new StringResource(contents));
    }

    public static void clear() {
        STORE.clear();
    }

    public static SparkConf configuredConf() {
        SparkConf result = new SparkConf();
        result.set(RESOURCE_FILE_SYSTEM_CONFIGURATION, ResourceFileSystem.class.getCanonicalName());
        result.set("spark.master", "local");
        result.set("spark.app.name", "appName");
        return result;
    }

    public static Configuration configuredConfiguration() {
        Configuration result = new Configuration();
        result.set(RESOURCE_FILE_SYSTEM_CONFIGURATION, ResourceFileSystem.class.getCanonicalName());
        return result;
    }

    public static void dumpToDisk(File folder) {
        ResourceFileSystem.files().forEach(file -> {
            String subPath = file.substring(String.valueOf("resource://").length());
            File output = folder.child(subPath);
            output.withCompressor(Compressor.NONE);
            STORE.get(file).copyTo(output);
        });
    }

    public static Set<String> files() {
        return STORE.keySet();
    }

    public static void printContents() {
        ResourceFileSystem.files().forEach(file -> logger.info("{}", file));
    }

    public static synchronized void registerResourceExtractionClass(Class<?> clazz) {
        ResourceFileSystem.clazz = clazz;
    }

    public static Map<String, String> simpleconfiguration() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(RESOURCE_FILE_SYSTEM_CONFIGURATION, ResourceFileSystem.class.getCanonicalName());
        return result;
    }

    public ResourceFileSystem() {
        this.setConf(ResourceFileSystem.configuredConfiguration());
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        throw new CoreException("Not supported.");
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (STORE.containsKey(hadoopPath.toString())) {
            this.delete(hadoopPath, false);
        }
        String name = hadoopPath.toString();
        ByteArrayResource resource = new ByteArrayResource().withName(name);
        STORE.put(name, resource);
        return new FSDataOutputStream(resource.write(), STATISTICS_INTERNAL);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        STORE.remove(hadoopPath.toString());
        return true;
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        Resource resource = STORE.get(hadoopPath.toString());
        if (resource == null) {
            throw new FileNotFoundException();
        }
        return new FileStatus(resource.length(), false, 1, Long.MAX_VALUE, 0L, hadoopPath);
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        try {
            this.setConf(conf);
            this.uri = uri;
            super.initialize(uri, conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FileStatus[] listStatus(Path hadoopPath) throws FileNotFoundException, IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        String prefix = hadoopPath.toString();
        for (String filePath : STORE.keySet()) {
            if (!filePath.startsWith(prefix)) continue;
            result.add(new FileStatus(0L, false, 0, 0L, 0L, new Path(filePath)));
        }
        return result.toArray(new FileStatus[0]);
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        return true;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        String name = hadoopPath.toString();
        Resource resource = STORE.get(name);
        if (resource == null) {
            throw new FileNotFoundException("Path does not exist or is a directory: " + hadoopPath);
        }
        return new FSDataInputStream((InputStream)new SeekableResourceStream(resource));
    }

    public boolean rename(Path source, Path destination) throws IOException {
        Object destinationName;
        String sourceName = source.toString();
        if (sourceName.startsWith((String)(destinationName = destination.toString()))) {
            String appendName;
            destinationName = ((String)destinationName).endsWith("/") ? destinationName : (String)destinationName + "/";
            Pattern pattern = Pattern.compile("\\/attempt_[^\\/]*\\/");
            Matcher matcher = pattern.matcher(sourceName);
            if (matcher.find()) {
                String match = matcher.group(0);
                StringList split = StringList.split(sourceName, match);
                appendName = split.get(1);
            } else {
                appendName = sourceName.substring(sourceName.lastIndexOf("/") + 1);
            }
            destinationName = (String)destinationName + appendName;
        }
        if (STORE.containsKey(sourceName)) {
            if (STORE.containsKey(destinationName)) {
                this.delete(new Path((String)destinationName), false);
            }
            Resource resource = STORE.get(sourceName);
            STORE.put((String)destinationName, resource);
            STORE.remove(sourceName);
        }
        return true;
    }

    public void setWorkingDirectory(Path newDirectory) {
        this.workingDirectory = newDirectory;
    }
}

