/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.sharded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMapArchiver;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class ShardedSparkJob
extends SparkJob {
    private static final long serialVersionUID = -5341594024010883883L;
    private static final Logger logger = LoggerFactory.getLogger(ShardedSparkJob.class);
    public static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be included in the final Atlas", value -> StringList.split(value, ","), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch<String>("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY_SHAPES = new Command.Switch<String>("countryShapes", "Shape file containing the countries", StringConverter.IDENTITY, Command.Optionality.REQUIRED);

    private static PairFlatMapFunction<String, String, Shard> countryToShards(CountryBoundaryMap worldBoundaries, Sharding sharding) {
        return (PairFlatMapFunction & Serializable)countryName -> {
            List<CountryBoundary> boundaries = worldBoundaries.countryBoundary((String)countryName);
            if (boundaries == null) {
                logger.error("No boundaries found for country {}!", countryName);
                return new ArrayList().iterator();
            }
            logger.info("Generating shards for country {}", countryName);
            HashSet<Shard> shards = new HashSet<Shard>();
            for (CountryBoundary boundary : boundaries) {
                shards.addAll(ShardedSparkJob.shards(sharding, boundary));
            }
            ArrayList countryShards = new ArrayList();
            shards.forEach(shard -> countryShards.add(new Tuple2(countryName, shard)));
            return countryShards.iterator();
        };
    }

    private static Set<Shard> shards(Sharding sharding, CountryBoundary countryBoundary) {
        HashSet<Shard> shards = new HashSet<Shard>();
        for (Polygon subBoundary : countryBoundary.getBoundary().outers()) {
            shards.addAll(Iterables.asList(Iterables.filter(sharding.shards(subBoundary.bounds()), shard -> subBoundary.overlaps(shard.bounds()))));
        }
        return shards;
    }

    @Override
    public void start(CommandMap command) {
        StringList countries = (StringList)command.get(COUNTRIES);
        String shardingType = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingType, this.configuration());
        String countryShapes = (String)command.get(COUNTRY_SHAPES);
        logger.info("Reading country boundaries from {}", (Object)countryShapes);
        CountryBoundaryMap worldBoundaries = new CountryBoundaryMapArchiver().read(this.resource(countryShapes));
        logger.info("Done Reading {} country boundaries from {}", (Object)worldBoundaries.size(), (Object)countryShapes);
        JavaRDD countriesRDD = this.getContext().parallelize(Iterables.asList(countries), countries.size());
        JavaPairRDD preCountryShardsRDD = countriesRDD.flatMapToPair(ShardedSparkJob.countryToShards(worldBoundaries, sharding));
        List countryShards = preCountryShardsRDD.collect();
        MultiMap<String, Shard> countryToShardMap = new MultiMap<String, Shard>();
        countryShards.forEach(tuple -> countryToShardMap.add((String)tuple._1(), (Shard)tuple._2()));
        this.start2(command, sharding, countryToShardMap);
    }

    public abstract void start2(CommandMap var1, Sharding var2, MultiMap<String, Shard> var3);

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(COUNTRIES, SHARDING_TYPE, COUNTRY_SHAPES);
    }
}

