/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.rdd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class ShardedAtlasRDDLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)ShardedAtlasRDDLoader.class.getCanonicalName());
    private static final AtlasResourceLoader ATLAS_LOADER = new AtlasResourceLoader();

    public static JavaPairRDD<Shard, Atlas> generateShardedAtlasRDD(JavaSparkContext context, String country, CountryBoundaryMap boundaries, String atlasDirectory, Sharding atlasSharding, Map<String, String> configurationMap) {
        Set<Shard> countryAtlasShards = ShardedAtlasRDDLoader.getCountryShards(atlasSharding, country, boundaries);
        JavaRDD countryShardsRDD = context.parallelize(new ArrayList<Shard>(countryAtlasShards));
        return countryShardsRDD.mapToPair((PairFunction & Serializable)shard -> {
            Atlas atlas = ShardedAtlasRDDLoader.loadOneAtlasShard(country, shard.getName(), atlasDirectory, configurationMap);
            if (atlas != null) {
                logger.info("Loaded Atlas atlas_name={} atlas_size={} number_of_edges={}", new Object[]{atlas.getName(), atlas.size(), atlas.numberOfEdges()});
            } else {
                logger.error("Atlas is null for shard: {}", (Object)shard.getName());
            }
            return new Tuple2(shard, (Object)atlas);
        });
    }

    public static Atlas loadOneAtlasShard(String country, String shardName, String atlasDirectory, Map<String, String> configurationMap) {
        String atlasPath = ShardedAtlasRDDLoader.atlasPath(atlasDirectory, country, shardName);
        logger.info("Start to load atlas from atlas directory: {} ", (Object)atlasPath);
        Atlas atlas = null;
        try {
            if (!new FileSystemCreator().get(atlasPath, configurationMap).exists(new Path(atlasPath))) {
                logger.warn("No atlas found for path {}", (Object)atlasPath);
                return atlas;
            }
        }
        catch (Exception exception) {
            throw new CoreException("Can't check if path " + atlasPath + " exists or not with exception: " + exception.getMessage());
        }
        atlas = ATLAS_LOADER.load(FileSystemHelper.resource(atlasPath, configurationMap));
        return atlas;
    }

    private static String atlasPath(String atlasDirectory, String country, String shardName) {
        return SparkFileHelper.combine(atlasDirectory + "/" + country, String.format("%s%s", ShardedAtlasRDDLoader.getAtlasName(country, shardName), FileSuffix.ATLAS.toString()));
    }

    private static String getAtlasName(String country, String shardName) {
        return String.format("%s_%s", country, shardName);
    }

    private static Set<Shard> getCountryShards(Sharding sharding, String country, CountryBoundaryMap boundary) {
        Time time = Time.now();
        Object countryShards = CountryShardListing.countryToShardList(new StringList(country), boundary, sharding).get(country);
        logger.info("Generating shards for country {} takes {}", (Object)country, (Object)time.elapsedSince());
        logger.info("Country {} has {} shards", (Object)country, (Object)countryShards.size());
        countryShards.forEach(atlasShard -> logger.info("Shard {}", (Object)atlasShard.getName()));
        return countryShards;
    }

    protected ShardedAtlasRDDLoader() {
    }
}

