/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.filesystem;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.SparkConf;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.converters.SparkConfToHadoopConfigurationConverter;
import org.openstreetmap.atlas.generator.tools.streaming.ResourceFileSystem;
import org.openstreetmap.atlas.utilities.collections.Maps;

public class FileSystemCreator {
    private static final SparkConfToHadoopConfigurationConverter SPARK_CONF_TO_HADOOP_CONFIGURATION_CONVERTER = new SparkConfToHadoopConfigurationConverter();

    public static final Map<String, String> resourceFileSystemScheme() {
        return Maps.hashMap("fs.resource.impl", ResourceFileSystem.class.getCanonicalName());
    }

    public FileSystem get(String path, Configuration configuration) {
        try {
            return FileSystem.newInstance((URI)new URI(path), (Configuration)configuration);
        }
        catch (Exception e) {
            throw new CoreException("Could not create FileSystem.", e);
        }
    }

    public FileSystem get(String path, Map<String, String> configuration) {
        Configuration conf = new Configuration();
        for (String key : configuration.keySet()) {
            conf.set(key, configuration.get(key));
        }
        return this.get(path, conf);
    }

    public FileSystem get(String path, SparkConf configuration) {
        return this.get(path, SPARK_CONF_TO_HADOOP_CONFIGURATION_CONVERTER.convert(configuration));
    }
}

