/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.sharding.Shard;

final class AtlasGenerationTask
implements Serializable {
    private static final long serialVersionUID = -3730018742291904849L;
    private final String country;
    private final Shard shard;
    private final Set<Shard> allShards;

    AtlasGenerationTask(String country, Shard shard, Set<Shard> allShards) {
        this.country = country;
        this.shard = shard;
        this.allShards = allShards;
    }

    public String toString() {
        return String.format("%s - %s:%s%s", this.getCountry(), this.getShard(), System.lineSeparator(), this.getAllShards().stream().map(shard -> String.format(" - %s", shard)).collect(Collectors.joining(System.lineSeparator())));
    }

    Set<Shard> getAllShards() {
        return this.allShards;
    }

    String getCountry() {
        return this.country;
    }

    Shard getShard() {
        return this.shard;
    }
}

