/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.exception.change;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.MergeFailureType;
import org.slf4j.helpers.MessageFormatter;

public class FeatureChangeMergeException
extends CoreException {
    private static final long serialVersionUID = -3583945839922744755L;
    static final int MAXIMUM_MESSAGE_SIZE = 2000;
    private final List<MergeFailureType> failureTypeTrace;

    static String truncate(String input) {
        return input.substring(0, Math.min(input.length(), 2000));
    }

    public FeatureChangeMergeException(List<MergeFailureType> failureTypeTrace, String message) {
        super(FeatureChangeMergeException.truncate(message));
        this.failureTypeTrace = failureTypeTrace;
        if (this.failureTypeTrace == null || this.failureTypeTrace.isEmpty()) {
            throw new CoreException("failureTypeTrace cannot be null or empty");
        }
    }

    public FeatureChangeMergeException(List<MergeFailureType> failureTypeTrace, String message, Object ... arguments) {
        super(FeatureChangeMergeException.truncate(MessageFormatter.arrayFormat((String)message, (Object[])((Object[])REFINE_ARGUMENTS.apply(arguments))).getMessage()), (Throwable)((Optional)CAUSE_FROM.apply(arguments)).orElse(null));
        this.failureTypeTrace = failureTypeTrace;
        if (this.failureTypeTrace == null || this.failureTypeTrace.isEmpty()) {
            throw new CoreException("failureTypeTrace cannot be null or empty");
        }
    }

    public FeatureChangeMergeException(MergeFailureType rootLevelFailure, String message, Object ... arguments) {
        super(FeatureChangeMergeException.truncate(MessageFormatter.arrayFormat((String)message, (Object[])((Object[])REFINE_ARGUMENTS.apply(arguments))).getMessage()), (Throwable)((Optional)CAUSE_FROM.apply(arguments)).orElse(null));
        if (rootLevelFailure == null) {
            throw new CoreException("rootLevelFailure cannot be null");
        }
        this.failureTypeTrace = new ArrayList<MergeFailureType>();
        this.failureTypeTrace.add(rootLevelFailure);
    }

    public FeatureChangeMergeException(MergeFailureType rootLevelFailure, String message) {
        super(FeatureChangeMergeException.truncate(message));
        if (rootLevelFailure == null) {
            throw new CoreException("rootLevelFailure cannot be null");
        }
        this.failureTypeTrace = new ArrayList<MergeFailureType>();
        this.failureTypeTrace.add(rootLevelFailure);
    }

    public MergeFailureType failureAtFrameIndex(int index) {
        if (index >= this.failureTypeTrace.size()) {
            return this.topLevelFailure();
        }
        return this.failureTypeTrace.get(index);
    }

    public int failureTraceSize() {
        return this.failureTypeTrace.size();
    }

    public List<MergeFailureType> getMergeFailureTrace() {
        return new ArrayList<MergeFailureType>(this.failureTypeTrace);
    }

    public MergeFailureType rootLevelFailure() {
        return this.failureTypeTrace.get(0);
    }

    public MergeFailureType topLevelFailure() {
        return this.failureTypeTrace.get(this.failureTypeTrace.size() - 1);
    }

    public boolean traceContainsExactFailureSubSequence(List<MergeFailureType> subSequence) {
        if (subSequence.isEmpty()) {
            return true;
        }
        if (subSequence.size() > this.failureTypeTrace.size()) {
            return false;
        }
        for (int i = 0; i < this.failureTypeTrace.size(); ++i) {
            boolean foundSubSequenceThisIteration = true;
            int j = 0;
            int tmpI = i;
            while (j < subSequence.size()) {
                if (tmpI >= this.failureTypeTrace.size() || subSequence.get(j) != this.failureTypeTrace.get(tmpI)) {
                    foundSubSequenceThisIteration = false;
                    break;
                }
                ++j;
                ++tmpI;
            }
            if (!foundSubSequenceThisIteration) continue;
            return true;
        }
        return false;
    }

    public boolean traceContainsFailureType(MergeFailureType type) {
        for (MergeFailureType currentType : this.failureTypeTrace) {
            if (type != currentType) continue;
            return true;
        }
        return false;
    }

    public boolean traceMatchesExactFailureSequence(List<MergeFailureType> sequence) {
        if (sequence == null) {
            return false;
        }
        if (sequence.size() != this.failureTypeTrace.size()) {
            return false;
        }
        return this.failureTypeTrace.equals(sequence);
    }

    public List<MergeFailureType> withNewTopLevelFailure(MergeFailureType type) {
        ArrayList<MergeFailureType> newList = new ArrayList<MergeFailureType>(this.failureTypeTrace);
        newList.add(type);
        return newList;
    }
}

