/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class InvalidTagsCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 5150282147895785829L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("OSM feature {0,number,#} has invalid tags.", "Check the following tags for missing, conflicting, or incorrect values: {0}");
    private static final String KEY_VALUE_SEPARATOR = "->";
    private final List<Tuple<? extends Set<Class<AtlasEntity>>, TaggableFilter>> classTagFilters;

    private static Set<String> getFilterKeys(TaggableFilter filter) {
        return Arrays.stream(filter.toString().split("[|&]+")).filter(string -> string.contains(KEY_VALUE_SEPARATOR)).map(tag -> tag.split(KEY_VALUE_SEPARATOR)[0]).collect(Collectors.toSet());
    }

    private static Tuple<Set<Class<AtlasEntity>>, TaggableFilter> stringsToClassTagFilter(String classString, String tagFilterString) {
        return new Tuple<Set<Class<AtlasEntity>>, TaggableFilter>(Arrays.stream(classString.split(",")).map(string -> ItemType.valueOf(string.toUpperCase()).getMemberClass()).collect(Collectors.toSet()), TaggableFilter.forDefinition(tagFilterString));
    }

    public InvalidTagsCheck(Configuration configuration) {
        super(configuration);
        this.classTagFilters = this.configurationValue(configuration, "filters.classes.tags", Collections.emptyList(), configList -> configList.stream().map(classTagValue -> {
            List classTagList = (List)classTagValue;
            if (classTagList.size() > 1) {
                return InvalidTagsCheck.stringsToClassTagFilter((String)classTagList.get(0), (String)classTagList.get(1));
            }
            return new Tuple(new HashSet(), TaggableFilter.forDefinition(""));
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        List<String> instructions = this.classTagFilters.stream().filter(classTagFilter -> ((Set)classTagFilter.getFirst()).stream().anyMatch(entityClass -> entityClass.isInstance(object)) && ((TaggableFilter)classTagFilter.getSecond()).test(object)).map(classTagFilter -> this.getLocalizedInstruction(1, InvalidTagsCheck.getFilterKeys((TaggableFilter)classTagFilter.getSecond()))).collect(Collectors.toList());
        if (!instructions.isEmpty()) {
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            String instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier());
            CheckFlag flag = object instanceof Edge ? this.createFlag(new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction);
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

