/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.tags.AccessTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LandUseTag;
import org.openstreetmap.atlas.tags.MilitaryTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidAccessTagCheck
extends BaseCheck<Long> {
    private static final String MINIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.RESIDENTIAL.toString();
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This way {0,number,#} has an invalid access tag value, resulting from improper tag combinations. Investigate ground truth and properly correct them.");
    private static final long serialVersionUID = 5197703822744690835L;
    private final HighwayTag minimumHighwayType;

    public InvalidAccessTagCheck(Configuration configuration) {
        super(configuration);
        String highwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_TYPE_DEFAULT);
        this.minimumHighwayType = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return AccessTag.isNo(object) && (object instanceof Edge || object instanceof Line) && Edge.isMasterEdgeIdentifier(object.getIdentifier()) && !this.isFlagged(object.getOsmIdentifier()) && this.isMinimumHighway(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        if (!this.isInMilitaryArea((LineItem)object)) {
            this.markAsFlagged(object.getOsmIdentifier());
            String instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier());
            if (object instanceof Edge) {
                return Optional.of(this.createFlag(new OsmWayWalker((Edge)object).collectEdges(), instruction));
            }
            return Optional.of(this.createFlag(object, instruction));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isInMilitaryArea(LineItem object) {
        PolyLine objectAsPolyLine = object.asPolyLine();
        if (object.getAtlas().areasIntersecting(object.bounds(), area -> !(!Validators.isOfType((Taggable)area, LandUseTag.class, (Enum[])new LandUseTag[]{LandUseTag.MILITARY}) && !Validators.hasValuesFor(area, MilitaryTag.class) || !object.intersects(area.asPolygon()) && !area.asPolygon().fullyGeometricallyEncloses(objectAsPolyLine))).iterator().hasNext()) {
            return true;
        }
        for (Relation relation2 : object.getAtlas().relationsWithEntitiesIntersecting(object.bounds(), relation -> (Validators.isOfType((Taggable)relation, LandUseTag.class, (Enum[])new LandUseTag[]{LandUseTag.MILITARY}) || Validators.hasValuesFor(relation, MilitaryTag.class)) && relation.isMultiPolygon())) {
            try {
                MultiPolygon relationPolygon = new RelationOrAreaToMultiPolygonConverter().convert(relation2);
                if (!object.intersects(relationPolygon) && !relationPolygon.fullyGeometricallyEncloses(object.asPolyLine())) continue;
                return true;
            }
            catch (MultiplePolyLineToPolygonsConverter.OpenPolygonException e) {
            }
        }
        return false;
    }

    private boolean isMinimumHighway(AtlasObject object) {
        Optional<HighwayTag> result = HighwayTag.highwayTag(object);
        return result.isPresent() && result.get().isMoreImportantThanOrEqualTo(this.minimumHighwayType);
    }
}

