/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.SurfaceTag;
import org.openstreetmap.atlas.tags.names.NameFinder;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ImproperAndUnknownRoadNameCheck
extends BaseCheck<Long> {
    private static final String TAG_INSTRUCTION = "Road (Osm identifier: {0,number,#}) contains {1} tag with value {2} that is equivalent to a value equal to a common {3} tag value.\n";
    private static final String IMPROPER_INSTRUCTION = "Road (Osm identifier: {0,number,#}) contains {1} tag with improper value {2}.\n";
    private static final String UNKNOWN_TAG_VALUE = "unknown";
    private static final String UNKNOWN_INSTRUCTION = "Road (Osm identifier: {0,number,#}) contains {1} tag with an 'unknown' value.\n";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Road (Osm identifier: {0,number,#}) contains {1} tag with an 'unknown' value.\n", "Road (Osm identifier: {0,number,#}) contains {1} tag with value {2} that is equivalent to a value equal to a common {3} tag value.\n", "Road (Osm identifier: {0,number,#}) contains {1} tag with improper value {2}.\n");
    private static final List<String> IMPROPER_NAMES_DEFAULT = Arrays.asList("street", "express", "avenue", "drive");
    private static final long serialVersionUID = -9218913713192411024L;
    private final List<String> improperNames;

    public ImproperAndUnknownRoadNameCheck(Configuration configuration) {
        super(configuration);
        this.improperNames = this.configurationValue(configuration, "names.improper", IMPROPER_NAMES_DEFAULT);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMasterEdge();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        if (!this.isFlagged(object.getOsmIdentifier())) {
            HashSet<String> instructions = new HashSet<String>();
            this.getAllNameTags(object).entrySet().forEach(entry -> this.updateInstructions((Map.Entry<String, String>)entry, (Set<String>)instructions, object.getOsmIdentifier()));
            if (!instructions.isEmpty()) {
                this.markAsFlagged(object.getOsmIdentifier());
                CheckFlag flag = this.createFlag(new OsmWayWalker((Edge)object).collectEdges(), "");
                flag.addInstructions(instructions);
                return Optional.of(flag);
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Map<String, String> getAllNameTags(AtlasObject object) {
        HashMap<String, String> relevantTags = new HashMap<String, String>();
        for (String key : object.getTags().keySet()) {
            for (String desiredKey : NameFinder.STANDARD_TAG_KEYS) {
                if (!key.startsWith(desiredKey)) continue;
                object.getTag(key).ifPresent(tag -> relevantTags.put(key, (String)tag));
            }
        }
        return relevantTags;
    }

    private void updateInstructions(Map.Entry<String, String> entry, Set<String> instructions, long osmIdentifier) {
        String tagKey = entry.getKey();
        String tagValue = entry.getValue();
        if (tagValue.equalsIgnoreCase(UNKNOWN_TAG_VALUE)) {
            instructions.add(this.getLocalizedInstruction(0, osmIdentifier, tagKey, tagValue));
        } else if (Arrays.stream(SurfaceTag.values()).anyMatch(surface -> StringUtils.equalsIgnoreCase(surface.toString(), tagValue))) {
            instructions.add(this.getLocalizedInstruction(1, osmIdentifier, tagKey, tagValue, "Surface"));
        } else if (Arrays.stream(BridgeTag.values()).anyMatch(bridge -> StringUtils.equalsIgnoreCase(bridge.toString(), tagValue))) {
            instructions.add(this.getLocalizedInstruction(1, osmIdentifier, tagKey, tagValue, "Bridge"));
        } else if (Arrays.stream(HighwayTag.values()).anyMatch(highway -> StringUtils.equalsIgnoreCase(highway.toString(), tagValue))) {
            instructions.add(this.getLocalizedInstruction(1, osmIdentifier, tagKey, tagValue, "Highway"));
        } else if (this.improperNames.stream().anyMatch(name -> name.equalsIgnoreCase(tagValue))) {
            instructions.add(this.getLocalizedInstruction(2, osmIdentifier, tagKey, tagValue));
        }
    }
}

