/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConflictingTagCombinationCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = -4239136867519896104L;
    private static final String INVALID_COMBINATION_INSTRUCTION = "OSM feature {0,number,#} has invalid tag combinations in 2 or more of the following tags: {1}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("OSM feature {0,number,#} has invalid tag combinations in 2 or more of the following tags: {1}.");
    private static final List<String> CONFLICTING_TAG_FILTERS_DEFAULT = Arrays.asList("highway->*&building->*||route->ferry||natural->*||landuse->*||place->*", "service->*&highway->!service&highway->!construction&railway->!&waterway->!canal");
    private List<TaggableFilter> conflictingTagFilters;
    private List<String> filterKeys;

    private static Set<String> getFilterKeys(TaggableFilter filter) {
        return Arrays.stream(filter.toString().split("[|&]+")).map(tag -> tag.split("->")[0]).collect(Collectors.toSet());
    }

    public ConflictingTagCombinationCheck(Configuration configuration) {
        super(configuration);
        List<String> filterStrings = this.configurationValue(configuration, "tags.conflicting.filters", CONFLICTING_TAG_FILTERS_DEFAULT);
        this.conflictingTagFilters = filterStrings.stream().map(TaggableFilter::forDefinition).collect(Collectors.toList());
        this.filterKeys = this.conflictingTagFilters.stream().map(filter -> String.join((CharSequence)", ", ConflictingTagCombinationCheck.getFilterKeys(filter))).collect(Collectors.toList());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Edge && HighwayTag.isCarNavigableHighway(object) && ((Edge)object).isMasterEdge() || object instanceof Line) && !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<String> instructions = new HashSet<String>();
        for (int filterIndex = 0; filterIndex < this.conflictingTagFilters.size(); ++filterIndex) {
            if (!this.conflictingTagFilters.get(filterIndex).test(object)) continue;
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            instructions.add(this.getLocalizedInstruction(0, object.getOsmIdentifier(), this.filterKeys.get(filterIndex)));
        }
        if (object instanceof Edge) {
            return instructions.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(new OsmWayWalker((Edge)object).collectEdges(), String.join((CharSequence)" ", instructions)));
        }
        return instructions.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(object, String.join((CharSequence)" ", instructions)));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

