/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.DestinationTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class InvalidSignBoardRelationCheck
extends BaseCheck<Long> {
    private static final String MISSING_DESTINATION_INSTRUCTION = "All type=destination_sign relations must have a destination= tag, but {0,number,#} is missing this tag. Please add this tag.";
    private static final String MISSING_MEMBER_INSTRUCTION = "All type=destination_sign relations must have a role={0} member, but {1,number,#} is missing this member.";
    private static final String EXTRA_MEMBER_INSTRUCTION = "All type=destination_sign relations must have exactly one role={0} member, but {1,number,#} has more than one.";
    private static final String WRONG_TYPE_INSTRUCTION = "In a type=destination_sign relation, the role={0} member must be a way, but {1,number,#} is a {2}.";
    private static final String FROM_TO_NO_MEETING_INSTRUCTION = "In a type=destination_sign relation, the role=from member must meet the role=to member, but they do not here.";
    private static final String DISCONNECTED_FROM_INSTRUCTION = "In a type=destination_sign relation, the role=from members must be connected.";
    private static final String TEMP_RELATION_ID_INSTRUCTION = "The relation with ID={0,number,#} is problematic.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("All type=destination_sign relations must have a destination= tag, but {0,number,#} is missing this tag. Please add this tag.", "All type=destination_sign relations must have a role={0} member, but {1,number,#} is missing this member.", "All type=destination_sign relations must have exactly one role={0} member, but {1,number,#} has more than one.", "In a type=destination_sign relation, the role={0} member must be a way, but {1,number,#} is a {2}.", "In a type=destination_sign relation, the role=from member must meet the role=to member, but they do not here.", "The relation with ID={0,number,#} is problematic.", "In a type=destination_sign relation, the role=from members must be connected.");
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final int MISSING_DESTINATION_INDEX = 0;
    private static final int MISSING_MEMBER_INDEX = 1;
    private static final int EXTRA_MEMBER_INDEX = 2;
    private static final int WRONG_TYPE_INDEX = 3;
    private static final int FROM_TO_NO_MEETING_INDEX = 4;
    private static final int TEMP_RELATION_ID_INDEX = 5;
    private static final int DISCONNECTED_FROM_INDEX = 6;

    public InvalidSignBoardRelationCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.DESTINATION_SIGN});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation signBoard = (Relation)object;
        ArrayList<String> instructions = new ArrayList<String>();
        instructions.add(this.getLocalizedInstruction(5, signBoard.getOsmIdentifier()));
        if (!Validators.hasValuesFor(signBoard, DestinationTag.class)) {
            instructions.add(this.getLocalizedInstruction(0, signBoard.getOsmIdentifier()));
        }
        Map<String, List<RelationMember>> membersByRole = signBoard.members().stream().collect(Collectors.groupingBy(RelationMember::getRole));
        Tuple<Optional<String>, Optional<Route>> fromRouteAndReasons = this.fromRoute(membersByRole.getOrDefault(FROM, Collections.emptyList()), signBoard.getOsmIdentifier());
        Tuple<Optional<String>, Optional<Route>> toRouteAndReasons = this.toRoute(membersByRole.getOrDefault(TO, Collections.emptyList()), signBoard.getOsmIdentifier());
        fromRouteAndReasons.getFirst().ifPresent(instructions::add);
        toRouteAndReasons.getFirst().ifPresent(instructions::add);
        if (!fromRouteAndReasons.getSecond().flatMap(fromRoute -> ((Optional)toRouteAndReasons.getSecond()).map(toRoute -> this.fromAndToMeet((Route)fromRoute, (Route)toRoute))).orElse(false).booleanValue()) {
            instructions.add(this.getLocalizedInstruction(4, new Object[0]));
        }
        return instructions.size() == 1 ? Optional.empty() : Optional.of(this.createFlag(signBoard.flatten(), instructions));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean edgesMeet(Edge fromEdge, Edge toEdge) {
        return fromEdge.end().equals(toEdge.start());
    }

    private boolean fromAndToMeet(Route fromRoute, Route toRoute) {
        Optional<Edge> fromReversedOptional = fromRoute.reverse().map(Route::end);
        Optional<Edge> toReversedOptional = toRoute.reverse().map(Route::start);
        return this.edgesMeet(fromRoute.end(), toRoute.start()) || toReversedOptional.map(toReversed -> this.edgesMeet(fromRoute.end(), (Edge)toReversed)).orElse(false) != false || fromReversedOptional.map(fromReversed -> this.edgesMeet((Edge)fromReversed, toRoute.start())).orElse(false) != false || fromReversedOptional.flatMap(fromReversed -> toReversedOptional.map(toReversed -> this.edgesMeet((Edge)fromReversed, (Edge)toReversed))).orElse(false) != false;
    }

    private Tuple<Optional<String>, Optional<Route>> fromRoute(List<RelationMember> members, long signboardOsmIdentifier) {
        Optional<String> nonEdgeReason = this.getNonEdgeReasonFromMembers(members, FROM);
        if (nonEdgeReason.isPresent()) {
            return Tuple.createTuple(nonEdgeReason, Optional.empty());
        }
        Set<Edge> allEdges = members.stream().map(RelationMember::getEntity).map(member -> (Edge)member).map(this::getOsmEdges).flatMap(Collection::stream).collect(Collectors.toSet());
        if (allEdges.isEmpty()) {
            return Tuple.createTuple(Optional.of(this.getLocalizedInstruction(1, FROM, signboardOsmIdentifier)), Optional.empty());
        }
        try {
            return Tuple.createTuple(Optional.empty(), Optional.of(Route.fromNonArrangedEdgeSet(allEdges, false)));
        }
        catch (CoreException error) {
            return Tuple.createTuple(Optional.of(this.getLocalizedInstruction(6, new Object[0])), Optional.empty());
        }
    }

    private Optional<String> getNonEdgeReasonFromMembers(List<RelationMember> members, String role) {
        return members.stream().map(RelationMember::getEntity).filter(member -> !member.getType().equals((Object)ItemType.EDGE)).findAny().map(nonEdge -> this.getLocalizedInstruction(3, role, nonEdge.getOsmIdentifier(), this.osmTypeFromAtlasType(nonEdge.getType())));
    }

    private Set<Edge> getOsmEdges(Edge edge) {
        OsmWayWalker walker = new OsmWayWalker(edge);
        return walker.collectEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
    }

    private String osmTypeFromAtlasType(ItemType itemType) {
        switch (itemType) {
            case NODE: 
            case POINT: {
                return "node";
            }
            case EDGE: 
            case LINE: 
            case AREA: {
                return "way";
            }
            case RELATION: {
                return "relation";
            }
        }
        throw new CoreException("ItemType had an unexpected value");
    }

    private Tuple<Optional<String>, Optional<Route>> toRoute(List<RelationMember> members, long osmIdentifier) {
        Optional<String> nonEdgeReason = this.getNonEdgeReasonFromMembers(members, TO);
        if (nonEdgeReason.isPresent()) {
            return Tuple.createTuple(nonEdgeReason, Optional.empty());
        }
        Set ways = members.stream().map(RelationMember::getEntity).map(member -> (Edge)member).map(this::getOsmEdges).filter(edges -> !edges.isEmpty()).map(edges -> Route.fromNonArrangedEdgeSet(edges, false)).collect(Collectors.toSet());
        if (ways.size() > 1) {
            return Tuple.createTuple(Optional.of(this.getLocalizedInstruction(2, TO, osmIdentifier)), Optional.empty());
        }
        if (ways.isEmpty()) {
            return Tuple.createTuple(Optional.of(this.getLocalizedInstruction(1, TO, osmIdentifier)), Optional.empty());
        }
        return Tuple.createTuple(Optional.empty(), Optional.of((Route)Iterables.getOnlyElement(ways)));
    }
}

