/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.NoExitTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class ConnectivityCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Node {0,number,#} is likely supposed to be connected to: {1}");
    private static final double NEARBY_EDGE_THRESHOLD_DISTANCE_METERS_DEFAULT = 2.0;
    private static final double THRESHOLD_SCALE = 1.5;
    private static final int MAXIMUM_ANGLE = 180;
    private static final String DEFAULT_BLACKLISTED_HIGHWAYS_TAG_FILTER = "highway->no";
    private static final long serialVersionUID = -380675222726130708L;
    private final TaggableFilter blacklistedHighwaysTaggableFilter;
    private final Distance threshold;

    public ConnectivityCheck(Configuration configuration) {
        super(configuration);
        this.threshold = this.configurationValue(configuration, "nearby.edge.distance.meters", 2.0, Distance::meters);
        this.blacklistedHighwaysTaggableFilter = TaggableFilter.forDefinition(this.configurationValue(configuration, "blacklisted.highway.filter", DEFAULT_BLACKLISTED_HIGHWAYS_TAG_FILTER));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Node && !SyntheticBoundaryNodeTag.isSyntheticBoundaryNode(object) && !this.isFlagged(object.getOsmIdentifier()) && !BarrierTag.isBarrier(object) && !Validators.isOfType((Taggable)object, NoExitTag.class, (Enum[])new NoExitTag[]{NoExitTag.YES}) && !this.connectedEdgesHaveLevelTags((Node)object) && ((Node)object).connectedEdges().stream().anyMatch(this::validEdgeFilter);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Node node = (Node)object;
        Rectangle box = node.getLocation().boxAround(this.threshold);
        CheckFlag connectivityFlag = new CheckFlag(this.getTaskIdentifier(object));
        ArrayList<CallSite> disconnectedObjects = new ArrayList<CallSite>();
        Map<Long, Set<Edge>> nodeLayerMap = this.getLayerMap(node);
        Iterable<Edge> nearbyEdges = object.getAtlas().edgesIntersecting(box, edge -> !LevelTag.getTaggedValue(edge).isPresent() && nodeLayerMap.containsKey(LayerTag.getTaggedOrImpliedValue(edge, LayerTag.ZERO)) && !this.differentLayersIntersect(nodeLayerMap, (Edge)edge) && !this.differentLayersIntersect(nodeLayerMap, edge.connectedEdges()));
        SortedSet<Edge> connectedEdges = node.connectedEdges();
        connectivityFlag.addObject(object);
        for (Node nodeNearby : object.getAtlas().nodesWithin(box, nearbyNode -> {
            if (this.connectedEdgesHaveLevelTags((Node)nearbyNode)) return false;
            if (this.differentLayersIntersect(nodeLayerMap, nearbyNode.connectedEdges())) return false;
            if (!this.getLayerMap((Node)nearbyNode).keySet().stream().anyMatch(nodeLayerMap::containsKey)) return false;
            return true;
        })) {
            if (SyntheticBoundaryNodeTag.isSyntheticBoundaryNode(nodeNearby) || node.equals(nodeNearby) || BarrierTag.isBarrier(nodeNearby) || Validators.isOfType((Taggable)nodeNearby, NoExitTag.class, (Enum[])new NoExitTag[]{NoExitTag.YES}) || !nodeNearby.connectedEdges().stream().anyMatch(this::validEdgeFilter) || this.hasValidConnection(node, connectedEdges, nodeNearby)) continue;
            this.markAsFlagged(nodeNearby.getOsmIdentifier());
            connectivityFlag.addObject(nodeNearby);
            disconnectedObjects.add((CallSite)((Object)("node " + nodeNearby.getOsmIdentifier())));
        }
        for (Edge edgeNearby : nearbyEdges) {
            if (!edgeNearby.isMasterEdge() || !this.validEdgeFilter(edgeNearby) || connectedEdges.contains(edgeNearby) || this.hasValidConnection(node, connectedEdges, edgeNearby) || !node.snapTo(edgeNearby).getDistance().isLessThanOrEqualTo(this.threshold.scaleBy(1.5))) continue;
            connectivityFlag.addObject(edgeNearby);
            disconnectedObjects.add((CallSite)((Object)("way " + edgeNearby.getOsmIdentifier())));
        }
        if (connectivityFlag.getFlaggedObjects().size() > 1) {
            this.markAsFlagged(object.getOsmIdentifier());
            connectivityFlag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier(), String.join((CharSequence)", ", disconnectedObjects)));
            return Optional.of(connectivityFlag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean connectedEdgesHaveLevelTags(Node node) {
        return node.connectedEdges().stream().anyMatch(connectedEdge -> LevelTag.getTaggedValue(connectedEdge).isPresent());
    }

    private boolean differentLayersIntersect(Map<Long, Set<Edge>> nodeLayerMap, Edge edge) {
        long edgeLayerValue = LayerTag.getTaggedOrImpliedValue(edge, LayerTag.ZERO);
        return nodeLayerMap.entrySet().stream().anyMatch(entry -> !((Long)entry.getKey()).equals(edgeLayerValue) && ((Set)entry.getValue()).stream().anyMatch(connectedEdge -> connectedEdge.asPolyLine().intersects(edge.asPolyLine())));
    }

    private boolean differentLayersIntersect(Map<Long, Set<Edge>> nodeLayerMap, Set<Edge> edges) {
        return edges.stream().anyMatch(edge -> this.differentLayersIntersect(nodeLayerMap, (Edge)edge));
    }

    private Optional<Heading> getConnectedHeading(Location firstLocation, Location lastLocation) {
        return new PolyLine(firstLocation, lastLocation).overallHeading();
    }

    private Optional<Heading> getEdgeHeadingFromNode(Edge firstEdge, Node node) {
        return firstEdge.end().equals(node) ? firstEdge.asPolyLine().reversed().initialHeading() : firstEdge.asPolyLine().initialHeading();
    }

    private Optional<Heading> getHeadingFromSnap(Location snappedLocation, Edge previousEdge, Edge lastEdge) {
        Location lastPreviousEdgeLocation;
        Location location = lastPreviousEdgeLocation = lastEdge.connectedNodes().contains(previousEdge.end()) ? previousEdge.end().getLocation() : previousEdge.start().getLocation();
        if (lastPreviousEdgeLocation.equals(snappedLocation)) {
            if (previousEdge.start().getLocation().equals(lastPreviousEdgeLocation)) {
                return previousEdge.asPolyLine().initialHeading();
            }
            return previousEdge.asPolyLine().reversed().initialHeading();
        }
        return new PolyLine(snappedLocation, lastPreviousEdgeLocation).overallHeading();
    }

    private Map<Long, Set<Edge>> getLayerMap(Node node) {
        HashMap<Long, Set<Edge>> layerMap = new HashMap<Long, Set<Edge>>();
        node.connectedEdges().forEach(edge -> {
            long edgeLayerValue = LayerTag.getTaggedOrImpliedValue(edge, LayerTag.ZERO);
            layerMap.putIfAbsent(edgeLayerValue, new HashSet());
            ((Set)layerMap.get(edgeLayerValue)).add(edge);
        });
        return layerMap;
    }

    private boolean hasValidConnection(Node node, Set<Edge> firstEdges, Node toFind) {
        HashSet visitedEdges = new HashSet();
        HashSet secondEdges = new HashSet();
        ArrayDeque<Edge> edgesToCheck = new ArrayDeque<Edge>(firstEdges);
        Edge rootEdge = (Edge)edgesToCheck.peek();
        while (!edgesToCheck.isEmpty()) {
            Edge checking = (Edge)edgesToCheck.pop();
            boolean firstEdge = firstEdges.contains(checking);
            if (firstEdge) {
                if (checking.connectedNodes().contains(toFind)) {
                    return true;
                }
                rootEdge = checking;
                visitedEdges.clear();
                secondEdges.clear();
            } else if (checking.connectedNodes().contains(toFind) && this.isConverging(node, rootEdge, toFind, checking)) {
                return true;
            }
            if (!firstEdge && !secondEdges.contains(checking)) continue;
            checking.connectedEdges().forEach(edge -> {
                if (!visitedEdges.contains(edge) && !firstEdges.contains(edge) && edge.isMasterEdge()) {
                    edgesToCheck.push((Edge)edge);
                    visitedEdges.add(edge);
                }
                if (firstEdge) {
                    secondEdges.add(edge);
                }
            });
        }
        return false;
    }

    private boolean hasValidConnection(Node node, Set<Edge> firstEdges, Edge toFind) {
        Edge rootEdge;
        HashSet visitedEdges = new HashSet();
        HashSet secondEdges = new HashSet();
        ArrayDeque<Edge> edgesToCheck = new ArrayDeque<Edge>(firstEdges);
        Edge previousEdge = rootEdge = (Edge)edgesToCheck.peek();
        while (!edgesToCheck.isEmpty()) {
            Edge checking = (Edge)edgesToCheck.pop();
            boolean firstEdge = firstEdges.contains(checking);
            boolean secondEdge = secondEdges.contains(checking);
            if (firstEdge) {
                rootEdge = checking;
                visitedEdges.clear();
                secondEdges.clear();
            } else if (checking.equals(toFind) && this.isConverging(node, rootEdge, secondEdge ? rootEdge : previousEdge, checking)) {
                return true;
            }
            if (!firstEdge && !secondEdge) continue;
            previousEdge = checking;
            checking.connectedEdges().forEach(edge -> {
                if (!visitedEdges.contains(edge) && !firstEdges.contains(edge) && edge.isMasterEdge()) {
                    edgesToCheck.push((Edge)edge);
                    visitedEdges.add(edge);
                }
                if (firstEdge) {
                    secondEdges.add(edge);
                }
            });
        }
        return false;
    }

    private boolean headingsFormTriangle(Optional<Heading> firstHeading, Optional<Heading> connectionHeading, Optional<Heading> lastHeading) {
        return firstHeading.isPresent() && lastHeading.isPresent() && connectionHeading.isPresent() && firstHeading.get().difference(connectionHeading.get()).asDegrees() + connectionHeading.get().add(Angle.degrees(180.0)).difference(lastHeading.get()).asDegrees() < 180.0;
    }

    private boolean isConverging(Node node, Edge firstEdge, Node endNode, Edge lastEdge) {
        Optional<Heading> firstHeading = this.getEdgeHeadingFromNode(firstEdge, node);
        Optional<Heading> lastHeading = lastEdge.start().equals(endNode) ? lastEdge.asPolyLine().initialHeading() : lastEdge.asPolyLine().reversed().initialHeading();
        Optional<Heading> connectionHeading = this.getConnectedHeading(node.getLocation(), endNode.getLocation());
        return this.headingsFormTriangle(firstHeading, connectionHeading, lastHeading);
    }

    private boolean isConverging(Node node, Edge firstEdge, Edge previousEdge, Edge lastEdge) {
        Snapper.SnappedLocation snappedLocation = node.snapTo(lastEdge);
        if (!node.getLocation().equals(snappedLocation)) {
            Optional<Heading> firstHeading = this.getEdgeHeadingFromNode(firstEdge, node);
            Optional<Heading> lastHeading = this.getHeadingFromSnap(snappedLocation, previousEdge, lastEdge);
            Optional<Heading> connectionHeading = this.getConnectedHeading(node.getLocation(), snappedLocation);
            return this.headingsFormTriangle(firstHeading, connectionHeading, lastHeading);
        }
        return false;
    }

    private boolean validEdgeFilter(Edge edge) {
        return HighwayTag.isCarNavigableHighway(edge) && !this.blacklistedHighwaysTaggableFilter.test(edge) && !BarrierTag.isBarrier(edge);
    }
}

